/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.model.jpa;

import java.sql.Date;
import java.time.LocalDate;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.silverpeas.core.persistence.datasource.SQLDateTimeConstants;

@Converter(autoApply=true)
public class LocalDateAttributeConverter
implements AttributeConverter<LocalDate, Date> {
    public Date convertToDatabaseColumn(LocalDate locDate) {
        if (locDate == null) {
            return null;
        }
        if (locDate.equals(LocalDate.MIN)) {
            return SQLDateTimeConstants.MIN_DATE;
        }
        if (locDate.equals(LocalDate.MAX)) {
            return SQLDateTimeConstants.MAX_DATE;
        }
        return Date.valueOf(locDate);
    }

    public LocalDate convertToEntityAttribute(Date sqlDate) {
        if (sqlDate == null) {
            return null;
        }
        if (sqlDate.toLocalDate().equals(SQLDateTimeConstants.MIN_DATE.toLocalDate())) {
            return LocalDate.MIN;
        }
        if (sqlDate.toLocalDate().equals(SQLDateTimeConstants.MAX_DATE.toLocalDate())) {
            return LocalDate.MAX;
        }
        return sqlDate.toLocalDate();
    }
}

