/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.notification.user.client.ExternalRecipient;
import org.silverpeas.core.notification.user.client.GroupRecipient;
import org.silverpeas.core.notification.user.client.NotificationManager;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.notification.user.client.NotificationTemplateKey;
import org.silverpeas.core.notification.user.client.UserRecipient;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.template.SilverpeasTemplates;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.Link;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class NotificationMetaData
implements Serializable {
    private static final long serialVersionUID = 6004274748540324759L;
    public static final String BEFORE_MESSAGE_FOOTER_TAG = "<!--BEFORE_MESSAGE_FOOTER-->";
    public static final String AFTER_MESSAGE_FOOTER_TAG = "<!--AFTER_MESSAGE_FOOTER-->";
    private static final String SENDER_MESSAGE_ATTRIBUTE = "senderMessage";
    private static final String BREAK_LINE_REGEXP = "[\\n\\r]";
    private int messageType;
    private Date date;
    private String sender;
    private String source;
    private String sessionId;
    private final Collection<UserRecipient> userRecipients = new ArrayList<UserRecipient>();
    private final Collection<UserRecipient> userRecipientsToExclude = new ArrayList<UserRecipient>();
    private final Collection<GroupRecipient> groupRecipients = new ArrayList<GroupRecipient>();
    private String externalLanguage = null;
    private final Collection<ExternalRecipient> externalRecipients = new ArrayList<ExternalRecipient>();
    private String componentId;
    private boolean isAnswerAllowed = false;
    private String fileName;
    private boolean sendImmediately = false;
    private NotifAction action;
    private final Map<String, NotificationResourceData> notificationResourceData = new HashMap<String, NotificationResourceData>();
    private final Map<String, String> titles = new HashMap<String, String>();
    private final Map<String, String> contents = new HashMap<String, String>();
    private final Map<String, Link> links = new HashMap<String, Link>();
    private transient Map<String, SilverpeasTemplate> templates;
    private transient Map<String, SilverpeasTemplate> templatesMessageFooter;
    private String originalExtraMessage = null;
    private boolean displayReceiversInFooter = false;
    private boolean isManualUserOne = false;

    public NotificationMetaData() {
        this.reset();
    }

    public NotificationMetaData(int messageType, String title, String content) {
        this.reset();
        this.messageType = messageType;
        this.templates = new HashMap<String, SilverpeasTemplate>();
        this.addLanguage(DisplayI18NHelper.getDefaultLanguage(), title, content);
    }

    public NotificationMetaData(int messageType, String title, Map<String, SilverpeasTemplate> templates, String fileName) {
        this(messageType, title, "");
        this.reset();
        this.templates = templates;
        this.fileName = fileName;
    }

    private void reset() {
        this.messageType = 0;
        this.date = new Date();
        this.sender = "";
        this.source = "";
        this.sessionId = "";
        this.componentId = "";
        this.isAnswerAllowed = false;
        this.fileName = null;
        this.templates = new HashMap<String, SilverpeasTemplate>();
        this.templatesMessageFooter = new HashMap<String, SilverpeasTemplate>();
        this.action = null;
        this.notificationResourceData.clear();
    }

    public final void addLanguage(String language, String title, String content) {
        this.titles.put(language, title);
        this.contents.put(language, content);
    }

    public Set<String> getLanguages() {
        HashSet<String> languages = new HashSet<String>(this.titles.keySet());
        languages.addAll(this.templates.keySet());
        return languages;
    }

    public Map<String, String> getSimpleContents() {
        return Collections.unmodifiableMap(this.contents);
    }

    public Map<String, SilverpeasTemplate> getTemplateContents() {
        return Collections.unmodifiableMap(this.templates);
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void setTitle(String title) {
        this.titles.put(DisplayI18NHelper.getDefaultLanguage(), title);
    }

    public void setTitle(String title, String language) {
        this.titles.put(language, title);
    }

    public String getTitle() {
        return this.getTitle(DisplayI18NHelper.getDefaultLanguage());
    }

    public String getTitle(String language) {
        String result = "";
        if (this.templates != null && !this.templates.isEmpty()) {
            SilverpeasTemplate template = this.templates.get(language);
            if (template != null) {
                result = template.applyStringTemplate(this.titles.get(language));
            }
        } else {
            result = this.titles.get(language);
        }
        return result;
    }

    public void setContent(String content) {
        this.contents.put(DisplayI18NHelper.getDefaultLanguage(), content);
    }

    public void setContent(String content, String language) {
        this.contents.put(language, content);
    }

    public String getContent() {
        return this.getContent(DisplayI18NHelper.getDefaultLanguage());
    }

    public String getContent(String language) {
        StringBuilder result = new StringBuilder();
        this.appendMessageContent(result, language);
        this.appendExtraMessageHtmlFragment(result, language);
        result.append(BEFORE_MESSAGE_FOOTER_TAG);
        SilverpeasTemplate templateMessageFooter = this.getTemplateMessageFooter(language);
        if (templateMessageFooter != null && this.displayReceiversInFooter) {
            try {
                String receiverGroups;
                String receiverUsers = this.getUserReceiverFormattedList();
                if (StringUtil.isDefined((String)receiverUsers)) {
                    templateMessageFooter.setAttribute(NotificationTemplateKey.NOTIFICATION_RECEIVER_USERS.toString(), receiverUsers);
                }
                if (StringUtil.isDefined((String)(receiverGroups = this.getGroupReceiverFormattedList()))) {
                    templateMessageFooter.setAttribute(NotificationTemplateKey.NOTIFICATION_RECEIVER_GROUPS.toString(), receiverGroups);
                }
            }
            catch (NotificationException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
            }
            String messageFooter = templateMessageFooter.applyFileTemplate("messageFooter_" + language).replaceAll(BREAK_LINE_REGEXP, "");
            if (!messageFooter.isEmpty()) {
                result.append(messageFooter);
            }
        }
        result.append(AFTER_MESSAGE_FOOTER_TAG);
        return WebEncodeHelper.convertBlanksForHtml(result.toString());
    }

    private void appendMessageContent(StringBuilder result, String language) {
        if (this.templates != null && !this.templates.isEmpty()) {
            SilverpeasTemplate template = this.templates.get(language);
            if (template != null) {
                result.append(template.applyFileTemplate(this.fileName + "_" + language));
            }
        } else {
            String content = this.contents.get(language);
            if (content != null) {
                result.append(content);
            }
        }
    }

    private void appendExtraMessageHtmlFragment(StringBuilder messageContent, String language) {
        String extraMessage = this.getOriginalExtraMessage();
        if (StringUtil.isDefined((String)extraMessage) && !messageContent.toString().replaceAll(BREAK_LINE_REGEXP, "").contains(extraMessage.replaceAll(BREAK_LINE_REGEXP, ""))) {
            SilverpeasTemplate templateRepository = SilverpeasTemplates.createSilverpeasTemplateOnCore("notification");
            templateRepository.setAttribute(SENDER_MESSAGE_ATTRIBUTE, extraMessage);
            messageContent.append(templateRepository.applyFileTemplate("extraMessage_" + DisplayI18NHelper.verifyLanguage(language)));
        }
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void setAnswerAllowed(boolean answerAllowed) {
        this.isAnswerAllowed = answerAllowed;
    }

    public String getSender() {
        return this.sender;
    }

    public boolean isAnswerAllowed() {
        return this.isAnswerAllowed;
    }

    public Link getLink() {
        return this.getLink(DisplayI18NHelper.getDefaultLanguage());
    }

    public Link getLink(String language) {
        Link link = this.links.get(language);
        if (link == null) {
            return Link.EMPTY_LINK;
        }
        return link;
    }

    public void setLink(String link) {
        this.links.put(DisplayI18NHelper.getDefaultLanguage(), new Link(link, ""));
    }

    public void setLink(Link link) {
        this.setLink(link, DisplayI18NHelper.getDefaultLanguage());
    }

    public void setLink(Link link, String language) {
        this.links.put(language, link);
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setAttachmentTargetId(String attachmentTargetId) {
        if (StringUtil.isDefined((String)attachmentTargetId)) {
            this.notificationResourceData.forEach((key, value) -> value.setAttachmentTargetId(attachmentTargetId));
        }
    }

    public void setUserRecipients(Collection<UserRecipient> users) {
        this.userRecipients.clear();
        if (users != null) {
            this.addUserRecipients(users);
        }
    }

    public Collection<UserRecipient> getUserRecipients() {
        return Collections.unmodifiableCollection(this.userRecipients);
    }

    public void addUserRecipient(UserRecipient user) {
        if (User.isActivatedStateFor(user.getUserId())) {
            this.userRecipients.add(user);
        }
    }

    public void addUserRecipients(UserRecipient ... users) {
        if (users != null) {
            this.addUserRecipients(Arrays.asList(users));
        }
    }

    public void addUserRecipients(Collection<UserRecipient> users) {
        if (users != null) {
            for (UserRecipient userRecipient : users) {
                this.addUserRecipient(userRecipient);
            }
        }
    }

    public Collection<UserRecipient> getUserRecipientsToExclude() {
        return Collections.unmodifiableCollection(this.userRecipientsToExclude);
    }

    public void addUserRecipientToExclude(UserRecipient user) {
        this.userRecipientsToExclude.add(user);
    }

    public String getExternalLanguage() {
        return Optional.ofNullable(this.externalLanguage).orElse(DisplayI18NHelper.getDefaultLanguage());
    }

    public void setExternalLanguage(String externalLanguage) {
        this.externalLanguage = externalLanguage;
    }

    public Collection<ExternalRecipient> getExternalRecipients() {
        return Collections.unmodifiableCollection(this.externalRecipients);
    }

    public void setExternalRecipients(Collection<ExternalRecipient> externalRecipients) {
        this.externalRecipients.clear();
        if (externalRecipients != null) {
            for (ExternalRecipient recipient : externalRecipients) {
                this.addExternalRecipient(recipient);
            }
        }
    }

    public void addExternalRecipient(ExternalRecipient externalRecipient) {
        this.externalRecipients.add(externalRecipient);
    }

    public void setGroupRecipients(Collection<GroupRecipient> groups) {
        this.groupRecipients.clear();
        if (groups != null) {
            this.addGroupRecipients(groups);
        }
    }

    public Collection<GroupRecipient> getGroupRecipients() {
        return Collections.unmodifiableCollection(this.groupRecipients);
    }

    public void addGroupRecipient(GroupRecipient group) {
        this.groupRecipients.add(group);
    }

    public void addGroupRecipients(Collection<GroupRecipient> groups) {
        if (groups != null) {
            this.groupRecipients.addAll(groups);
        }
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public void addExtraMessage(String message, String language) {
        this.addExtraMessage(message, language, true);
    }

    public void addExtraMessage(String message, String language, boolean encode) {
        String msg = encode ? Encode.forHtml((String)message) : message;
        this.setOriginalExtraMessage(msg);
        if (this.templates != null && !this.templates.isEmpty()) {
            this.templates.get(language).setAttribute(SENDER_MESSAGE_ATTRIBUTE, msg);
        }
    }

    public String getOriginalExtraMessage() {
        return this.originalExtraMessage;
    }

    public void setOriginalExtraMessage(String originalExtraMessage) {
        this.originalExtraMessage = originalExtraMessage;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isSendImmediately() {
        return this.sendImmediately;
    }

    public void setSendImmediately(boolean sendImmediately) {
        this.sendImmediately = sendImmediately;
    }

    public NotifAction getAction() {
        return this.action;
    }

    public void setAction(NotifAction action) {
        this.action = action;
    }

    public void setNotificationResourceData(NotificationResourceData notificationResourceData) {
        this.setNotificationResourceData(DisplayI18NHelper.getDefaultLanguage(), notificationResourceData);
    }

    public void setNotificationResourceData(String lang, NotificationResourceData notificationResourceData) {
        this.notificationResourceData.put(lang, notificationResourceData);
    }

    public NotificationResourceData getNotificationResourceData() {
        return this.getNotificationResourceData(DisplayI18NHelper.getDefaultLanguage());
    }

    public NotificationResourceData getNotificationResourceData(String lang) {
        return this.notificationResourceData.get(lang);
    }

    public boolean isSendByAUser() {
        return StringUtil.isInteger((String)this.getSender());
    }

    private SilverpeasTemplate createTemplateMessageFooter(String language) {
        SilverpeasTemplate templateFooter = SilverpeasTemplates.createSilverpeasTemplateOnCore("notification");
        this.templatesMessageFooter.put(language, templateFooter);
        return templateFooter;
    }

    public SilverpeasTemplate getTemplateMessageFooter(String language) {
        SilverpeasTemplate templateMessageFooter;
        if (this.templatesMessageFooter == null) {
            this.templatesMessageFooter = new HashMap<String, SilverpeasTemplate>();
        }
        if ((templateMessageFooter = this.templatesMessageFooter.get(language)) == null) {
            templateMessageFooter = this.createTemplateMessageFooter(language);
        }
        return templateMessageFooter;
    }

    public Set<UserRecipient> getAllUserRecipients() throws NotificationException {
        return this.getAllUserRecipients(false);
    }

    public Set<UserRecipient> getAllUserRecipients(boolean updateInternalUserRecipientsToExclude) throws NotificationException {
        Collection<UserRecipient> users = this.getUserRecipients();
        Collection<GroupRecipient> groups = this.getGroupRecipients();
        HashSet<UserRecipient> usersToExclude = updateInternalUserRecipientsToExclude ? this.getUserRecipientsToExclude() : new HashSet<UserRecipient>(this.getUserRecipientsToExclude());
        HashSet<UserRecipient> allUniqueUserRecipients = new HashSet<UserRecipient>(users);
        NotificationManager notificationManager = this.getNotificationManager();
        for (GroupRecipient group : groups) {
            allUniqueUserRecipients.addAll(notificationManager.getUsersFromGroup(group.getGroupId()));
        }
        allUniqueUserRecipients.removeAll(usersToExclude);
        return allUniqueUserRecipients;
    }

    private Set<UserRecipient> getUsersForReceiverBlock() throws NotificationException {
        HashSet<UserRecipient> usersSet = new HashSet<UserRecipient>(this.getUserRecipients());
        NotificationManager notificationManager = this.getNotificationManager();
        for (GroupRecipient group : this.getGroupRecipients()) {
            if (this.displayGroup(group.getGroupId())) continue;
            usersSet.addAll(notificationManager.getUsersFromGroup(group.getGroupId()));
        }
        usersSet.removeAll(this.getUserRecipientsToExclude());
        return usersSet;
    }

    protected boolean displayGroup(String groupId) {
        int threshold = NotificationManagerSettings.getReceiverThresholdAfterThatReplaceUserNameListByGroupName();
        Group group = Group.getById(groupId);
        int nbUsers = group.getDirectUsersCount();
        boolean res1 = NotificationManagerSettings.isDisplayingUserNameListInsteadOfGroupEnabled();
        boolean res2 = threshold > 0 && nbUsers > threshold;
        return res1 || res2;
    }

    private String getUserReceiverFormattedList() throws NotificationException {
        StringBuilder users = new StringBuilder();
        if (NotificationManagerSettings.isDisplayingReceiversInNotificationMessageEnabled() && this.displayReceiversInFooter) {
            Set<UserRecipient> usersSet = this.getUsersForReceiverBlock();
            boolean first = true;
            for (UserRecipient anUsersSet : usersSet) {
                if (!first) {
                    users.append(", ");
                }
                users.append(User.getById(anUsersSet.getUserId()).getDisplayedName());
                first = false;
            }
        }
        return users.toString();
    }

    private Set<GroupRecipient> getGroupsForReceiverBlock() {
        HashSet<GroupRecipient> groupsSet = new HashSet<GroupRecipient>();
        for (GroupRecipient group : this.getGroupRecipients()) {
            if (!this.displayGroup(group.getGroupId())) continue;
            groupsSet.add(group);
        }
        return groupsSet;
    }

    private String getGroupReceiverFormattedList() {
        StringBuilder groups = new StringBuilder();
        if (NotificationManagerSettings.isDisplayingReceiversInNotificationMessageEnabled() && this.displayReceiversInFooter) {
            Set<GroupRecipient> groupsSet = this.getGroupsForReceiverBlock();
            boolean first = true;
            for (GroupRecipient aGroupsSet : groupsSet) {
                if (!first) {
                    groups.append(", ");
                }
                groups.append(Group.getById(aGroupsSet.getGroupId()).getName());
                first = false;
            }
        }
        return groups.toString();
    }

    public NotificationMetaData displayReceiversInFooter() {
        this.displayReceiversInFooter = true;
        return this;
    }

    public NotificationMetaData manualUserNotification() {
        this.isManualUserOne = true;
        return this;
    }

    public boolean isManualUserOne() {
        return this.isManualUserOne;
    }

    private NotificationManager getNotificationManager() {
        return NotificationManager.get();
    }
}

