/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.EveryoneMembershipProvider;
import org.apache.jackrabbit.oak.spi.security.user.DynamicMembershipProvider;
import org.apache.jackrabbit.oak.spi.security.user.DynamicMembershipService;
import org.apache.jackrabbit.oak.spi.whiteboard.AbstractServiceTracker;
import org.jetbrains.annotations.NotNull;

public class DynamicMembershipTracker
extends AbstractServiceTracker<DynamicMembershipService>
implements DynamicMembershipService {
    public DynamicMembershipTracker() {
        super(DynamicMembershipService.class);
    }

    @NotNull
    public DynamicMembershipProvider getDynamicMembershipProvider(@NotNull Root root, @NotNull UserManager userManager, @NotNull NamePathMapper namePathMapper) {
        EveryoneMembershipProvider defaultProvider = new EveryoneMembershipProvider(userManager, namePathMapper);
        List services = this.getServices();
        if (services.isEmpty()) {
            return defaultProvider;
        }
        return DynamicMembershipTracker.createProvider(root, userManager, namePathMapper, defaultProvider, services);
    }

    private static DynamicMembershipProvider createProvider(@NotNull Root root, @NotNull UserManager userManager, @NotNull NamePathMapper namePathMapper, @NotNull DynamicMembershipProvider defaultProvider, @NotNull List<DynamicMembershipService> services) {
        ArrayList<DynamicMembershipProvider> providers = new ArrayList<DynamicMembershipProvider>(1 + services.size());
        providers.add(defaultProvider);
        for (DynamicMembershipService service : services) {
            DynamicMembershipProvider dmp = service.getDynamicMembershipProvider(root, userManager, namePathMapper);
            if (DynamicMembershipProvider.EMPTY == dmp) continue;
            providers.add(dmp);
        }
        if (providers.size() == 1) {
            return defaultProvider;
        }
        return new CompositeProvider(providers);
    }

    private static class CompositeProvider
    implements DynamicMembershipProvider {
        private final List<DynamicMembershipProvider> providers;

        private CompositeProvider(@NotNull List<DynamicMembershipProvider> providers) {
            this.providers = providers;
        }

        public boolean coversAllMembers(@NotNull Group group) {
            for (DynamicMembershipProvider provider : this.providers) {
                if (!provider.coversAllMembers(group)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public Iterator<Authorizable> getMembers(@NotNull Group group, boolean includeInherited) throws RepositoryException {
            int size = this.providers.size();
            Iterator[] members = new Iterator[size];
            for (int i = 0; i < size; ++i) {
                members[i] = this.providers.get(i).getMembers(group, includeInherited);
            }
            return IteratorUtils.chainedIterator((Iterator[])members);
        }

        public boolean isMember(@NotNull Group group, @NotNull Authorizable authorizable, boolean includeInherited) throws RepositoryException {
            for (DynamicMembershipProvider provider : this.providers) {
                if (!provider.isMember(group, authorizable, includeInherited)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public Iterator<Group> getMembership(@NotNull Authorizable authorizable, boolean includeInherited) throws RepositoryException {
            int size = this.providers.size();
            Iterator[] groups = new Iterator[size];
            for (int i = 0; i < size; ++i) {
                groups[i] = this.providers.get(i).getMembership(authorizable, includeInherited);
            }
            return IteratorUtils.chainedIterator((Iterator[])groups);
        }
    }
}

