/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.index.AsyncCheckpointCreator;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class, factory=true)
public class AsyncCheckpointService {
    private final List<Registration> regs = new ArrayList<Registration>();
    @Reference
    private NodeStore nodeStore;

    @Activate
    public void activate(BundleContext bundleContext, Configuration config) {
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(bundleContext);
        if (config.enable()) {
            AsyncCheckpointCreator task = new AsyncCheckpointCreator(this.nodeStore, config.name(), config.checkpointLifetime(), config.minConcurrentCheckpoints(), config.maxConcurrentCheckpoints());
            this.registerAsyncCheckpointCreator((Whiteboard)whiteboard, task, config.timeIntervalBetweenCheckpoints());
        }
    }

    private void registerAsyncCheckpointCreator(Whiteboard whiteboard, AsyncCheckpointCreator task, long delayInSeconds) {
        Map<String, CallSite> config = Map.of("oak.checkpoint.async", task.getName(), "scheduler.name", AsyncCheckpointCreator.class.getName() + "-" + task.getName());
        this.regs.add(WhiteboardUtils.scheduleWithFixedDelay((Whiteboard)whiteboard, (Runnable)task, config, (long)delayInSeconds, (WhiteboardUtils.ScheduleExecutionInstanceTypes)WhiteboardUtils.ScheduleExecutionInstanceTypes.RUN_ON_LEADER, (boolean)true));
    }

    @Deactivate
    public void deactivate() throws IOException {
        new CompositeRegistration(this.regs).unregister();
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak Async Checkpoint Service", description="Configures the async checkpoint services which performs periodic creation and deletion of checkpoints")
    static @interface Configuration {
        @AttributeDefinition(name="Checkpoint Creator Identifier", description="Unique identifier to be used for creating checkpoints")
        public String name() default "checkpoint-async";

        @AttributeDefinition(name="Enable", description="Flag to enable/disable the checkpoints creation task")
        public boolean enable() default false;

        @AttributeDefinition(name="Minimum Concurrent Checkpoints", description="Minimum number of concurrent checkpoints to keep in system")
        public long minConcurrentCheckpoints() default 2L;

        @AttributeDefinition(name="Maximum Concurrent Checkpoints", description="Maximum number of concurrent checkpoints to keep in system. This limit is to prevent multiple checkpoint creation in case the deletion of older checkpoints fails multiple times. This should always be greater than Minimum Concurrent Checkpoints")
        public long maxConcurrentCheckpoints() default 10L;

        @AttributeDefinition(name="Checkpoint Lifetime", description="Lifetime of a checkpoint in seconds")
        public long checkpointLifetime() default 86400L;

        @AttributeDefinition(name="Time Interval", description="Time interval between consecutive job runs in seconds. This would be the time interval between two consecutive checkpoints creation.")
        public long timeIntervalBetweenCheckpoints() default 900L;
    }
}

