/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.projectmanager.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.components.projectmanager.model.Filtre;
import org.silverpeas.components.projectmanager.model.TaskDetail;
import org.silverpeas.components.projectmanager.model.TaskResourceDetail;
import org.silverpeas.core.exception.UtilException;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.DateUtil;

public class ProjectManagerDAO {
    private static final String PROJECTMANAGER_TASKS_TABLENAME = "sc_projectmanager_tasks";
    private static final String PROJECTMANAGER_RESOURCES_TABLENAME = "sc_projectmanager_resources";

    private ProjectManagerDAO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getChrono(Connection con, String instanceId) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT MAX(chrono) FROM ").append(PROJECTMANAGER_TASKS_TABLENAME).append(" WHERE instanceId = ? ");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int result = -1;
        try {
            stmt = con.prepareStatement(query.toString());
            stmt.setString(1, instanceId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return result + 1;
    }

    public static int addTask(Connection con, TaskDetail task) throws SQLException {
        StringBuilder insertStatement = new StringBuilder();
        insertStatement.append("INSERT INTO ").append(PROJECTMANAGER_TASKS_TABLENAME);
        insertStatement.append("(id, mereid, chrono, nom, description, organisateurid, responsableid, ");
        insertStatement.append("charge, consomme, raf, avancement, statut, datedebut, datefin, ");
        insertStatement.append("codeprojet, descriptionprojet, estdecomposee, instanceid, path, ");
        insertStatement.append("previousid) VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ");
        insertStatement.append("? , ? , ? , ?, ?, ? , ? , ? )");
        int id = ProjectManagerDAO.executeQueryAddTask(con, task, insertStatement);
        if (task.getResources() != null) {
            Collection<TaskResourceDetail> tasks = task.getResources();
            for (TaskResourceDetail resource : tasks) {
                resource.setTaskId(id);
                resource.setInstanceId(task.getInstanceId());
                ProjectManagerDAO.addResource(con, resource);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int executeQueryAddTask(Connection con, TaskDetail task, StringBuilder insertStatement) throws SQLException {
        PreparedStatement prepStmt = null;
        int id = -1;
        try {
            prepStmt = con.prepareStatement(insertStatement.toString());
            id = DBUtil.getNextId((String)PROJECTMANAGER_TASKS_TABLENAME, (String)"id");
            prepStmt.setInt(1, id);
            prepStmt.setInt(2, task.getMereId());
            if (task.getMereId() == -1) {
                prepStmt.setInt(3, 0);
            } else {
                prepStmt.setInt(3, ProjectManagerDAO.getChrono(con, task.getInstanceId()));
            }
            prepStmt.setString(4, task.getNom());
            prepStmt.setString(5, task.getDescription());
            prepStmt.setInt(6, task.getOrganisateurId());
            prepStmt.setInt(7, task.getResponsableId());
            prepStmt.setFloat(8, task.getCharge());
            prepStmt.setFloat(9, task.getConsomme());
            prepStmt.setFloat(10, task.getRaf());
            prepStmt.setInt(11, task.getAvancement());
            prepStmt.setInt(12, task.getStatut());
            prepStmt.setString(13, DateUtil.date2SQLDate((Date)task.getDateDebut()));
            if (task.getDateFin() != null) {
                prepStmt.setString(14, DateUtil.date2SQLDate((Date)task.getDateFin()));
            } else {
                prepStmt.setString(14, "9999/99/99");
            }
            prepStmt.setString(15, task.getCodeProjet());
            prepStmt.setString(16, task.getDescriptionProjet());
            prepStmt.setInt(17, task.getEstDecomposee());
            prepStmt.setString(18, task.getInstanceId());
            prepStmt.setString(19, task.getPath() + id + "/");
            prepStmt.setInt(20, task.getPreviousTaskId());
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addResource(Connection con, TaskResourceDetail resource) throws SQLException {
        StringBuilder insertStatement = new StringBuilder();
        insertStatement.append("INSERT INTO ").append(PROJECTMANAGER_RESOURCES_TABLENAME);
        insertStatement.append("(id , taskid, resourceid, charge, instanceid) VALUES ( ? , ? , ? , ? , ? )");
        PreparedStatement prepStmt = null;
        int id = -1;
        try {
            prepStmt = con.prepareStatement(insertStatement.toString());
            id = DBUtil.getNextId((String)PROJECTMANAGER_RESOURCES_TABLENAME, (String)"id");
            prepStmt.setInt(1, id);
            prepStmt.setInt(2, resource.getTaskId());
            prepStmt.setInt(3, Integer.parseInt(resource.getUserId()));
            prepStmt.setInt(4, resource.getCharge());
            prepStmt.setString(5, resource.getInstanceId());
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTask(Connection con, TaskDetail task) throws SQLException, UtilException {
        StringBuilder updateQuery = new StringBuilder();
        updateQuery.append("UPDATE ").append(PROJECTMANAGER_TASKS_TABLENAME);
        updateQuery.append(" SET nom = ? , description = ? , responsableId = ? , charge = ? , ");
        updateQuery.append("consomme = ? , raf = ? , avancement = ? , statut = ? , dateDebut = ? , ");
        updateQuery.append("dateFin = ? , previousId = ? WHERE id = ? ");
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(updateQuery.toString());
            prepStmt.setString(1, task.getNom());
            prepStmt.setString(2, task.getDescription());
            prepStmt.setInt(3, task.getResponsableId());
            prepStmt.setFloat(4, task.getCharge());
            prepStmt.setFloat(5, task.getConsomme());
            prepStmt.setFloat(6, task.getRaf());
            prepStmt.setInt(7, task.getAvancement());
            prepStmt.setInt(8, task.getStatut());
            prepStmt.setString(9, DateUtil.date2SQLDate((Date)task.getDateDebut()));
            if (task.getDateFin() != null) {
                prepStmt.setString(10, DateUtil.date2SQLDate((Date)task.getDateFin()));
            } else {
                prepStmt.setString(10, "9999/99/99");
            }
            prepStmt.setInt(11, task.getPreviousTaskId());
            prepStmt.setInt(12, task.getId());
            prepStmt.executeUpdate();
            ProjectManagerDAO.deleteAllResources(con, task.getId(), task.getInstanceId());
            if (task.getResources() != null) {
                for (TaskResourceDetail resource : task.getResources()) {
                    resource.setTaskId(task.getId());
                    resource.setInstanceId(task.getInstanceId());
                    ProjectManagerDAO.addResource(con, resource);
                }
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllResources(Connection con, int taskId, String instanceId) throws SQLException {
        StringBuilder deleteStatement = new StringBuilder();
        deleteStatement.append("delete from ").append(PROJECTMANAGER_RESOURCES_TABLENAME).append(" where taskId = ? and instanceId = ? ");
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(deleteStatement.toString());
            stmt.setInt(1, taskId);
            stmt.setString(2, instanceId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(stmt);
            throw throwable;
        }
        DBUtil.close((Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void actionEstDecomposee(Connection con, int id, int estDecomposee) throws SQLException {
        StringBuilder updateQuery = new StringBuilder();
        updateQuery.append("update ").append(PROJECTMANAGER_TASKS_TABLENAME);
        updateQuery.append(" set estDecomposee = ? ");
        updateQuery.append(" where id = ? ");
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(updateQuery.toString());
            prepStmt.setInt(1, estDecomposee);
            prepStmt.setInt(2, id);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTask(Connection con, int id) throws SQLException {
        StringBuilder deleteStatement = new StringBuilder();
        deleteStatement.append("delete from ").append(PROJECTMANAGER_TASKS_TABLENAME).append(" where id = ? ");
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(deleteStatement.toString());
            stmt.setInt(1, id);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(stmt);
            throw throwable;
        }
        DBUtil.close((Statement)stmt);
    }

    public static void removeAllTasks(Connection con, String instanceId) throws SQLException {
        String tasks = "delete from sc_projectmanager_tasks where instanceId = ?";
        String resources = "delete from sc_projectmanager_resources where instanceId = ?";
        try (PreparedStatement deletion = con.prepareStatement("delete from sc_projectmanager_resources where instanceId = ?");){
            deletion.setString(1, instanceId);
            deletion.execute();
        }
        deletion = con.prepareStatement("delete from sc_projectmanager_tasks where instanceId = ?");
        try {
            deletion.setString(1, instanceId);
            deletion.execute();
        }
        finally {
            if (deletion != null) {
                deletion.close();
            }
        }
    }

    public static TaskDetail getTask(Connection con, String id) throws SQLException {
        return ProjectManagerDAO.getTask(con, Integer.parseInt(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskDetail getTask(Connection con, int id) throws SQLException {
        TaskDetail task = null;
        StringBuilder query = new StringBuilder();
        query.append("select * ");
        query.append("from ").append(PROJECTMANAGER_TASKS_TABLENAME);
        query.append(" where id = ? ");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(query.toString());
            stmt.setInt(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                task = ProjectManagerDAO.getTaskDetailFromResultset(rs);
                task.setResources(ProjectManagerDAO.getResources(con, task.getId(), task.getInstanceId()));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TaskResourceDetail> getResources(Connection con, int taskId, String instanceId) throws SQLException {
        ArrayList<TaskResourceDetail> resources = new ArrayList<TaskResourceDetail>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT id, taskId, resourceId, charge, instanceId FROM ");
        query.append(PROJECTMANAGER_RESOURCES_TABLENAME);
        query.append(" WHERE taskId = ? AND instanceId = ? ");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(query.toString());
            stmt.setInt(1, taskId);
            stmt.setString(2, instanceId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                TaskResourceDetail resource = ProjectManagerDAO.getTaskResourceDetailFromResultset(rs);
                resources.add(resource);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TaskDetail> getAllTasks(Connection con, String instanceId, Filtre filtre) throws SQLException {
        String filtreSQL;
        ArrayList<TaskDetail> tasks = new ArrayList<TaskDetail>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ").append(PROJECTMANAGER_TASKS_TABLENAME);
        query.append(" WHERE instanceId = ? ");
        if (filtre != null && (filtreSQL = ProjectManagerDAO.getSQL(filtre)).length() > 0) {
            query.append("AND ").append(filtreSQL);
        }
        query.append(" ORDER BY path ASC");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(query.toString());
            stmt.setString(1, instanceId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                TaskDetail task = ProjectManagerDAO.getTaskDetailFromResultset(rs);
                task.setResources(ProjectManagerDAO.getResources(con, task.getId(), task.getInstanceId()));
                tasks.add(task);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return tasks;
    }

    public static List<TaskDetail> getNextTasks(Connection con, int taskId) throws SQLException {
        return ProjectManagerDAO.listTasksSortedByStartDate(con, q -> q.where("previousId = ?", new Object[]{taskId}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskDetail getMostDistantTask(Connection con, int taskId) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block2: {
            TaskDetail taskDetail;
            StringBuilder query = new StringBuilder();
            query.append("select * ");
            query.append("from ").append(PROJECTMANAGER_TASKS_TABLENAME);
            query.append(" where mereId = ? ");
            query.append(" order by dateFin DESC");
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement(query.toString());
                stmt.setInt(1, taskId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block2;
                TaskDetail task = ProjectManagerDAO.getTaskDetailFromResultset(rs);
                task.setResources(ProjectManagerDAO.getResources(con, task.getId(), task.getInstanceId()));
                taskDetail = task;
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, (Statement)stmt);
                throw throwable;
            }
            DBUtil.close((ResultSet)rs, (Statement)stmt);
            return taskDetail;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TaskDetail> getTree(Connection con, int actionId) throws SQLException {
        ArrayList<TaskDetail> tasks = new ArrayList<TaskDetail>();
        StringBuilder query = new StringBuilder();
        query.append("select * ");
        query.append("from ").append(PROJECTMANAGER_TASKS_TABLENAME);
        query.append(" where path like '%/").append(actionId).append("/%' ");
        query.append("order by path ASC");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(query.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                TaskDetail task = ProjectManagerDAO.getTaskDetailFromResultset(rs);
                task.setResources(ProjectManagerDAO.getResources(con, task.getId(), task.getInstanceId()));
                tasks.add(task);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return tasks;
    }

    public static List<TaskDetail> getTasksByMotherId(Connection con, String instanceId, int motherId) throws SQLException {
        return ProjectManagerDAO.listInstanceTasksSortedByStartDate(con, instanceId, q -> q.and("mereId = ?", new Object[]{motherId}));
    }

    private static List<TaskDetail> listInstanceTasksSortedByStartDate(Connection con, String instanceId, UnaryOperator<JdbcSqlQuery> sqlQueryOp) throws SQLException {
        return ProjectManagerDAO.listTasksSortedByStartDate(con, q -> (JdbcSqlQuery)sqlQueryOp.apply(q.where("instanceId = ?", new Object[]{instanceId})));
    }

    private static List<TaskDetail> listTasksSortedByStartDate(Connection con, UnaryOperator<JdbcSqlQuery> sqlQueryOp) throws SQLException {
        return ((JdbcSqlQuery)sqlQueryOp.apply(JdbcSqlQuery.select((String)"*").from(new String[]{PROJECTMANAGER_TASKS_TABLENAME}))).orderBy(new String[]{"dateDebut ASC, id ASC"}).executeWith(con, rs -> {
            TaskDetail task = ProjectManagerDAO.getTaskDetailFromResultset((ResultSet)rs);
            task.setResources(ProjectManagerDAO.getResources(con, task.getId(), task.getInstanceId()));
            return task;
        });
    }

    public static List<TaskDetail> getTasksByMotherIdAndPreviousId(Connection con, String instanceId, int motherId, int previousId) throws SQLException {
        return ProjectManagerDAO.listInstanceTasksSortedByStartDate(con, instanceId, q -> q.and("mereId = ?", new Object[]{motherId}).and("previousId = ?", new Object[]{previousId}));
    }

    public static int getOccupationByUser(Connection con, String userId, Date dateDeb, Date dateFin) throws SQLException {
        return ProjectManagerDAO.getOccupationByUser(con, userId, dateDeb, dateFin, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOccupationByUser(Connection con, String userId, Date dateDeb, Date dateFin, int excludedTaskId) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block4: {
            int n;
            StringBuilder query = new StringBuilder();
            query.append("SELECT SUM(res.charge) AS somme FROM ").append(PROJECTMANAGER_TASKS_TABLENAME);
            query.append(" task, ").append(PROJECTMANAGER_RESOURCES_TABLENAME).append(" res");
            query.append(" WHERE res.taskId = task.id");
            query.append(" AND ((dateDebut <= ? OR dateFin <= ?) AND (dateDebut >= ? OR dateFin >= ?)) AND resourceId = ? ");
            if (excludedTaskId > -1) {
                query.append(" AND task.id <> ? ");
            }
            query.append("GROUP BY res.resourceId");
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement(query.toString());
                stmt.setString(1, DateUtil.date2SQLDate((Date)dateFin));
                stmt.setString(2, DateUtil.date2SQLDate((Date)dateFin));
                stmt.setString(3, DateUtil.date2SQLDate((Date)dateDeb));
                stmt.setString(4, DateUtil.date2SQLDate((Date)dateDeb));
                stmt.setInt(5, Integer.parseInt(userId));
                if (excludedTaskId != -1) {
                    stmt.setInt(6, excludedTaskId);
                }
                if (!(rs = stmt.executeQuery()).next()) break block4;
                n = rs.getInt("somme");
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, (Statement)stmt);
                throw throwable;
            }
            DBUtil.close((ResultSet)rs, (Statement)stmt);
            return n;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return 0;
    }

    private static TaskDetail getTaskDetailFromResultset(ResultSet rs) throws SQLException {
        int id = rs.getInt("id");
        int mereId = rs.getInt("mereId");
        int chrono = rs.getInt("chrono");
        String nom = rs.getString("nom");
        String description = rs.getString("description");
        int organisateurId = rs.getInt("organisateurId");
        int responsableId = rs.getInt("responsableId");
        float charge = rs.getFloat("charge");
        float consomme = rs.getFloat("consomme");
        float raf = rs.getFloat("raf");
        int statut = rs.getInt("statut");
        Date dateDebut = ProjectManagerDAO.dbDate2Date(rs.getString("dateDebut"), "dateDebut");
        Date dateFin = ProjectManagerDAO.dbDate2Date(rs.getString("dateFin"), "dateFin");
        String codeProjet = rs.getString("codeProjet");
        String descriptionProjet = rs.getString("descriptionProjet");
        int estDecomposee = rs.getInt("estDecomposee");
        String instanceId = rs.getString("instanceId");
        String path = rs.getString("path");
        int previousId = rs.getInt("previousId");
        TaskDetail task = new TaskDetail(id, mereId, chrono, nom, description, organisateurId, responsableId, charge, consomme, raf, statut, dateDebut, dateFin, codeProjet, descriptionProjet, estDecomposee, instanceId, path);
        task.setPreviousTaskId(previousId);
        return task;
    }

    private static TaskResourceDetail getTaskResourceDetailFromResultset(ResultSet rs) throws SQLException {
        int id = rs.getInt("id");
        int taskId = rs.getInt("taskId");
        String userId = Integer.toString(rs.getInt("resourceId"));
        int charge = rs.getInt("charge");
        String instanceId = rs.getString("instanceId");
        return new TaskResourceDetail(id, taskId, userId, charge, instanceId);
    }

    private static String getSQL(Filtre filtre) {
        StringBuilder sql = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)filtre.getActionFrom())) {
            sql.append(" chrono >= ").append(filtre.getActionFrom());
        }
        if (StringUtils.isNotEmpty((CharSequence)filtre.getActionTo())) {
            ProjectManagerDAO.andClause(sql);
            sql.append(" chrono <= ").append(filtre.getActionTo());
        }
        if (StringUtils.isNotEmpty((CharSequence)filtre.getCodeProjet())) {
            ProjectManagerDAO.andClause(sql);
            sql.append(" codeProjet = ").append(filtre.getCodeProjet());
        }
        if (StringUtils.isNotEmpty((CharSequence)filtre.getDescProjet())) {
            ProjectManagerDAO.andClause(sql);
            sql.append(" descriptionProjet like '%").append(filtre.getDescProjet()).append("%' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)filtre.getActionNom())) {
            ProjectManagerDAO.andClause(sql);
            sql.append(" nom like '%").append(filtre.getActionNom()).append("%' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)filtre.getStatut()) && !"-1".equals(filtre.getStatut())) {
            ProjectManagerDAO.andClause(sql);
            sql.append(" statut = ").append(filtre.getStatut());
        }
        if (filtre.getDateDebutFrom() != null) {
            ProjectManagerDAO.andClause(sql);
            sql.append(" dateDebut >= '").append(DateUtil.date2SQLDate((Date)filtre.getDateDebutFrom())).append("' ");
        }
        if (filtre.getDateDebutTo() != null) {
            ProjectManagerDAO.andClause(sql);
            sql.append(" dateDebut <= '").append(DateUtil.date2SQLDate((Date)filtre.getDateDebutTo())).append("' ");
        }
        if (filtre.getDateFinFrom() != null) {
            ProjectManagerDAO.andClause(sql);
            sql.append(" dateFin >= '").append(DateUtil.date2SQLDate((Date)filtre.getDateFinFrom())).append("' ");
        }
        if (filtre.getDateFinTo() != null) {
            ProjectManagerDAO.andClause(sql);
            sql.append(" dateFin <= '").append(DateUtil.date2SQLDate((Date)filtre.getDateFinTo())).append("' ");
        }
        if (filtre.getRetard() != null && !"-1".equals(filtre.getRetard())) {
            ProjectManagerDAO.andClause(sql);
            Date today = new Date();
            if ("1".equals(filtre.getRetard())) {
                sql.append("( dateFin < '").append(DateUtil.date2SQLDate((Date)today)).append("' AND avancement = 100 ) ");
            } else {
                sql.append("( dateFin >= '").append(DateUtil.date2SQLDate((Date)today)).append("' AND avancement = 100 ) ");
            }
        }
        if (filtre.getAvancement() != null && !"-1".equals(filtre.getAvancement())) {
            ProjectManagerDAO.andClause(sql);
            if ("1".equals(filtre.getAvancement())) {
                sql.append(" avancement = 100 ");
            } else {
                sql.append(" avancement < 100 ");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)filtre.getResponsableId())) {
            ProjectManagerDAO.andClause(sql);
            sql.append(" responsableId = ").append(filtre.getResponsableId());
        }
        return sql.toString();
    }

    private static void andClause(StringBuilder sql) {
        if (sql.length() > 0) {
            sql.append(" AND ");
        }
    }

    public static Date dbDate2Date(String dbDate, String fieldName) throws SQLException {
        Date date = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
            date = formatter.parse(dbDate);
        }
        catch (ParseException e) {
            throw new SQLException("ProjectManagerDAO : dbDate2Date(" + fieldName + ") : format unknown " + e.toString(), e);
        }
        return date;
    }
}

