/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.JournalEntry;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.jetbrains.annotations.NotNull;

public abstract class Collection<T extends Document> {
    public static final Collection<NodeDocument> NODES = new Collection<NodeDocument>("nodes"){

        @Override
        @NotNull
        public NodeDocument newDocument(DocumentStore store) {
            return new NodeDocument(store);
        }
    };
    public static final Collection<ClusterNodeInfoDocument> CLUSTER_NODES = new Collection<ClusterNodeInfoDocument>("clusterNodes"){

        @Override
        @NotNull
        public ClusterNodeInfoDocument newDocument(DocumentStore store) {
            return new ClusterNodeInfoDocument();
        }
    };
    public static final Collection<Document> SETTINGS = new Collection<Document>("settings"){

        @Override
        @NotNull
        public Document newDocument(DocumentStore store) {
            return new Document();
        }
    };
    public static final Collection<JournalEntry> JOURNAL = new Collection<JournalEntry>("journal"){

        @Override
        @NotNull
        public JournalEntry newDocument(DocumentStore store) {
            return new JournalEntry(store);
        }
    };
    public static final Collection<Document> BLOBS = new Collection<Document>("blobs"){

        @Override
        @NotNull
        public Document newDocument(DocumentStore store) {
            throw new UnsupportedOperationException();
        }
    };
    private final String name;

    public Collection(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    @NotNull
    public abstract T newDocument(DocumentStore var1);
}

