/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.encryption;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.silverpeas.core.security.encryption.SilverpeasX509TrustManager;
import org.silverpeas.kernel.util.StringUtil;

public class SilverpeasSSLSocketFactory
extends SSLSocketFactory {
    public static final String TRUSTSTORE_KEY = "javax.net.ssl.trustStore";
    public static final String TRUSTSTORE_PASSWORD_KEY = "javax.net.ssl.trustStorePassword";
    private SSLSocketFactory factory;

    private char[] getTrustStorePassword() {
        char[] password = new char[]{};
        if (StringUtil.isDefined((String)System.getProperty(TRUSTSTORE_PASSWORD_KEY))) {
            password = System.getProperty(TRUSTSTORE_PASSWORD_KEY).toCharArray();
        }
        return password;
    }

    public SilverpeasSSLSocketFactory() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new SilverpeasX509TrustManager(System.getProperty(TRUSTSTORE_KEY), this.getTrustStorePassword())}, null);
            this.factory = sslcontext.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static SocketFactory getDefault() {
        return new SilverpeasSSLSocketFactory();
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.factory.createSocket();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.factory.createSocket(socket, host, port, autoClose);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.factory.createSocket(address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.factory.createSocket(address, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.factory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.factory.createSocket(host, port);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

