/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.encryption;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Named;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.encryption.CipherKeyUpdateException;
import org.silverpeas.core.security.encryption.CipherRenewingException;
import org.silverpeas.core.security.encryption.ConcurrentEncryptionTaskExecutor;
import org.silverpeas.core.security.encryption.ContentEncryptionService;
import org.silverpeas.core.security.encryption.CryptographicTask;
import org.silverpeas.core.security.encryption.EncryptionContentIterator;
import org.silverpeas.core.security.encryption.cipher.Cipher;
import org.silverpeas.core.security.encryption.cipher.CipherFactory;
import org.silverpeas.core.security.encryption.cipher.CipherKey;
import org.silverpeas.core.security.encryption.cipher.CryptoException;
import org.silverpeas.core.security.encryption.cipher.CryptographicAlgorithmName;
import org.silverpeas.core.util.EncodingUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Named(value="contentEncryptionService")
public class DefaultContentEncryptionService
implements ContentEncryptionService {
    private static final String ACTUAL_KEY_FILE_PATH = FileRepositoryManager.getSecurityDirPath() + ".aid_key";
    private static final String DEPRECATED_KEY_FILE_PATH = FileRepositoryManager.getSecurityDirPath() + ".did_key";
    private static final String KEY_SEP = " ";
    private static final List<EncryptionContentIterator> contentIterators = new CopyOnWriteArrayList<EncryptionContentIterator>();

    protected DefaultContentEncryptionService() {
    }

    @Override
    public void registerForContentCiphering(EncryptionContentIterator iterator) {
        contentIterators.add(new EncryptionContentIteratorWrapper(iterator));
    }

    @Override
    public void updateCipherKey(String key) throws CryptoException {
        DefaultContentEncryptionService.assertKeyIsInHexadecimal(key);
        DefaultContentEncryptionService.assertKeyIsIn256Bits(key);
        ConcurrentEncryptionTaskExecutor.execute(new CipherKeyUpdater(key));
    }

    @Override
    public String[] encryptContent(final String ... contentParts) throws CryptoException {
        return ConcurrentEncryptionTaskExecutor.execute(new ConcurrentEncryptionTaskExecutor.ConcurrentEncryptionTask<String[]>(){

            @Override
            public boolean isPrivileged() {
                return false;
            }

            @Override
            public String[] execute() throws CryptoException {
                CipherKey key = DefaultContentEncryptionService.getActualCipherKey();
                Cipher cipher = DefaultContentEncryptionService.getCipherForContentEncryption();
                String[] encryptedContents = new String[contentParts.length];
                for (int i = 0; i < contentParts.length; ++i) {
                    if (contentParts[i] == null) continue;
                    byte[] theEncryptedContent = cipher.encrypt(contentParts[i], key);
                    encryptedContents[i] = StringUtil.asBase64((byte[])theEncryptedContent);
                }
                return encryptedContents;
            }
        });
    }

    @Override
    public Map<String, String> encryptContent(final Map<String, String> content) throws CryptoException {
        return ConcurrentEncryptionTaskExecutor.execute(new ConcurrentEncryptionTaskExecutor.ConcurrentEncryptionTask<Map<String, String>>(){

            @Override
            public boolean isPrivileged() {
                return false;
            }

            @Override
            public Map<String, String> execute() throws CryptoException {
                CipherKey key = DefaultContentEncryptionService.getActualCipherKey();
                Cipher cipher = DefaultContentEncryptionService.getCipherForContentEncryption();
                return DefaultContentEncryptionService.encryptContent(content, cipher, key);
            }
        });
    }

    @Override
    public void encryptContents(EncryptionContentIterator ... iterators) throws CryptoException {
        ConcurrentEncryptionTaskExecutor.execute(CryptographicTask.encryptionOf(iterators));
    }

    @Override
    public String[] decryptContent(final String ... encryptedContentParts) throws CryptoException {
        return ConcurrentEncryptionTaskExecutor.execute(new ConcurrentEncryptionTaskExecutor.ConcurrentEncryptionTask<String[]>(){

            @Override
            public boolean isPrivileged() {
                return false;
            }

            @Override
            public String[] execute() throws CryptoException {
                CipherKey key = DefaultContentEncryptionService.getActualCipherKey();
                Cipher cipher = DefaultContentEncryptionService.getCipherForContentEncryption();
                String[] contents = new String[encryptedContentParts.length];
                for (int i = 0; i < encryptedContentParts.length; ++i) {
                    if (encryptedContentParts[i] == null) continue;
                    contents[i] = cipher.decrypt(StringUtil.fromBase64((String)encryptedContentParts[i]), key);
                }
                return contents;
            }
        });
    }

    @Override
    public Map<String, String> decryptContent(final Map<String, String> encryptedContent) throws CryptoException {
        return ConcurrentEncryptionTaskExecutor.execute(new ConcurrentEncryptionTaskExecutor.ConcurrentEncryptionTask<Map<String, String>>(){

            @Override
            public boolean isPrivileged() {
                return false;
            }

            @Override
            public Map<String, String> execute() throws CryptoException {
                CipherKey key = DefaultContentEncryptionService.getActualCipherKey();
                Cipher cipher = DefaultContentEncryptionService.getCipherForContentEncryption();
                return DefaultContentEncryptionService.decryptContent(encryptedContent, cipher, key);
            }
        });
    }

    @Override
    public void decryptContents(EncryptionContentIterator ... iterators) throws CryptoException {
        ConcurrentEncryptionTaskExecutor.execute(CryptographicTask.decryptionOf(iterators));
    }

    @Override
    public void renewCipherOfContents(EncryptionContentIterator ... iterators) throws CryptoException {
        try {
            ConcurrentEncryptionTaskExecutor.execute(CryptographicTask.renewEncryptionOf(iterators).inPrivilegedMode());
        }
        catch (CryptoException ex) {
            if (ex.getCause() instanceof FileNotFoundException) {
                SilverLogger.getLogger((Object)this).warn(ex.getMessage(), new Object[0]);
                return;
            }
            throw ex;
        }
    }

    protected static Map<String, String> encryptContent(Map<String, String> content, Cipher cipher, CipherKey key) throws CryptoException {
        HashMap<String, String> encryptedContents = new HashMap<String, String>(content.size());
        for (Map.Entry<String, String> aContent : content.entrySet()) {
            if (aContent.getValue() == null) continue;
            byte[] theEncryptedContent = cipher.encrypt(aContent.getValue(), key);
            encryptedContents.put(aContent.getKey(), StringUtil.asBase64((byte[])theEncryptedContent));
        }
        return encryptedContents;
    }

    protected static Map<String, String> decryptContent(Map<String, String> encryptedContent, Cipher cipher, CipherKey key) throws CryptoException {
        HashMap<String, String> content = new HashMap<String, String>(encryptedContent.size());
        try {
            for (Map.Entry<String, String> anEncryptedContent : encryptedContent.entrySet()) {
                if (anEncryptedContent.getValue() == null) continue;
                String aContent = cipher.decrypt(StringUtil.fromBase64((String)anEncryptedContent.getValue()), key);
                content.put(anEncryptedContent.getKey(), aContent);
            }
        }
        catch (IllegalArgumentException e) {
            throw new CryptoException(e.getMessage());
        }
        return content;
    }

    protected static CipherKey getActualCipherKey() throws CryptoException {
        return DefaultContentEncryptionService.getCipherKey(ACTUAL_KEY_FILE_PATH);
    }

    protected static CipherKey getPreviousCipherKey() throws CryptoException {
        return DefaultContentEncryptionService.getCipherKey(DEPRECATED_KEY_FILE_PATH);
    }

    private static CipherKey getCipherKey(String keyFilePath) throws CryptoException {
        String key = null;
        try {
            File keyFile = new File(keyFilePath);
            String[] keys = FileUtil.readFileToString(keyFile).split(KEY_SEP);
            Cipher cipher = DefaultContentEncryptionService.getCipherForKeyEncryption();
            CipherKey encryptionKey = CipherKey.aKeyFromBase64Text(keys[0]);
            key = cipher.decrypt(StringUtil.fromBase64((String)keys[1]), encryptionKey);
            return CipherKey.aKeyFromHexText(key);
        }
        catch (IOException | IndexOutOfBoundsException ex) {
            throw new CryptoException("Cannot get the encryption key", ex);
        }
        catch (ParseException ex) {
            throw new CryptoException("Hum... the key isn't in hexadecimal: '" + key + "'", ex);
        }
    }

    private static void assertKeyIsInHexadecimal(String key) {
        try {
            EncodingUtil.fromHex(key);
        }
        catch (ParseException ex) {
            throw new AssertionError((Object)("The encryption key '" + key + "' must be in hexadecimal"));
        }
    }

    private static void assertKeyIsIn256Bits(String key) {
        int keyBitsSize = 64;
        if (key.length() != 64) {
            throw new AssertionError((Object)("The encryption key '" + key + "' must be in 256 bits"));
        }
    }

    protected static Cipher getCipherForContentEncryption() {
        CipherFactory cipherFactory = CipherFactory.getFactory();
        return cipherFactory.getCipher(CryptographicAlgorithmName.AES);
    }

    private static Cipher getCipherForKeyEncryption() {
        CipherFactory cipherFactory = CipherFactory.getFactory();
        return cipherFactory.getCipher(CryptographicAlgorithmName.CAST5);
    }

    @Override
    public boolean isCipherKeyDefined() {
        try {
            DefaultContentEncryptionService.getActualCipherKey();
            return true;
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
            return false;
        }
    }

    private static class CipherKeyUpdater
    implements ConcurrentEncryptionTaskExecutor.ConcurrentEncryptionTask<Void> {
        private final String key;

        public CipherKeyUpdater(String key) {
            this.key = key;
        }

        @Override
        public boolean isPrivileged() {
            return true;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Void execute() throws CryptoException {
            Void void_;
            File backupedKeyFile = null;
            File backupedDeprecatedKeyFile = null;
            boolean restore = false;
            try {
                boolean renewContentCiphers = false;
                File keyFile = new File(ACTUAL_KEY_FILE_PATH);
                if (keyFile.exists()) {
                    renewContentCiphers = true;
                    backupedKeyFile = new File(ACTUAL_KEY_FILE_PATH + ".backup");
                    FileUtil.copyFile(keyFile, backupedKeyFile);
                    File deprecatedKeyFile = new File(DEPRECATED_KEY_FILE_PATH);
                    if (deprecatedKeyFile.exists()) {
                        backupedDeprecatedKeyFile = new File(DEPRECATED_KEY_FILE_PATH + ".backup");
                        FileUtil.moveFile(deprecatedKeyFile, backupedDeprecatedKeyFile);
                    }
                    FileUtil.moveFile(keyFile, deprecatedKeyFile);
                    this.setHidden(DEPRECATED_KEY_FILE_PATH);
                }
                Cipher cipher = DefaultContentEncryptionService.getCipherForKeyEncryption();
                CipherKey encryptionKey = cipher.generateCipherKey();
                byte[] encryptedKey = cipher.encrypt(this.key, encryptionKey);
                String encryptedContent = StringUtil.asBase64((byte[])encryptionKey.getRawKey()) + DefaultContentEncryptionService.KEY_SEP + StringUtil.asBase64((byte[])encryptedKey);
                try (ByteArrayInputStream contentStream = new ByteArrayInputStream(encryptedContent.getBytes());){
                    Files.copy(contentStream, keyFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                this.setReadOnly(keyFile);
                this.setHidden(ACTUAL_KEY_FILE_PATH);
                EncryptionContentIterator[] iterators = contentIterators.toArray(new EncryptionContentIterator[0]);
                if (renewContentCiphers) {
                    CryptographicTask.renewEncryptionOf(iterators).execute();
                } else {
                    CryptographicTask.encryptionOf(iterators).execute();
                }
                void_ = null;
            }
            catch (IOException ex) {
                try {
                    restore = true;
                    throw new CipherKeyUpdateException("Cannot update the encryption key", ex);
                    catch (CipherRenewingException ex2) {
                        restore = true;
                        throw new CryptoException(ex2.getMessage(), ex2);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        File keyFile3;
                        if (backupedKeyFile != null) {
                            if (restore) {
                                keyFile3 = new File(ACTUAL_KEY_FILE_PATH);
                                FileUtil.copyFile(backupedKeyFile, keyFile3);
                                this.setReadOnly(keyFile3);
                                this.setHidden(ACTUAL_KEY_FILE_PATH);
                            }
                            FileUtil.forceDeletion(backupedKeyFile);
                        }
                        if (backupedDeprecatedKeyFile == null) throw throwable;
                        if (restore) {
                            keyFile3 = new File(DEPRECATED_KEY_FILE_PATH);
                            Files.delete(keyFile3.toPath());
                            FileUtil.copyFile(backupedDeprecatedKeyFile, keyFile3);
                            this.setReadOnly(keyFile3);
                            this.setHidden(DEPRECATED_KEY_FILE_PATH);
                        }
                        FileUtil.forceDeletion(backupedDeprecatedKeyFile);
                        throw throwable;
                    }
                    catch (IOException ex3) {
                        SilverLogger.getLogger((Object)this).error(ex3.getMessage(), (Throwable)ex3);
                    }
                    throw throwable;
                }
            }
            try {
                File keyFile2;
                if (backupedKeyFile != null) {
                    if (restore) {
                        keyFile2 = new File(ACTUAL_KEY_FILE_PATH);
                        FileUtil.copyFile(backupedKeyFile, keyFile2);
                        this.setReadOnly(keyFile2);
                        this.setHidden(ACTUAL_KEY_FILE_PATH);
                    }
                    FileUtil.forceDeletion(backupedKeyFile);
                }
                if (backupedDeprecatedKeyFile == null) return void_;
                if (restore) {
                    keyFile2 = new File(DEPRECATED_KEY_FILE_PATH);
                    Files.delete(keyFile2.toPath());
                    FileUtil.copyFile(backupedDeprecatedKeyFile, keyFile2);
                    this.setReadOnly(keyFile2);
                    this.setHidden(DEPRECATED_KEY_FILE_PATH);
                }
                FileUtil.forceDeletion(backupedDeprecatedKeyFile);
                return void_;
            }
            catch (IOException ex) {
                SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            }
            return void_;
        }

        private void setReadOnly(File keyFile) {
            if (!keyFile.setReadOnly()) {
                SilverLogger.getLogger((Object)this).warn("Cannot set readonly the key file " + keyFile.getName(), new Object[0]);
            }
        }

        private void setHidden(String file) {
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                try {
                    Runtime.getRuntime().exec("attrib +H " + file);
                }
                catch (IOException ex) {
                    SilverLogger.getLogger((Object)this).warn((Throwable)ex);
                }
            }
        }
    }

    private static class EncryptionContentIteratorWrapper
    implements EncryptionContentIterator {
        private final EncryptionContentIterator wrapped;

        public EncryptionContentIteratorWrapper(EncryptionContentIterator iterator) {
            this.wrapped = iterator;
        }

        @Override
        public Map<String, String> next() {
            return this.wrapped.next();
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public void update(Map<String, String> updatedContent) {
            this.wrapped.update(updatedContent);
        }

        @Override
        public void onError(Map<String, String> content, CryptoException ex) {
            try {
                this.wrapped.onError(content, ex);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Error while treating the caught CryptoException exception", (Throwable)e);
            }
            throw new CipherRenewingException(ex);
        }

        @Override
        public void remove() {
            this.wrapped.remove();
        }

        @Override
        public void init() {
            this.wrapped.init();
        }
    }
}

