/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPJSSESecureSocketFactory;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.MissingFormatArgumentException;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LdapConfiguration;
import org.silverpeas.core.security.authentication.AuthenticationConnection;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.AuthenticationProtocol;
import org.silverpeas.core.security.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.exception.AuthenticationHostException;
import org.silverpeas.core.security.authentication.exception.AuthenticationPasswordAboutToExpireException;
import org.silverpeas.core.security.authentication.exception.AuthenticationPasswordExpired;
import org.silverpeas.core.security.authentication.exception.AuthenticationPasswordMustBeChangedAtNextLogon;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class AuthenticationLDAP
extends AuthenticationProtocol {
    private static final int INTERVALS_PER_MILLISECOND = 10000;
    private static final long MILLISECONDS_BETWEEN_1601_AND_1970 = Long.parseLong("11644473600000");
    private static final String BASE_DN_SEPARATOR = ";;";
    private static final int FORMAT_NANOSECOND = 0;
    private static final int FORMAT_TIMESTAMP = 1;
    private static final DateTimeFormatter GENERALIZED_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendValue(ChronoField.HOUR_OF_DAY, 2).appendOptional(new DateTimeFormatterBuilder().appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendOptional(DateTimeFormatter.ofPattern("ss")).toFormatter()).appendOptional(new DateTimeFormatterBuilder().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 9, true).toFormatter()).appendPattern("X").toFormatter();
    private static final String USER_NOT_FOUND_WITH_LOGIN = "User not found with login: ";
    private static final String UNICODE_PASS_ATTR = "unicodePwd";
    private boolean mustAlertPasswordExpiration = false;
    private String pwdLastSetFieldName;
    private int pwdDateTimeFieldFormat;
    private int pwdMaxAge;
    private int pwdExpirationReminderDelay = -1;
    private String pwdExpirationTimeFieldName;
    private String ldapImpl;
    private String userBaseDN;
    private String userLoginFieldName;
    private final LdapConfiguration configuration = new LdapConfiguration();

    @Override
    public void loadProperties(SettingBundle settings) {
        String serverName = this.getServerName();
        this.configuration.setEncryptedCredentials(settings.getBoolean(serverName + ".encryptedCredentials", false));
        this.configuration.setSecure(settings.getBoolean(serverName + ".LDAPSecured", false));
        this.configuration.setLdapHost(settings.getString(serverName + ".LDAPHost"));
        if (this.configuration.isSecure()) {
            this.configuration.setLdapPort(settings.getInteger(serverName + ".LDAPSecuredPort", 636));
        } else {
            this.configuration.setLdapPort(settings.getInteger(serverName + ".LDAPPort", 389));
        }
        this.configuration.setTimeout(settings.getInteger(serverName + ".Timeout", 0));
        this.ldapImpl = settings.getString(serverName + ".LDAPImpl", "unknown");
        this.configuration.setUsername(settings.getString(serverName + ".LDAPAccessLogin"));
        this.configuration.setPassword(settings.getString(serverName + ".LDAPAccessPasswd"));
        this.userBaseDN = settings.getString(serverName + ".LDAPUserBaseDN", "");
        this.userLoginFieldName = settings.getString(serverName + ".LDAPUserLoginFieldName");
        this.setPasswordExpirationConfiguration(serverName, settings);
    }

    private void setPasswordExpirationConfiguration(String serverName, SettingBundle settings) {
        this.mustAlertPasswordExpiration = settings.getBoolean(serverName + ".MustAlertPasswordExpiration", false);
        this.pwdExpirationReminderDelay = -1;
        if (this.mustAlertPasswordExpiration) {
            this.pwdExpirationTimeFieldName = settings.getString(serverName + ".LDAPPwdExpirationTimeFieldName", null);
            if (this.pwdExpirationTimeFieldName == null) {
                this.pwdLastSetFieldName = settings.getString(serverName + ".LDAPPwdLastSetFieldName", null);
                if (this.pwdLastSetFieldName == null) {
                    this.mustAlertPasswordExpiration = false;
                } else {
                    this.pwdMaxAge = settings.getInteger(serverName + ".LDAPPwdMaxAge", Integer.MAX_VALUE);
                    this.pwdExpirationReminderDelay = settings.getInteger(serverName + ".PwdExpirationReminderDelay", 5);
                }
            }
            if (this.mustAlertPasswordExpiration) {
                String propValue = settings.getString(serverName + ".LDAPTimeFieldFormat", "");
                if (propValue.equals("nanoseconds")) {
                    this.pwdDateTimeFieldFormat = 0;
                } else if (propValue.equals("TimeStamp")) {
                    this.pwdDateTimeFieldFormat = 1;
                } else {
                    throw new MissingFormatArgumentException("The property " + serverName + ".LDAPTimeFieldFormat isn't valued correctly. Expected either 'nanoseconds' or 'TimeStamp'");
                }
            }
        }
    }

    protected AuthenticationConnection<LDAPConnection> openConnection() throws AuthenticationException {
        LDAPConnection ldapConnection = this.configuration.isSecure() ? new LDAPConnection((LDAPSocketFactory)new LDAPJSSESecureSocketFactory()) : new LDAPConnection();
        if (this.configuration.getTimeout() > 0) {
            ldapConnection.setSocketTimeOut(this.configuration.getTimeout());
        }
        try {
            ldapConnection.connect(this.configuration.getLdapHost(), this.configuration.getLdapPort());
        }
        catch (LDAPException ex) {
            throw new AuthenticationHostException("Connection to the LDAP server failed with the following configuration: " + String.valueOf(this.configuration), (Throwable)ex);
        }
        return new AuthenticationConnection<LDAPConnection>(ldapConnection);
    }

    protected void closeConnection(AuthenticationConnection connection) throws AuthenticationException {
        try {
            LDAPConnection ldapConnection = AuthenticationLDAP.getLDAPConnection(connection);
            if (ldapConnection != null && ldapConnection.isConnected()) {
                ldapConnection.disconnect();
            }
        }
        catch (Exception ex) {
            throw new AuthenticationHostException("Cannot close the connection with the LDAP server with the following configuration: " + String.valueOf(this.configuration), (Throwable)ex);
        }
    }

    protected void doAuthentication(AuthenticationConnection connection, AuthenticationCredential credential) throws AuthenticationException {
        Duration durationBeforePwdExpiration;
        long daysCountBeforeExpiration;
        LDAPConnection ldapConnection = this.openLDAPConnection(connection);
        LDAPEntry userEntry = this.findLDAPUserMatchingCredential(ldapConnection, credential);
        ZonedDateTime pwdExpirationDateTime = this.checkPasswordExpiration(userEntry);
        this.checkPasswordIsValid(ldapConnection, userEntry, credential);
        if (pwdExpirationDateTime != null && this.pwdExpirationReminderDelay > -1 && (daysCountBeforeExpiration = (durationBeforePwdExpiration = Duration.between(ZonedDateTime.now(), pwdExpirationDateTime)).getSeconds() / 86400L) < (long)this.pwdExpirationReminderDelay) {
            throw new AuthenticationPasswordAboutToExpireException("The password of the user with login " + credential.getLogin() + " is about to expire", new String[0]);
        }
    }

    private void checkPasswordIsValid(LDAPConnection ldapConnection, LDAPEntry userEntry, AuthenticationCredential credential) throws AuthenticationBadCredentialException {
        String userFullDN = userEntry.getDN();
        if (!StringUtil.isDefined((String)credential.getPassword())) {
            throw new AuthenticationBadCredentialException("Password not set for user with login: " + credential.getLogin(), new String[0]);
        }
        try {
            ldapConnection.bind(3, userFullDN, credential.getPassword().getBytes(Charsets.UTF_8));
        }
        catch (LDAPException ex) {
            throw new AuthenticationBadCredentialException("Bad credential for user with login: " + credential.getLogin(), (Throwable)ex);
        }
    }

    @Nullable
    private ZonedDateTime checkPasswordExpiration(LDAPEntry userEntry) throws AuthenticationPasswordMustBeChangedAtNextLogon, AuthenticationPasswordExpired {
        ZonedDateTime pwdExpirationDateTime;
        if (this.mustAlertPasswordExpiration) {
            pwdExpirationDateTime = this.getPasswordExpirationDateTime(userEntry);
            if (pwdExpirationDateTime == null) {
                throw new AuthenticationPasswordMustBeChangedAtNextLogon("Password required to be change at next logon for user " + userEntry.getDN(), new String[0]);
            }
            if (pwdExpirationDateTime.isBefore(ZonedDateTime.now())) {
                throw new AuthenticationPasswordExpired("Password expired for user " + userEntry.getDN(), new String[0]);
            }
        } else {
            pwdExpirationDateTime = null;
        }
        return pwdExpirationDateTime;
    }

    @Nonnull
    private LDAPEntry findLDAPUserMatchingCredential(LDAPConnection ldapConnection, AuthenticationCredential credential) throws AuthenticationHostException, AuthenticationBadCredentialException {
        String searchString = this.userLoginFieldName + "=" + credential.getLogin();
        String[] attrNames = this.getLDAPAttributeNamesToSeek();
        String[] baseDNs = AuthenticationLDAP.extractBaseDNs(this.userBaseDN);
        LDAPEntry userEntry = null;
        for (String baseDN : baseDNs) {
            try {
                LDAPSearchResults res = ldapConnection.search(baseDN, 2, searchString, attrNames, false);
                if (!res.hasMore()) continue;
                userEntry = res.next();
                break;
            }
            catch (LDAPException ex) {
                throw new AuthenticationHostException((Throwable)ex);
            }
        }
        if (userEntry == null) {
            throw new AuthenticationBadCredentialException(USER_NOT_FOUND_WITH_LOGIN + credential.getLogin() + " and LDAP login field " + this.userLoginFieldName, new String[0]);
        }
        return userEntry;
    }

    @Nonnull
    private String[] getLDAPAttributeNamesToSeek() {
        String[] attrNames = this.mustAlertPasswordExpiration ? (this.pwdExpirationTimeFieldName != null ? new String[]{"uid", this.pwdExpirationTimeFieldName} : new String[]{"uid", this.pwdLastSetFieldName}) : new String[]{"uid"};
        return attrNames;
    }

    @Nonnull
    private LDAPConnection openLDAPConnection(AuthenticationConnection<LDAPConnection> connection) throws AuthenticationHostException {
        LDAPConnection ldapConnection = AuthenticationLDAP.getLDAPConnection(connection);
        try {
            ldapConnection.bind(3, this.configuration.getUsername(), this.configuration.getPassword());
        }
        catch (LDAPException e) {
            throw new AuthenticationHostException((Throwable)e);
        }
        return ldapConnection;
    }

    private ZonedDateTime getPasswordExpirationDateTime(LDAPEntry entry) {
        ZonedDateTime expirationDateTime;
        if (this.pwdExpirationTimeFieldName != null) {
            LDAPAttribute pwdExpirationTime = entry.getAttribute(this.pwdExpirationTimeFieldName);
            expirationDateTime = this.getPasswordExpirationDateTime(this.pwdExpirationTimeFieldName, pwdExpirationTime);
        } else {
            LDAPAttribute pwdChangeTime = entry.getAttribute(this.pwdLastSetFieldName);
            ZonedDateTime lastChangeDateTime = this.getPasswordExpirationDateTime(this.pwdLastSetFieldName, pwdChangeTime);
            expirationDateTime = lastChangeDateTime != null ? lastChangeDateTime.plusDays(this.pwdMaxAge) : null;
        }
        return expirationDateTime;
    }

    private ZonedDateTime getPasswordExpirationDateTime(String attrName, LDAPAttribute dateTimeAttr) {
        ZonedDateTime expirationDateTime;
        if (dateTimeAttr == null) {
            SilverLogger.getLogger((Object)this).warn("Not such LDAP attribute {0}! No password expiration", new Object[]{attrName});
            expirationDateTime = ZonedDateTime.now().plusDays(1L);
        } else {
            String dateTimeValue = dateTimeAttr.getStringValue();
            if (dateTimeValue == null) {
                SilverLogger.getLogger((Object)this).warn("LDAP Attribute {0} not valued! No password expiration", new Object[]{attrName});
                expirationDateTime = ZonedDateTime.now().plusDays(1L);
            } else {
                expirationDateTime = this.parseDateTimeValue(dateTimeValue);
            }
        }
        return expirationDateTime;
    }

    private ZonedDateTime parseDateTimeValue(String value) {
        ZonedDateTime dateTime;
        if (this.pwdDateTimeFieldFormat == 0) {
            long nanoseconds = Long.parseLong(value);
            if (nanoseconds == 0L) {
                dateTime = null;
            } else {
                nanoseconds = nanoseconds / 10000L - MILLISECONDS_BETWEEN_1601_AND_1970;
                dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(nanoseconds), ZoneId.systemDefault());
            }
        } else {
            dateTime = OffsetDateTime.parse(value, GENERALIZED_TIME).atZoneSameInstant(ZoneId.systemDefault());
        }
        return dateTime;
    }

    protected void doChangePassword(AuthenticationConnection connection, AuthenticationCredential credential, String newPassword) throws AuthenticationException {
        String login = credential.getLogin();
        String oldPassword = credential.getPassword();
        String searchString = this.userLoginFieldName + "=" + login;
        String[] strAttributes = new String[]{"sAMAccountName", "memberOf"};
        LDAPConnection ldapConnection = AuthenticationLDAP.getLDAPConnection(connection);
        try {
            LDAPModification[] mod;
            LDAPSearchResults res = this.search(ldapConnection, login, searchString, strAttributes);
            LDAPEntry fe = res.next();
            String userFullDN = fe.getDN();
            if ("opends".equalsIgnoreCase(this.ldapImpl) || "openldap".equalsIgnoreCase(this.ldapImpl)) {
                ldapConnection.bind(3, userFullDN, oldPassword.getBytes(Charsets.UTF_8));
                mod = this.changeOpenDSPassword(newPassword);
            } else {
                if (!this.configuration.isSecure()) {
                    UnsupportedOperationException e = new UnsupportedOperationException("LDAP connection must be secured to allow password update");
                    throw new AuthenticationException((Throwable)e);
                }
                mod = this.getActiveDirectoryPasswordChange(oldPassword, newPassword);
            }
            ldapConnection.modify(userFullDN, mod);
        }
        catch (Exception ex) {
            throw new AuthenticationHostException((Throwable)ex);
        }
    }

    private LDAPSearchResults search(LDAPConnection ldapConnection, String login, String searchString, String[] strAttributes) throws LDAPException, AuthenticationBadCredentialException {
        ldapConnection.bind(3, this.configuration.getUsername(), this.configuration.getPassword());
        LDAPSearchResults res = ldapConnection.search(this.userBaseDN, 2, searchString, strAttributes, false);
        if (!res.hasMore()) {
            throw new AuthenticationBadCredentialException(USER_NOT_FOUND_WITH_LOGIN + login + ";LoginField=" + this.userLoginFieldName, new String[0]);
        }
        return res;
    }

    private LDAPModification[] getActiveDirectoryPasswordChange(String oldPassword, String newPassword) {
        byte[] oldUnicodePassword = this.getActiveDirectoryUnicodePwd(oldPassword);
        byte[] newUnicodePassword = this.getActiveDirectoryUnicodePwd(newPassword);
        LDAPModification[] res = new LDAPModification[]{new LDAPModification(1, new LDAPAttribute(UNICODE_PASS_ATTR, oldUnicodePassword)), new LDAPModification(0, new LDAPAttribute(UNICODE_PASS_ATTR, newUnicodePassword))};
        return res;
    }

    private LDAPModification[] getActiveDirectoryPasswordReset(String newPassword) {
        byte[] newUnicodePassword = this.getActiveDirectoryUnicodePwd(newPassword);
        return new LDAPModification[]{new LDAPModification(2, new LDAPAttribute(UNICODE_PASS_ATTR, newUnicodePassword))};
    }

    private byte[] getActiveDirectoryUnicodePwd(String password) {
        String newQuotedPassword = "\"" + password + "\"";
        return newQuotedPassword.getBytes(Charsets.UTF_16LE);
    }

    private LDAPModification[] changeOpenDSPassword(String newPassword) {
        return new LDAPModification[]{new LDAPModification(2, new LDAPAttribute("userPassword", newPassword))};
    }

    private static String[] extractBaseDNs(String baseDN) {
        if (!baseDN.contains(BASE_DN_SEPARATOR)) {
            String[] baseDNs = new String[]{baseDN};
            return baseDNs;
        }
        StringTokenizer st = new StringTokenizer(baseDN, BASE_DN_SEPARATOR);
        ArrayList<String> baseDNs = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            baseDNs.add(st.nextToken());
        }
        return baseDNs.toArray(new String[0]);
    }

    protected void doResetPassword(AuthenticationConnection connection, String login, boolean loginIgnoreCase, String newPassword) throws AuthenticationException {
        String searchString = this.userLoginFieldName + "=" + login;
        String[] strAttributes = new String[]{"sAMAccountName", "memberOf"};
        LDAPConnection ldapConnection = AuthenticationLDAP.getLDAPConnection(connection);
        try {
            LDAPSearchResults res = this.search(ldapConnection, login, searchString, strAttributes);
            LDAPEntry fe = res.next();
            String userFullDN = fe.getDN();
            LDAPModification[] mod = null;
            if (!StringUtil.isDefined((String)this.ldapImpl) || "ad".equalsIgnoreCase(this.ldapImpl)) {
                mod = this.getActiveDirectoryPasswordReset(newPassword);
            } else if ("opends".equalsIgnoreCase(this.ldapImpl) || "openldap".equalsIgnoreCase(this.ldapImpl)) {
                mod = this.changeOpenDSPassword(newPassword);
            }
            ldapConnection.modify(userFullDN, mod);
        }
        catch (Exception ex) {
            throw new AuthenticationHostException((Throwable)ex);
        }
    }

    private static LDAPConnection getLDAPConnection(AuthenticationConnection<LDAPConnection> connection) {
        return connection.getConnector();
    }
}

