/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.channel.server;

import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.user.server.channel.server.ServerMessageBean;
import org.silverpeas.core.notification.user.server.channel.server.ServerMessageBeanRepository;
import org.silverpeas.core.notification.user.server.channel.server.ServerMessageService;
import org.silverpeas.core.notification.user.server.channel.server.ServerMsg;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.jdbc.LongText;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
public class DefaultServerMessageService
implements ServerMessageService {
    protected DefaultServerMessageService() {
    }

    @Override
    public ServerMsg read(String userId, String sessionId) {
        ServerMsg serverMsg = null;
        ServerMessageBean smb = null;
        try {
            smb = this.getRepository().findFirstMessageByUserIdAndSessionId(userId, sessionId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Cannot read message for user {0}", (Object[])new String[]{userId}, (Throwable)e);
        }
        if (smb != null) {
            String msg = null;
            try {
                int longTextId = Integer.parseInt(smb.getBody());
                msg = LongText.getLongText((int)longTextId);
            }
            catch (NumberFormatException nfe) {
                msg = smb.getBody();
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Cannot read message for user {0}", (Object[])new String[]{userId}, (Throwable)e);
            }
            if (msg != null) {
                serverMsg = new ServerMsg("ALERT");
                serverMsg.setContent(msg);
                serverMsg.setID(smb.getId());
            }
        }
        return serverMsg;
    }

    @Override
    @Transactional
    public void deleteById(String msgId) {
        ServerMessageBeanRepository repository = this.getRepository();
        ServerMessageBean toDel = (ServerMessageBean)repository.getById(msgId);
        if (toDel != null) {
            try {
                int longTextId = Integer.parseInt(toDel.getBody());
                LongText.removeLongText((int)longTextId);
            }
            catch (NumberFormatException longTextId) {
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Cannot delete message {0}", (Object[])new String[]{msgId}, (Throwable)e);
            }
            try {
                repository.delete((IdentifiableEntity[])new ServerMessageBean[]{toDel});
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Cannot delete message {0}", (Object[])new String[]{msgId}, (Throwable)e);
            }
        }
    }

    @Override
    @Transactional
    public void deleteAll(String userId, String sessionId) {
        try {
            this.getRepository().deleteAllMessagesByUserIdAndSessionId(userId, sessionId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Cannot delete all messages for user {0}", (Object[])new String[]{userId}, (Throwable)e);
        }
    }

    @Override
    @Transactional
    public void push(String userId, String message, String sessionId) {
        ServerMessageBean pmb = new ServerMessageBean();
        try {
            pmb.setUserId(Long.parseLong(userId));
            pmb.setBody(Integer.toString(LongText.addLongText((String)message)));
            pmb.setSessionId(sessionId);
            this.getRepository().save((IdentifiableEntity)pmb);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Cannot push message {0} for user {1}", (Object[])new String[]{message, userId}, (Throwable)e);
        }
    }

    private ServerMessageBeanRepository getRepository() {
        return (ServerMessageBeanRepository)((Object)ServiceProvider.getService(ServerMessageBeanRepository.class, (Annotation[])new Annotation[0]));
    }
}

