/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.node.coordinates.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.node.coordinates.model.Coordinate;
import org.silverpeas.core.node.coordinates.model.CoordinatePK;
import org.silverpeas.core.node.coordinates.model.CoordinatePoint;
import org.silverpeas.core.node.coordinates.model.CoordinateRuntimeException;
import org.silverpeas.core.node.coordinates.persistence.CoordinatesDAO;
import org.silverpeas.core.node.coordinates.service.CoordinatesService;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;

@Service
@Transactional
public class DefaultCoordinatesService
implements CoordinatesService,
ComponentInstanceDeletion {
    protected DefaultCoordinatesService() {
    }

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new CoordinateRuntimeException(e);
        }
    }

    @Override
    public Collection<String> getCoordinatesByFatherIds(List<Integer> fatherIds, CoordinatePK pk) {
        Connection con = this.getConnection();
        try {
            Collections.sort(fatherIds);
            Collection<String> collection = CoordinatesDAO.selectByFatherIds(con, fatherIds, pk);
            return collection;
        }
        catch (SQLException e) {
            throw new CoordinateRuntimeException("No coordinates available by father id", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<String> getCoordinatesByFatherPaths(List<String> fatherPaths, CoordinatePK pk) {
        Connection con = this.getConnection();
        try {
            Collection<String> collection = CoordinatesDAO.selectByFatherPaths(con, fatherPaths, pk);
            return collection;
        }
        catch (SQLException e) {
            throw new CoordinateRuntimeException("No coordinates available by father path", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public int addCoordinate(CoordinatePK pk, List<CoordinatePoint> coordinatePoints) {
        Connection con = this.getConnection();
        try {
            int n = CoordinatesDAO.addCoordinate(con, pk, coordinatePoints);
            return n;
        }
        catch (SQLException e) {
            throw new CoordinateRuntimeException("Coordinates adding failure", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteCoordinates(CoordinatePK pk, List<String> coordinates) {
        Connection con = this.getConnection();
        try {
            CoordinatesDAO.removeCoordinates(con, pk, coordinates);
        }
        catch (SQLException e) {
            throw new CoordinateRuntimeException("Coordinates deletion failure", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteCoordinatesByPoints(CoordinatePK pk, List<String> coordinatePoints) {
        Connection con = this.getConnection();
        try {
            CoordinatesDAO.removeCoordinatesByPoints(con, pk, coordinatePoints);
        }
        catch (SQLException e) {
            throw new CoordinateRuntimeException("Coordinate deletion by points failure", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<Coordinate> getCoordinatesByCoordinateIds(List<String> coordinateIds, CoordinatePK pk) {
        Connection con = this.getConnection();
        try {
            List<Coordinate> list = CoordinatesDAO.selectCoordinatesByCoordinateIds(con, coordinateIds, pk);
            return list;
        }
        catch (SQLException e) {
            throw new CoordinateRuntimeException("No available coordinates", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void addPointToAllCoordinates(CoordinatePK pk, CoordinatePoint point) {
        Connection con = this.getConnection();
        try {
            CoordinatesDAO.addPointToAllCoordinates(con, pk, point);
        }
        catch (SQLException e) {
            throw new CoordinateRuntimeException("Points adding to coordinate failure", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<String> getCoordinateIdsByNodeId(CoordinatePK pk, String nodeId) {
        Connection con = this.getConnection();
        try {
            Collection<String> collection = CoordinatesDAO.getCoordinateIdsByNodeId(con, pk, nodeId);
            return collection;
        }
        catch (SQLException e) {
            throw new CoordinateRuntimeException("Coordinate by node id getting failure", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional
    public void delete(String componentInstanceId) {
        try (Connection connection = DBUtil.openConnection();){
            CoordinatesDAO.removeCoordinatesByInstanceId(connection, componentInstanceId);
        }
        catch (SQLException e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

