/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.search.model;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRef;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.IndexFileManager;
import org.silverpeas.core.index.indexing.model.ExternalComponent;
import org.silverpeas.core.index.indexing.model.FieldDescription;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.index.indexing.model.IndexManager;
import org.silverpeas.core.index.indexing.model.IndexProcessor;
import org.silverpeas.core.index.indexing.model.IndexReadersCache;
import org.silverpeas.core.index.search.SearchEnginePropertiesManager;
import org.silverpeas.core.index.search.model.MatchingIndexEntry;
import org.silverpeas.core.index.search.model.ParseException;
import org.silverpeas.core.index.search.model.QueryDescription;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Technical
@Bean
@Singleton
public class IndexSearcher {
    private static final String INDEX_SEARCH_ERROR = "Index search failure";
    private static final int DEFAULT_MAX_RESULT = 100;
    private static final int DEFAULT_FIELD_HEADER_BOOST = 3;
    private QueryParser.Operator defaultOperator;
    private int fieldHeaderBoost;
    @Inject
    private IndexManager indexManager = IndexManager.get();
    private int maxNumberResult;

    private IndexSearcher() {
    }

    public static IndexSearcher get() {
        return (IndexSearcher)ServiceProvider.getService(IndexSearcher.class, (Annotation[])new Annotation[0]);
    }

    public QueryParser.Operator getDefaultOperator() {
        return this.defaultOperator;
    }

    @PostConstruct
    private void init() {
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.index.search.searchEngineSettings");
        int paramOperand = settings.getInteger("defaultOperand", 0);
        this.defaultOperator = paramOperand == 0 ? QueryParserBase.OR_OPERATOR : QueryParserBase.AND_OPERATOR;
        this.maxNumberResult = settings.getInteger("maxResults", 100);
        this.fieldHeaderBoost = settings.getInteger("boost.field.header", 3);
    }

    public MatchingIndexEntry search(String component, String objectId, String objectType) throws ParseException {
        return IndexProcessor.doSearch(() -> {
            Set<String> set = Collections.singleton(component);
            IndexEntryKey indexEntryKey = new IndexEntryKey(component, objectType, objectId);
            MatchingIndexEntry matchingIndexEntry = null;
            org.apache.lucene.search.IndexSearcher searcher = this.getSearcher(set);
            try {
                Term term = new Term("key", indexEntryKey.toString());
                TermQuery query = new TermQuery(term);
                TopDocs topDocs = searcher.search((Query)query, this.maxNumberResult);
                ScoreDoc scoreDoc = topDocs.scoreDocs[0];
                matchingIndexEntry = this.createMatchingIndexEntry(scoreDoc, "*", searcher);
            }
            catch (IOException ioe) {
                SilverLogger.getLogger((Object)this).error("Index file corrupted", (Throwable)ioe);
            }
            return matchingIndexEntry;
        }, () -> null);
    }

    public MatchingIndexEntry[] search(QueryDescription query) throws ParseException {
        return IndexProcessor.doSearch(() -> {
            List<Object> results;
            long startTime = System.currentTimeMillis();
            org.apache.lucene.search.IndexSearcher searcher = this.getSearcher(query);
            try {
                TopDocs topDocs;
                BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
                BooleanQuery.Builder rangeClausesBuilder = new BooleanQuery.Builder();
                rangeClausesBuilder.add((Query)this.getVisibilityStartQuery(), BooleanClause.Occur.MUST);
                rangeClausesBuilder.add((Query)this.getVisibilityEndQuery(), BooleanClause.Occur.MUST);
                booleanQueryBuilder.add((Query)this.getScopeQuery(query), BooleanClause.Occur.FILTER);
                this.parseQuery(query, booleanQueryBuilder, rangeClausesBuilder);
                BooleanQuery booleanQuery = booleanQueryBuilder.build();
                BooleanQuery rangeClauses = rangeClausesBuilder.build();
                if (booleanQuery.clauses().isEmpty()) {
                    topDocs = searcher.search((Query)rangeClauses, this.maxNumberResult);
                    SilverLogger.getLogger((Object)this).info(rangeClauses.toString(), new Object[0]);
                } else {
                    booleanQueryBuilder.add((Query)rangeClauses, BooleanClause.Occur.FILTER);
                    booleanQuery = booleanQueryBuilder.build();
                    SilverLogger.getLogger((Object)this).info(booleanQuery.toString(), new Object[0]);
                    topDocs = searcher.search((Query)booleanQuery, this.maxNumberResult);
                }
                results = this.makeList(topDocs, query, searcher);
            }
            catch (IOException ioe) {
                SilverLogger.getLogger((Object)this).error("Index file corrupted", (Throwable)ioe);
                results = new ArrayList();
            }
            long endTime = System.currentTimeMillis();
            int nbResults = results.size();
            SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format(" search index duration in {0} with {1} matching entries", DurationFormatUtils.formatDurationHMS((long)(endTime - startTime)), nbResults));
            return results.toArray(new MatchingIndexEntry[0]);
        }, () -> new MatchingIndexEntry[0]);
    }

    private void parseQuery(QueryDescription query, BooleanQuery.Builder booleanQueryBuilder, BooleanQuery.Builder rangeClausesBuilder) throws ParseException {
        if (query.getMultiFieldQuery() != null) {
            booleanQueryBuilder.add(this.getMultiFieldQuery(query), BooleanClause.Occur.MUST);
        }
        this.parseRangeQuery(query, booleanQueryBuilder, rangeClausesBuilder);
    }

    private void parseRangeQuery(QueryDescription query, BooleanQuery.Builder booleanQueryBuilder, BooleanQuery.Builder rangeClausesBuilder) throws ParseException {
        PrefixQuery termQueryOnFolder;
        TermQuery termQueryOnAuthor;
        TermRangeQuery rangeQueryOnLastUpdateDate;
        TermRangeQuery rangeQuery = this.getRangeQueryOnCreationDate(query);
        if (!StringUtil.isDefined((String)query.getQuery()) && !query.isPeriodDefined()) {
            rangeQuery = TermRangeQuery.newStringRange((String)"creationDate", (String)"1900/01/01", (String)"2200/01/01", (boolean)true, (boolean)true);
        }
        if (rangeQuery != null) {
            rangeClausesBuilder.add((Query)rangeQuery, BooleanClause.Occur.MUST);
        }
        if ((rangeQueryOnLastUpdateDate = this.getRangeQueryOnLastUpdateDate(query)) != null) {
            rangeClausesBuilder.add((Query)rangeQueryOnLastUpdateDate, BooleanClause.Occur.MUST);
        }
        if ((termQueryOnAuthor = this.getTermQueryOnAuthor(query)) != null) {
            booleanQueryBuilder.add((Query)termQueryOnAuthor, BooleanClause.Occur.MUST);
        }
        if ((termQueryOnFolder = this.getTermQueryOnFolder(query)) != null) {
            booleanQueryBuilder.add((Query)termQueryOnFolder, BooleanClause.Occur.MUST);
        }
        try {
            Query plainTextQuery = this.getPlainTextQuery(query);
            if (plainTextQuery != null) {
                booleanQueryBuilder.add(plainTextQuery, BooleanClause.Occur.MUST);
            }
        }
        catch (ParseException e) {
            throw new ParseException(INDEX_SEARCH_ERROR, (Throwable)((Object)e));
        }
    }

    private TermRangeQuery getVisibilityStartQuery() {
        return TermRangeQuery.newStringRange((String)"startDate", (String)"19000101", (String)this.formatDate(LocalDate.now()), (boolean)true, (boolean)true);
    }

    private TermRangeQuery getVisibilityEndQuery() {
        return TermRangeQuery.newStringRange((String)"endDate", (String)this.formatDate(LocalDate.now()), (String)"24001231", (boolean)true, (boolean)true);
    }

    private Query getPlainTextQuery(QueryDescription query) throws ParseException {
        if (!StringUtil.isDefined((String)query.getQuery())) {
            return null;
        }
        Set<String> languages = this.getRequestedLanguages(query);
        Query queryOnContent = this.getQuery("content", query.getQuery(), languages);
        Query queryOnHeader = this.getQuery("header", query.getQuery(), languages);
        BoostQuery boostQuery = new BoostQuery(queryOnHeader, (float)this.fieldHeaderBoost);
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        booleanQuery.add((Query)boostQuery, BooleanClause.Occur.SHOULD);
        booleanQuery.add(queryOnContent, BooleanClause.Occur.SHOULD);
        booleanQuery.setMinimumNumberShouldMatch(1);
        return booleanQuery.build();
    }

    private Query getMultiFieldQuery(QueryDescription query) throws ParseException {
        try {
            Set<String> languages = this.getRequestedLanguages(query);
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            Query plainTextQuery = this.getPlainTextQuery(query);
            if (plainTextQuery != null) {
                booleanQuery.add(plainTextQuery, BooleanClause.Occur.MUST);
            }
            List<FieldDescription> fieldQueries = query.getMultiFieldQuery();
            for (FieldDescription fieldQuery : fieldQueries) {
                if (fieldQuery.isBasedOnDate()) {
                    TermRangeQuery rangeQuery = this.getTermRangeQuery(fieldQuery.getFieldName(), fieldQuery.getStartDate(), fieldQuery.getEndDate());
                    if (rangeQuery == null) continue;
                    booleanQuery.add((Query)rangeQuery, BooleanClause.Occur.MUST);
                    continue;
                }
                if (!StringUtil.isDefined((String)fieldQuery.getContent())) continue;
                Query fieldI18NQuery = this.getQuery(fieldQuery.getFieldName(), fieldQuery.getContent(), languages);
                booleanQuery.add(fieldI18NQuery, BooleanClause.Occur.MUST);
            }
            return booleanQuery.build();
        }
        catch (ParseException e) {
            throw new ParseException(INDEX_SEARCH_ERROR, (Throwable)((Object)e));
        }
    }

    private Set<String> getRequestedLanguages(QueryDescription query) {
        return query.getRequestedLanguage().map(Collections::singleton).orElseGet(I18NHelper::getAllSupportedLanguages);
    }

    private Query getQuery(String fieldName, String queryStr, Set<String> languages) throws ParseException {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        for (String language : languages) {
            RegexpQuery query;
            Analyzer analyzer = this.indexManager.getAnalyzer(language);
            if (queryStr.startsWith("Regexp:")) {
                queryStr = queryStr.substring(7);
                query = new RegexpQuery(new Term(this.getFieldName(fieldName, language), queryStr));
            } else {
                QueryParser parser = new QueryParser(this.getFieldName(fieldName, language), analyzer);
                parser.setDefaultOperator(this.defaultOperator);
                query = this.parse(parser, "+" + queryStr);
            }
            if (query == null) continue;
            booleanQueryBuilder.add((Query)query, BooleanClause.Occur.SHOULD);
        }
        return booleanQueryBuilder.build();
    }

    private Query parse(QueryParser parser, String toParse) throws ParseException {
        Query query;
        try {
            query = parser.parse(toParse);
        }
        catch (org.apache.lucene.queryparser.classic.ParseException e) {
            try {
                query = parser.parse(QueryParserBase.escape((String)toParse));
            }
            catch (org.apache.lucene.queryparser.classic.ParseException pe) {
                throw new ParseException(INDEX_SEARCH_ERROR, e);
            }
        }
        return query;
    }

    private String getFieldName(String name, String language) {
        if (!I18NHelper.isI18nContentActivated || I18NHelper.isDefaultLanguage(language)) {
            return name;
        }
        return name + "_" + language;
    }

    private MatchingIndexEntry createMatchingIndexEntry(ScoreDoc scoreDoc, String requestedLanguage, org.apache.lucene.search.IndexSearcher searcher) throws IOException {
        Document doc = searcher.doc(scoreDoc.doc);
        MatchingIndexEntry indexEntry = new MatchingIndexEntry(IndexEntryKey.create(doc.get("key")));
        this.setIndexEntryLanguageData(indexEntry, doc);
        this.setIndexEntryCommonData(indexEntry, doc, scoreDoc);
        this.setIndexEntryPublicationData(indexEntry, doc, requestedLanguage);
        this.setIndexEntryFacetData(indexEntry, doc);
        indexEntry.setServerName(doc.get("serverName"));
        return indexEntry;
    }

    private void setIndexEntryFacetData(MatchingIndexEntry indexEntry, Document doc) {
        String fieldsForFacets = doc.get("fieldsForFacet");
        if (StringUtil.isDefined((String)fieldsForFacets)) {
            HashMap<String, String> fieldsValueForFacets = new HashMap<String, String>();
            StringTokenizer tokenizer = new StringTokenizer(fieldsForFacets, ",");
            while (tokenizer.hasMoreTokens()) {
                String fieldName = tokenizer.nextToken();
                fieldsValueForFacets.put(fieldName, doc.get(fieldName));
            }
            indexEntry.setXMLFormFieldsForFacets(fieldsValueForFacets);
        }
    }

    private void setIndexEntryPublicationData(MatchingIndexEntry indexEntry, Document doc, String requestedLanguage) {
        if ("Publication".equals(indexEntry.getObjectType())) {
            HashMap<String, String> sortableField = new HashMap<String, String>();
            for (String formXMLFieldName : SearchEnginePropertiesManager.getFieldsNameList()) {
                String fieldValue = "*".equals(requestedLanguage) || I18NHelper.isDefaultLanguage(requestedLanguage) ? doc.get(formXMLFieldName) : doc.get(formXMLFieldName + "_" + requestedLanguage);
                if (fieldValue == null) continue;
                sortableField.put(formXMLFieldName, fieldValue);
            }
            indexEntry.setSortableXMLFormFields(sortableField);
        }
    }

    private void setIndexEntryCommonData(MatchingIndexEntry indexEntry, Document doc, ScoreDoc scoreDoc) {
        indexEntry.setCreationUser(doc.get("creationUser"));
        indexEntry.setCreationDate(this.parseDate(doc.get("creationDate")));
        indexEntry.setLastModificationUser(doc.get("updateUser"));
        indexEntry.setLastModificationDate(this.parseDate(doc.get("updateDate")));
        indexEntry.setThumbnail(doc.get("thumbnail"));
        indexEntry.setThumbnailMimeType(doc.get("thumbnailMimeType"));
        indexEntry.setThumbnailDirectory(doc.get("thumbnailDirectory"));
        indexEntry.setStartDate(this.parseDate(doc.get("startDate")));
        indexEntry.setEndDate(this.parseDate(doc.get("endDate")));
        indexEntry.setEmbeddedFileIds(doc.getValues("embeddedFileIds"));
        indexEntry.setAlias(StringUtil.getBooleanValue((String)doc.get("alias")));
        indexEntry.setScore(scoreDoc.score);
        String[] paths = doc.getValues("path");
        if (paths != null && paths.length > 0) {
            indexEntry.setPaths(Stream.of(paths).collect(Collectors.toList()));
        }
    }

    private void setIndexEntryLanguageData(MatchingIndexEntry indexEntry, Document doc) {
        Collection<String> languages = I18NHelper.getLanguages();
        for (String language : languages) {
            indexEntry.setTitle(doc.get(this.getFieldName("title", language)), language);
            indexEntry.setPreview(doc.get(this.getFieldName("preview", language)), language);
            indexEntry.setKeywords(doc.get(this.getFieldName("keywords", language)), language);
            String filename = doc.get(this.getFieldName("filename", language));
            if (!StringUtil.isDefined((String)filename)) continue;
            indexEntry.setFilename(filename);
        }
    }

    private List<MatchingIndexEntry> makeList(TopDocs topDocs, QueryDescription query, org.apache.lucene.search.IndexSearcher searcher) throws IOException {
        ArrayList<MatchingIndexEntry> results = new ArrayList<MatchingIndexEntry>();
        if (topDocs != null) {
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                String requestedLanguage = query.getRequestedLanguage().orElse("*");
                results.add(this.createMatchingIndexEntry(scoreDoc, requestedLanguage, searcher));
            }
        }
        return results;
    }

    private org.apache.lucene.search.IndexSearcher getSearcher(Set<String> componentIds) throws ParseException {
        Set<String> indexPathSet = this.getIndexPathSet(componentIds);
        ArrayList<IndexReader> readers = new ArrayList<IndexReader>();
        for (String path : indexPathSet) {
            IndexReader indexReader = IndexReadersCache.getIndexReader(path);
            if (indexReader == null) continue;
            readers.add(indexReader);
        }
        try {
            return new org.apache.lucene.search.IndexSearcher((IndexReader)new MultiReader(readers.toArray(new IndexReader[0])));
        }
        catch (IOException e) {
            throw new ParseException(INDEX_SEARCH_ERROR, e);
        }
    }

    private org.apache.lucene.search.IndexSearcher getSearcher(QueryDescription query) throws ParseException {
        Set<String> indexPathSet = this.getIndexPathSet(query.getWhereToSearch());
        ArrayList<IndexReader> readers = new ArrayList<IndexReader>();
        for (String string : indexPathSet) {
            IndexReader indexReader = IndexReadersCache.getIndexReader(string);
            if (indexReader == null) continue;
            readers.add(indexReader);
        }
        Set<ExternalComponent> extSearchers = query.getExtComponents();
        for (ExternalComponent externalComponent : extSearchers) {
            String externalComponentPath = this.getExternalComponentPath(externalComponent);
            IndexReader searcher = IndexReadersCache.getIndexReader(externalComponentPath);
            if (searcher == null) continue;
            readers.add(searcher);
        }
        try {
            return new org.apache.lucene.search.IndexSearcher((IndexReader)new MultiReader(readers.toArray(new IndexReader[0])));
        }
        catch (IOException iOException) {
            throw new ParseException(INDEX_SEARCH_ERROR, iOException);
        }
    }

    private String getExternalComponentPath(ExternalComponent extComp) {
        String externalComponentPathPart = IndexFileManager.extractComponentPath(extComp.getComponent());
        return extComp.getDataPath() + File.separator + "index" + File.separator + externalComponentPathPart + File.separator + "index";
    }

    Set<String> getIndexPathSet(Set<String> componentIds) {
        HashSet<String> pathSet = new HashSet<String>();
        for (String componentId : componentIds) {
            pathSet.add(this.indexManager.getIndexDirectoryPath(componentId));
        }
        return pathSet;
    }

    private TermRangeQuery getRangeQueryOnCreationDate(QueryDescription query) {
        LocalDate beginDate = query.getRequestedCreatedAfter();
        LocalDate endDate = query.getRequestedCreatedBefore();
        return this.getTermRangeQuery("creationDate", beginDate, endDate);
    }

    private TermRangeQuery getRangeQueryOnLastUpdateDate(QueryDescription query) {
        LocalDate beginDate = query.getRequestedUpdatedAfter();
        LocalDate endDate = query.getRequestedUpdatedBefore();
        return this.getTermRangeQuery("updateDate", beginDate, endDate);
    }

    private TermQuery getTermQueryOnAuthor(QueryDescription query) {
        if (!StringUtil.isDefined((String)query.getRequestedAuthor())) {
            return null;
        }
        Term authorTerm = new Term("creationUser", query.getRequestedAuthor());
        return new TermQuery(authorTerm);
    }

    private PrefixQuery getTermQueryOnFolder(QueryDescription query) {
        if (!StringUtil.isDefined((String)query.getRequestedFolder())) {
            return null;
        }
        Term term = new Term("path", query.getRequestedFolder());
        return new PrefixQuery(term);
    }

    private TermRangeQuery getTermRangeQuery(String fieldName, LocalDate beginDate, LocalDate endDate) {
        if (Objects.isNull(beginDate) && Objects.isNull(endDate)) {
            return null;
        }
        String start = "19000101";
        if (Objects.nonNull(beginDate)) {
            start = DateUtil.formatAsLuceneDate((LocalDate)beginDate);
        }
        String end = "24001231";
        if (Objects.nonNull(endDate)) {
            end = DateUtil.formatAsLuceneDate((LocalDate)endDate);
        }
        return TermRangeQuery.newStringRange((String)fieldName, (String)start, (String)end, (boolean)true, (boolean)true);
    }

    private String formatDate(LocalDate date) {
        return DateUtil.formatAsLuceneDate((LocalDate)date);
    }

    private LocalDate parseDate(String date) {
        try {
            return DateUtil.parseFromLucene((String)date);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
            return null;
        }
    }

    private TermInSetQuery getScopeQuery(QueryDescription query) {
        ArrayList<BytesRef> terms = new ArrayList<BytesRef>();
        for (String scope : query.getWhereToSearch()) {
            terms.add(new BytesRef((CharSequence)scope));
        }
        return new TermInSetQuery("scope", terms);
    }
}

