/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.datereminder.persistence.service;

import java.util.Collection;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.datereminder.exception.DateReminderException;
import org.silverpeas.core.datereminder.persistence.DateReminderDetail;
import org.silverpeas.core.datereminder.persistence.PersistentResourceDateReminder;
import org.silverpeas.core.datereminder.persistence.repository.PersistentResourceDateReminderRepository;
import org.silverpeas.core.datereminder.persistence.service.PersistentDateReminderService;
import org.silverpeas.core.persistence.EntityReference;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;

@Service
@Singleton
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultDateReminderService
implements PersistentDateReminderService {
    @Inject
    private PersistentResourceDateReminderRepository dateReminderRepository;

    @Override
    public PersistentResourceDateReminder get(EntityReference resource) {
        return this.bind(this.dateReminderRepository.getByTypeAndResourceId(resource.getType(), resource.getId()));
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public PersistentResourceDateReminder create(EntityReference resource, DateReminderDetail dateReminderDetail) throws DateReminderException {
        PersistentResourceDateReminder dateReminder = new PersistentResourceDateReminder();
        dateReminder.setResource(resource);
        dateReminder.setDateReminder(dateReminderDetail);
        dateReminder.validate();
        PersistentResourceDateReminder savedDateReminder = (PersistentResourceDateReminder)this.dateReminderRepository.save((IdentifiableEntity)dateReminder);
        return savedDateReminder;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public PersistentResourceDateReminder set(EntityReference resource, DateReminderDetail dateReminderDetail) throws DateReminderException {
        PersistentResourceDateReminder dateReminder = this.get(resource);
        dateReminder.setDateReminder(dateReminderDetail);
        dateReminder.validate();
        PersistentResourceDateReminder savedDateReminder = (PersistentResourceDateReminder)this.dateReminderRepository.save((IdentifiableEntity)dateReminder);
        return savedDateReminder;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void remove(EntityReference resource) {
        PersistentResourceDateReminder dateReminder = this.get(resource);
        if (dateReminder.exists()) {
            this.dateReminderRepository.delete((IdentifiableEntity[])new PersistentResourceDateReminder[]{dateReminder});
        }
    }

    private PersistentResourceDateReminder bind(PersistentResourceDateReminder dateReminder) {
        if (dateReminder == null) {
            return PersistentResourceDateReminder.NONEDATEREMINDER;
        }
        return dateReminder;
    }

    @Override
    public Collection<PersistentResourceDateReminder> listAllDateReminderMaturing(Date deadLine) {
        Collection<PersistentResourceDateReminder> listResourceDateReminder = this.dateReminderRepository.getByDeadLine(deadLine);
        return listResourceDateReminder;
    }
}

