/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.subscription;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.notification.PublicationEvent;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.contribution.publication.subscription.PublicationAliasSubscriptionResource;
import org.silverpeas.core.contribution.publication.subscription.PublicationSubscription;
import org.silverpeas.core.contribution.publication.subscription.PublicationSubscriptionResource;
import org.silverpeas.core.subscription.AbstractProfiledResourceSubscriptionListener;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResource;

@Bean
@Singleton
public class SubscriptionPublicationEventListener
extends AbstractProfiledResourceSubscriptionListener<PublicationDetail, PublicationEvent> {
    @Override
    public void onDeletion(PublicationEvent event) {
        PublicationDetail publication = (PublicationDetail)event.getTransition().getBefore();
        List toDelete = this.getSubscriptionService().getByResource(PublicationAliasSubscriptionResource.from(new PublicationPK(publication.getId()))).stream().map(Subscription::getResource).distinct().collect(Collectors.toList());
        this.getSubscriptionService().unsubscribeByResources(toDelete);
        super.onDeletion(event);
    }

    @Override
    public void onUpdate(PublicationEvent event) {
        PublicationDetail publication = (PublicationDetail)event.getTransition().getBefore();
        OrganizationController.get().getComponentInstance(publication.getInstanceId()).filter(SilverpeasComponentInstance::isTopicTracker).ifPresent(t -> {
            List subscriptionsToDelete = this.getSubscriptionService().getByResource(PublicationSubscriptionResource.from(new PublicationPK(publication.getId()))).stream().filter(Predicate.not(s -> s.getResource().getInstanceId().equals(publication.getInstanceId()))).collect(Collectors.toList());
            PublicationSubscriptionResource resource = PublicationSubscriptionResource.from(publication);
            List subscriptionsToCreate = subscriptionsToDelete.stream().map(s -> new PublicationSubscription(s.getSubscriber(), resource, s.getCreatorId())).collect(Collectors.toList());
            this.getSubscriptionService().unsubscribeByResources(subscriptionsToDelete.stream().map(Subscription::getResource).distinct().collect(Collectors.toList()));
            this.getSubscriptionService().subscribe(subscriptionsToCreate);
            Set potentials = PublicationService.get().getAllAliases(publication.getPK()).stream().map(ResourceReference::getComponentInstanceId).distinct().map(i -> PublicationAliasSubscriptionResource.from(new PublicationPK(publication.getId(), (String)i))).collect(Collectors.toSet());
            List toDelete = this.getSubscriptionService().getByResource(PublicationAliasSubscriptionResource.from(new PublicationPK(publication.getId()))).stream().map(Subscription::getResource).distinct().filter(Predicate.not(potentials::contains)).collect(Collectors.toList());
            this.getSubscriptionService().unsubscribeByResources(toDelete);
        });
        super.onUpdate(event);
    }

    @Override
    protected SubscriptionResource getSubscriptionResource(PublicationDetail resource) {
        return PublicationSubscriptionResource.from(resource);
    }

    @Override
    protected boolean isSubscriptionEnabled(PublicationDetail resource) {
        return true;
    }
}

