/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.record;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.contribution.content.form.record.ParameterValue;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement(name="parameter")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Parameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private String name = "";
    @XmlElement(name="value")
    private List<ParameterValue> values = new ArrayList<ParameterValue>();

    public Parameter() {
    }

    public Parameter(String name) {
        this.name = name;
    }

    public static List<String> decode(String parameterValue) {
        if (StringUtil.isNotDefined((String)parameterValue)) {
            return List.of();
        }
        String tokenDelimiter = "##";
        if (!parameterValue.contains("##")) {
            return List.of(parameterValue);
        }
        StringTokenizer tkn = new StringTokenizer(parameterValue, "##");
        ArrayList<String> values = new ArrayList<String>(tkn.countTokens());
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken();
            values.add(token);
        }
        return values;
    }

    public String getName() {
        return this.name;
    }

    public String getValue(String language) {
        if (this.values != null) {
            Iterator<ParameterValue> iterator = this.values.iterator();
            ParameterValue pValue = null;
            while (iterator.hasNext()) {
                pValue = iterator.next();
                if (!pValue.getLang().equalsIgnoreCase(language)) continue;
                return pValue.getValue();
            }
            if (pValue != null) {
                return pValue.getValue();
            }
        }
        return "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ParameterValue> getParameterValues() {
        return this.values;
    }

    public void setParameterValues(List<ParameterValue> parameterValues) {
        this.values = parameterValues;
    }
}

