/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.span;
import org.owasp.encoder.Encode;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.DateField;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.util.StringUtil;

public class DateFieldDisplayer
extends AbstractFieldDisplayer<DateField> {
    public String[] getManagedTypes() {
        return new String[]{"date"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) {
        String language = pagesContext.getLanguage();
        String label = Encode.forHtml((String)template.getLabel(language));
        DateFieldDisplayer.produceMandatoryCheck(out, template, pagesContext);
        out.println("\t\tif (! isWhitespace(stripInitialWhitespace(field.value))) {");
        out.println("\t\t\tif (! isCorrectDate(extractYear(field.value, '" + language + "'), extractMonth(field.value, '" + language + "'), extractDay(field.value, '" + language + "'))) {");
        out.println("\t\t\t\terrorMsg+=\"  - '" + label + "' " + Util.getString("GML.MustContainsCorrectDate", language) + "\\n\";");
        out.println("\t\t\t\terrorNb++;");
        out.println("\t\t}}");
        out.println("\t\tif (! isValidText(field, " + Util.getSetting("nbMaxCar") + ")) {");
        out.println("\t\t\terrorMsg+=\"  - '" + label + "' " + Util.getString("ContainsTooLargeText", language) + Util.getSetting("nbMaxCar") + " " + Util.getString("Characters", language) + "\\n\";");
        out.println("\t\t\terrorNb++;");
        out.println("\t\t}");
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, DateField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        String language = pagesContext.getLanguage();
        Map<String, String> parameters = template.getParameters(language);
        String fieldName = template.getFieldName();
        String cssClass = this.getCssClass(parameters);
        String value = Encode.forHtml((String)this.getValue(field, pagesContext, language, parameters));
        input inputField = new input();
        inputField.setID(fieldName);
        inputField.setName(fieldName);
        inputField.setValue(Encode.forHtml((String)value));
        inputField.setType(template.isHidden() ? "hidden" : "text");
        inputField.setMaxlength(parameters.getOrDefault("maxLength", "10"));
        inputField.setSize(parameters.getOrDefault("size", "13"));
        if (parameters.containsKey("border")) {
            inputField.setBorder(Integer.parseInt(parameters.get("border")));
        }
        if (template.isDisabled()) {
            inputField.setDisabled(true);
        } else if (template.isReadOnly()) {
            inputField.setReadOnly(true);
        }
        if (!(template.isHidden() || template.isDisabled() || template.isReadOnly())) {
            inputField.setClass("dateToPick");
            ElementContainer container = new ElementContainer();
            container.addElement((Element)inputField);
            span spanCSS = new span();
            if (StringUtil.isDefined((String)cssClass)) {
                spanCSS.setClass(cssClass);
            } else {
                spanCSS.setClass("txtnote");
            }
            spanCSS.addElement("(" + Util.getString("GML.dateFormatExemple", language) + ")");
            container.addElement((Element)spanCSS);
            if (template.isMandatory() && pagesContext.useMandatory()) {
                container.addElement("&nbsp;");
                img image = new img();
                image.setSrc(Util.getIcon("mandatoryField"));
                image.setWidth(5);
                image.setHeight(5);
                image.setBorder(0);
                image.setAlt("");
                container.addElement((Element)image);
            }
            out.println(container);
        } else {
            out.println(inputField);
        }
    }

    private String getValue(DateField field, PagesContext pagesContext, String language, Map<String, String> parameters) {
        String value;
        String defaultParam = parameters.getOrDefault("default", "");
        String defaultValue = "";
        if (!pagesContext.isIgnoreDefaultValues() && (pagesContext.isCreation() || pagesContext.isDesignMode())) {
            defaultValue = "now".equalsIgnoreCase(defaultParam) ? DateUtil.dateToString((Date)new Date(), (String)pagesContext.getLanguage()) : defaultParam;
        }
        String string = value = !field.isNull() ? field.getValue(language) : defaultValue;
        if (pagesContext.isBlankFieldsUse()) {
            value = "";
        }
        return value;
    }

    @Nullable
    private String getCssClass(Map<String, String> parameters) {
        Object cssClass = null;
        if (parameters.containsKey("class") && StringUtil.isDefined((String)(cssClass = parameters.get("class")))) {
            cssClass = "class=\"" + (String)cssClass + "\"";
        }
        return cssClass;
    }

    @Override
    public List<String> update(String newValue, DateField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!field.acceptValue(newValue, pagesContext.getLanguage())) {
            throw new FormException("Incorrect field value type. Expected {0}", "date");
        }
        field.setValue(newValue, pagesContext.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

