/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.repository;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.persistence.jcr.AbstractJcrConverter;

class SimpleAttachmentConverter
extends AbstractJcrConverter {
    SimpleAttachmentConverter() {
    }

    public SimpleAttachment convertNode(Node node) throws RepositoryException {
        SimpleAttachment attachment = SimpleAttachment.builder().build();
        attachment.setContentType(this.getStringProperty(node, "{http://www.jcp.org/jcr/1.0}mimeType"));
        attachment.setCreationDate(this.getDateProperty(node, "slv:creationDate"));
        attachment.setCreatedBy(this.getStringProperty(node, "slv:creator"));
        attachment.setDescription(this.getStringProperty(node, "{http://www.jcp.org/jcr/1.0}description"));
        attachment.setFilename(this.getStringProperty(node, "slv:name"));
        attachment.setLanguage(this.getStringProperty(node, "{http://www.jcp.org/jcr/1.0}language"));
        attachment.setSize(this.getLongProperty(node, "slv:size"));
        attachment.setTitle(this.getStringProperty(node, "{http://www.jcp.org/jcr/1.0}title"));
        attachment.setLastUpdateDate(this.getDateProperty(node, "{http://www.jcp.org/jcr/1.0}lastModified"));
        attachment.setUpdatedBy(this.getStringProperty(node, "{http://www.jcp.org/jcr/1.0}lastModifiedBy"));
        attachment.setXmlFormId(this.getStringProperty(node, "slv:xmlFormId"));
        return attachment;
    }

    public void fillNode(SimpleAttachment attachment, Node node) throws RepositoryException {
        this.addDateProperty(node, "slv:creationDate", attachment.getCreationDate());
        this.addStringProperty(node, "slv:creator", attachment.getCreatedBy());
        this.addStringProperty(node, "{http://www.jcp.org/jcr/1.0}description", attachment.getDescription());
        this.addStringProperty(node, "slv:name", attachment.getFilename());
        this.addStringProperty(node, "{http://www.jcp.org/jcr/1.0}language", attachment.getLanguage());
        this.addStringProperty(node, "{http://www.jcp.org/jcr/1.0}title", attachment.getTitle());
        this.addDateProperty(node, "{http://www.jcp.org/jcr/1.0}lastModified", attachment.getLastUpdateDate());
        this.addStringProperty(node, "{http://www.jcp.org/jcr/1.0}lastModifiedBy", attachment.getUpdatedBy());
        this.addStringProperty(node, "slv:xmlFormId", attachment.getXmlFormId());
        this.addStringProperty(node, "{http://www.jcp.org/jcr/1.0}mimeType", attachment.getContentType());
        node.setProperty("slv:size", attachment.getSize());
    }
}

