/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.ProfiledObjectIds;
import org.silverpeas.core.admin.ProfiledObjectType;
import org.silverpeas.core.admin.component.model.CompoSpace;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.PasteDetail;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.RightAssignationContext;
import org.silverpeas.core.admin.service.SpaceProfile;
import org.silverpeas.core.admin.service.SpaceWithSubSpacesAndComponents;
import org.silverpeas.core.admin.service.UserSpaceAvailabilityChecker;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.GroupProfileInst;
import org.silverpeas.core.admin.user.model.GroupsSearchCriteria;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.util.Pair;

public interface Administration {
    public static Administration get() {
        return (Administration)ServiceProvider.getService(Administration.class, (Annotation[])new Annotation[0]);
    }

    public void reloadCache();

    public void initSynchronization();

    public void createSpaceIndex(int var1);

    public void createSpaceIndex(SpaceInstLight var1);

    public void deleteSpaceIndex(SpaceInst var1);

    public void deleteAllSpaceIndexes();

    public String addSpaceInst(String var1, SpaceInst var2) throws AdminException;

    public String deleteSpaceInstById(String var1, String var2, boolean var3) throws AdminException;

    public void restoreSpaceFromBasket(String var1) throws AdminException;

    public SpaceInst getSpaceInstById(String var1) throws AdminException;

    public SpaceInst getPersonalSpace(String var1) throws AdminException;

    public String[] getAllSubSpaceIds(String var1) throws AdminException;

    public String updateSpaceInst(SpaceInst var1) throws AdminException;

    public void updateSpaceOrderNum(String var1, int var2) throws AdminException;

    public String[] getAllRootSpaceIds() throws AdminException;

    public List<SpaceInstLight> getPathToComponent(String var1) throws AdminException;

    public List<SpaceInstLight> getPathToSpace(String var1, boolean var2) throws AdminException;

    public String[] getAllSpaceIds() throws AdminException;

    public List<SpaceInstLight> getRemovedSpaces() throws AdminException;

    public List<ComponentInstLight> getRemovedComponents() throws AdminException;

    public String[] getSpaceNames(String[] var1) throws AdminException;

    public Map<String, WAComponent> getAllWAComponents();

    public SilverpeasComponentInstance getComponentInstance(String var1) throws AdminException;

    public ComponentInst getComponentInst(String var1) throws AdminException;

    public ComponentInstLight getComponentInstLight(String var1) throws AdminException;

    public String getComponentParameterValue(String var1, String var2);

    public Map<String, Map<String, String>> getParameterValuesByComponentIdThenByParamName(Collection<String> var1, Collection<String> var2);

    public List<ComponentInstLight> getComponentsWithParameter(String var1, String var2);

    public void restoreComponentFromBasket(String var1) throws AdminException;

    public void createComponentIndex(String var1);

    public void createComponentIndex(SilverpeasComponentInstance var1);

    public void deleteAllComponentIndexes();

    public String addComponentInst(String var1, ComponentInst var2) throws AdminException, QuotaException;

    public String deleteComponentInst(String var1, String var2, boolean var3) throws AdminException;

    public String updateComponentInst(ComponentInst var1) throws AdminException;

    public void setSpaceProfilesToSubSpace(SpaceInst var1, SpaceInst var2) throws AdminException;

    public void setSpaceProfilesToSubSpace(SpaceInst var1, SpaceInst var2, boolean var3) throws AdminException;

    public void setSpaceProfilesToComponent(ComponentInst var1, SpaceInst var2) throws AdminException;

    public void moveSpace(String var1, String var2) throws AdminException;

    public void moveComponentInst(String var1, String var2, String var3, ComponentInst[] var4) throws AdminException;

    public void setComponentPlace(String var1, String var2, ComponentInst[] var3) throws AdminException;

    public String getRequestRouter(String var1);

    public String[] getAllProfilesNames(String var1);

    public String getProfileLabelFromName(String var1, String var2, String var3);

    @NonNull
    public ProfileInst getProfileInst(String var1) throws AdminException;

    public List<ProfileInst> getAllProfiles(String var1, String var2);

    public List<ProfileInst> getProfilesByObject(ProfiledObjectId var1, String var2) throws AdminException;

    public String[] getProfilesByObjectAndGroupId(ProfiledObjectId var1, String var2, String var3) throws AdminException;

    public String[] getProfilesByObjectAndUserId(ProfiledObjectId var1, String var2, String var3) throws AdminException;

    public Map<Pair<String, String>, Set<String>> getUserProfilesByComponentIdAndObjectId(ProfiledObjectIds var1, Collection<String> var2, String var3) throws AdminException;

    public Map<String, List<String>> getProfilesByObjectTypeAndUserId(ProfiledObjectType var1, String var2, String var3) throws AdminException;

    public boolean isObjectAvailableToUser(String var1, ProfiledObjectId var2, String var3) throws AdminException;

    public boolean isObjectAvailableToGroup(String var1, ProfiledObjectId var2, String var3) throws AdminException;

    public String addProfileInst(ProfileInst var1) throws AdminException;

    public String addProfileInst(ProfileInst var1, String var2) throws AdminException;

    public String deleteProfileInst(String var1, String var2) throws AdminException;

    public String updateProfileInst(ProfileInst var1) throws AdminException;

    public String updateProfileInst(ProfileInst var1, String var2) throws AdminException;

    public SpaceProfileInst getSpaceProfileInst(String var1) throws AdminException;

    public String addSpaceProfileInst(SpaceProfileInst var1, String var2) throws AdminException;

    public void deleteSpaceProfileInst(String var1, String var2) throws AdminException;

    public String updateSpaceProfileInst(SpaceProfileInst var1, String var2) throws AdminException;

    public String getGroupName(String var1) throws AdminException;

    public List<GroupDetail> getAllGroups() throws AdminException;

    public boolean isGroupExist(String var1) throws AdminException;

    public GroupDetail getGroup(String var1) throws AdminException;

    public List<String> getPathToGroup(String var1) throws AdminException;

    public GroupDetail getGroupByNameInDomain(String var1, String var2) throws AdminException;

    public GroupDetail[] getGroups(String[] var1) throws AdminException;

    public String addGroup(GroupDetail var1) throws AdminException;

    public String addGroup(GroupDetail var1, boolean var2) throws AdminException;

    public List<GroupDetail> restoreGroup(String var1) throws AdminException;

    public List<GroupDetail> removeGroup(String var1) throws AdminException;

    public List<GroupDetail> deleteGroupById(String var1) throws AdminException;

    public List<GroupDetail> deleteGroupById(String var1, boolean var2) throws AdminException;

    public String copyGroup(GroupDetail var1, String var2) throws AdminException;

    public void moveGroup(GroupDetail var1, String var2) throws AdminException;

    public String updateGroup(GroupDetail var1) throws AdminException;

    public String updateGroup(GroupDetail var1, boolean var2) throws AdminException;

    public void removeUserFromGroup(String var1, String var2) throws AdminException;

    public void addUserInGroup(String var1, String var2) throws AdminException;

    public List<GroupDetail> getAllRootGroups() throws AdminException;

    public GroupProfileInst getGroupProfileInst(String var1) throws AdminException;

    public void addGroupProfileInst(GroupProfileInst var1) throws AdminException;

    public void deleteGroupProfileInst(String var1) throws AdminException;

    public void updateGroupProfileInst(GroupProfileInst var1) throws AdminException;

    public void indexAllGroups() throws AdminException;

    public void indexGroups(String var1) throws AdminException;

    public String[] getAllUsersIds() throws AdminException;

    public UserDetail getUserDetail(String var1) throws AdminException;

    public UserDetail[] getUserDetails(String[] var1);

    public List<UserDetail> getAllUsers() throws AdminException;

    public List<UserDetail> getAllUsersFromNewestToOldest() throws AdminException;

    public boolean isEmailExisting(String var1) throws AdminException;

    public String getUserIdByLoginAndDomain(String var1, String var2) throws AdminException;

    public String getUserIdByAuthenticationKey(String var1) throws AdminException;

    public UserFull getUserFull(String var1) throws AdminException;

    public List<UserFull> getUserFulls(Collection<String> var1) throws AdminException;

    public UserFull getUserFull(String var1, String var2) throws AdminException;

    public String addUser(UserDetail var1) throws AdminException;

    public String addUser(UserDetail var1, boolean var2) throws AdminException;

    public void migrateUser(UserDetail var1, String var2) throws AdminException;

    public void blockUser(String var1) throws AdminException;

    public void unblockUser(String var1) throws AdminException;

    public void deactivateUser(String var1) throws AdminException;

    public void activateUser(String var1) throws AdminException;

    public void setUserSensitiveData(String var1, boolean var2) throws AdminException;

    public void userAcceptsTermsOfService(String var1) throws AdminException;

    public String restoreUser(String var1) throws AdminException;

    public String removeUser(String var1) throws AdminException;

    public String deleteUser(String var1) throws AdminException;

    public String deleteUser(String var1, boolean var2) throws AdminException;

    public String updateUser(UserDetail var1) throws AdminException;

    public String updateUserFull(UserFull var1) throws AdminException;

    public String getClientSpaceId(String var1);

    public String[] getClientSpaceIds(String[] var1);

    public String getNextDomainId() throws AdminException;

    public String addDomain(Domain var1) throws AdminException;

    public String updateDomain(Domain var1) throws AdminException;

    public String removeDomain(String var1) throws AdminException;

    public Domain[] getAllDomains() throws AdminException;

    public Domain getDomain(String var1) throws AdminException;

    public long getDomainActions(String var1) throws AdminException;

    public GroupDetail[] getRootGroupsOfDomain(String var1) throws AdminException;

    public List<GroupDetail> getSynchronizedGroups() throws AdminException;

    public UserDetail[] getAllUsersOfGroup(String var1) throws AdminException;

    public UserDetail[] getUsersOfDomain(String var1) throws AdminException;

    public List<UserDetail> getUsersOfDomains(List<String> var1) throws AdminException;

    public List<UserDetail> getUsersOfDomainsFromNewestToOldest(List<String> var1) throws AdminException;

    public String[] getUserIdsOfDomain(String var1) throws AdminException;

    public String identify(String var1, String var2, boolean var3) throws AdminException;

    public String identify(String var1, String var2, boolean var3, boolean var4) throws AdminException;

    public List<GroupDetail> getDirectGroupsOfUser(String var1) throws AdminException;

    public String[] getUserSpaceIds(String var1) throws AdminException;

    public String[] getUserRootSpaceIds(String var1) throws AdminException;

    public String[] getUserSubSpaceIds(String var1, String var2) throws AdminException;

    public boolean isSpaceAvailable(String var1, String var2) throws AdminException;

    public UserSpaceAvailabilityChecker getUserSpaceAvailabilityChecker(String var1) throws AdminException;

    public List<SpaceInstLight> getSubSpaces(String var1) throws AdminException;

    public List<ComponentInstLight> getAvailCompoInSpace(String var1, String var2) throws AdminException;

    public List<SpaceInstLight> getUserSpaceTreeview(String var1) throws AdminException;

    public String[] getAllowedSubSpaceIds(String var1, String var2) throws AdminException;

    public SpaceInstLight getSpaceInstLightById(String var1) throws AdminException;

    public SpaceInstLight getRootSpace(String var1) throws AdminException;

    public String[] getGroupManageableSpaceIds(String var1) throws AdminException;

    public String[] getUserManageableSpaceIds(String var1) throws AdminException;

    public String[] getUserManageableSubSpaceIds(String var1, String var2) throws AdminException;

    public SpaceProfile getSpaceProfile(String var1, SilverpeasRole var2) throws AdminException;

    public List<String> getUserManageableGroupIds(String var1) throws AdminException;

    public String[] getAvailCompoIds(String var1, String var2) throws AdminException;

    public boolean isAnAdminTool(String var1);

    public List<String> getAvailableComponentsByUser(String var1) throws AdminException;

    public boolean isComponentAvailableToUser(String var1, String var2) throws AdminException;

    public boolean isComponentAvailableToGroup(String var1, String var2) throws AdminException;

    public boolean isComponentManageable(String var1, String var2) throws AdminException;

    public String[] getAvailCompoIdsAtRoot(String var1, String var2) throws AdminException;

    public List<String> getAvailCompoIdsAtRoot(String var1, String var2, String var3) throws AdminException;

    public String[] getAvailCompoIds(String var1) throws AdminException;

    public String[] getComponentIdsByNameAndUserId(String var1, String var2) throws AdminException;

    public List<ComponentInstLight> getAvailComponentInstLights(String var1, String var2) throws AdminException;

    public List<SpaceInstLight> getRootSpacesContainingComponent(String var1, String var2) throws AdminException;

    public List<SpaceInstLight> getSubSpacesContainingComponent(String var1, String var2, String var3) throws AdminException;

    public CompoSpace[] getCompoForUser(String var1, String var2) throws AdminException;

    public String[] getCompoId(String var1) throws AdminException;

    public String[] getProfileIds(String var1) throws AdminException;

    public String[] getProfileIdsOfGroup(String var1) throws AdminException;

    public String[] getCurrentProfiles(String var1, ComponentInst var2);

    public String[] getCurrentProfiles(String var1, String var2) throws AdminException;

    public Map<String, Set<String>> getUserProfilesByComponentId(String var1, Collection<String> var2) throws AdminException;

    public List<String> getSpaceUserProfilesBySpaceId(String var1, String var2) throws AdminException;

    public Map<String, Set<String>> getSpaceUserProfilesBySpaceIds(String var1, Collection<String> var2) throws AdminException;

    public UserDetail[] getUsers(boolean var1, String var2, String var3) throws AdminException;

    public GroupDetail[] getAllSubGroups(String var1) throws AdminException;

    public GroupDetail[] getRecursivelyAllSubGroups(String var1) throws AdminException;

    public UserDetail[] getFilteredDirectUsers(String var1, String var2) throws AdminException;

    public int getAllSubUsersNumber(String var1) throws AdminException;

    public String[] getAdministratorUserIds(String var1) throws AdminException;

    public String getSilverpeasEmail();

    public String getSilverpeasName();

    public String[] getAllSpaceIds(String var1) throws AdminException;

    public String[] getAllRootSpaceIds(String var1) throws AdminException;

    public String[] getAllSubSpaceIds(String var1, String var2) throws AdminException;

    public String[] getAllComponentIds(String var1) throws AdminException;

    public String[] getAllComponentIdsRecur(String var1) throws AdminException;

    public void synchronizeGroupByRule(String var1, boolean var2) throws AdminException;

    public String synchronizeGroup(String var1, boolean var2) throws AdminException;

    public String synchronizeImportGroup(String var1, String var2, String var3, boolean var4, boolean var5) throws AdminException;

    public String synchronizeRemoveGroup(String var1) throws AdminException;

    public String synchronizeUser(String var1, boolean var2, boolean var3) throws AdminException;

    public String synchronizeImportUserByLogin(String var1, String var2, boolean var3) throws AdminException;

    public String synchronizeImportUser(String var1, String var2, boolean var3) throws AdminException;

    public List<DomainProperty> getSpecificPropertiesToImportUsers(String var1, String var2) throws AdminException;

    public UserDetail[] searchUsers(String var1, Map<String, String> var2) throws AdminException;

    public String synchronizeRemoveUser(String var1) throws AdminException;

    public String synchronizeSilverpeasWithDomain(String var1) throws AdminException;

    public String synchronizeSilverpeasWithDomain(String var1, boolean var2) throws AdminException;

    public List<String> searchUserIdsByProfile(List<String> var1, boolean var2) throws AdminException;

    public SilverpeasList<UserDetail> searchUsers(UserDetailsSearchCriteria var1) throws AdminException;

    public SilverpeasList<GroupDetail> searchGroups(GroupsSearchCriteria var1) throws AdminException;

    public void indexAllUsers() throws AdminException;

    public void indexUsers(String var1) throws AdminException;

    public String copyAndPasteComponent(PasteDetail var1) throws AdminException, QuotaException;

    public String copyAndPasteSpace(PasteDetail var1) throws AdminException, QuotaException;

    public void assignRightsFromUserToUser(RightAssignationContext.MODE var1, String var2, String var3, boolean var4, String var5) throws AdminException;

    public void assignRightsFromUserToGroup(RightAssignationContext.MODE var1, String var2, String var3, boolean var4, String var5) throws AdminException;

    public void assignRightsFromGroupToUser(RightAssignationContext.MODE var1, String var2, String var3, boolean var4, String var5) throws AdminException;

    public void assignRightsFromGroupToGroup(RightAssignationContext.MODE var1, String var2, String var3, boolean var4, String var5) throws AdminException;

    public boolean isDomainManagerUser(String var1, String var2);

    public SpaceWithSubSpacesAndComponents getFullTreeview() throws AdminException;

    public SpaceWithSubSpacesAndComponents getAllowedFullTreeview(String var1) throws AdminException;

    public SpaceWithSubSpacesAndComponents getAllowedFullTreeviewOnComponentName(String var1, String var2) throws AdminException;

    public SpaceWithSubSpacesAndComponents getAllowedFullTreeview(String var1, String var2) throws AdminException;

    public List<GroupDetail> getRemovedGroups(String ... var1) throws AdminException;

    public List<UserDetail> getRemovedUsers(String ... var1) throws AdminException;

    public List<UserDetail> getNonBlankedDeletedUsers(String ... var1) throws AdminException;

    public List<UserDetail> getUsersWithSensitiveData(String ... var1) throws AdminException;

    public void blankDeletedUsers(String var1, List<String> var2) throws AdminException;

    public void disableDataSensitivity(String var1, List<String> var2) throws AdminException;

    public static class Constants {
        public static final String ADMIN_COMPONENT_ID = "ADMIN";
        public static final String BASKET_SUFFIX = " (Restaur\u00e9)";

        private Constants() {
        }
    }
}

