/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;

public class Revisions {
    private final String path;
    private final File out;

    public static Builder builder() {
        return new Builder();
    }

    private Revisions(Builder builder) {
        this.path = builder.path;
        this.out = builder.out;
    }

    public int run(RevisionsProcessor p) {
        try {
            this.listRevisions(p);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return 1;
        }
    }

    private void listRevisions(RevisionsProcessor p) throws IOException {
        System.out.println("Store " + this.path);
        System.out.println("Writing revisions to " + this.out);
        List<String> revs = p.process(this.path);
        if (revs.isEmpty()) {
            System.out.println("No revisions found.");
            return;
        }
        try (PrintWriter pw = new PrintWriter(this.out);){
            for (String r : revs) {
                pw.println(r);
            }
        }
    }

    @FunctionalInterface
    public static interface RevisionsProcessor {
        public List<String> process(String var1);
    }

    public static class Builder {
        private String path;
        private File out;

        private Builder() {
        }

        public Builder withPath(String path) {
            this.path = Objects.requireNonNull(path);
            return this;
        }

        public Builder withOutput(File out) {
            this.out = Objects.requireNonNull(out);
            return this;
        }

        public Revisions build() {
            Objects.requireNonNull(this.path);
            Objects.requireNonNull(this.out);
            return new Revisions(this);
        }
    }
}

