/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.IOException;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.SegmentWriterFactory;
import org.apache.jackrabbit.oak.segment.file.CompactedNodeState;
import org.apache.jackrabbit.oak.segment.file.GCIncrement;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompactionWriter {
    @NotNull
    private final SegmentReader reader;
    @Nullable
    private final BlobStore blobStore;
    @NotNull
    private final GCIncrement gcIncrement;
    @NotNull
    private final SegmentWriter partialWriter;
    @NotNull
    private final SegmentWriter targetWriter;

    public CompactionWriter(@NotNull SegmentReader reader, @Nullable BlobStore blobStore, @NotNull GCGeneration generation, @NotNull SegmentWriter segmentWriter) {
        this.reader = reader;
        this.blobStore = blobStore;
        this.gcIncrement = new GCIncrement(generation, generation, generation);
        this.partialWriter = segmentWriter;
        this.targetWriter = segmentWriter;
    }

    public CompactionWriter(@NotNull SegmentReader reader, @Nullable BlobStore blobStore, @NotNull GCIncrement gcIncrement, @NotNull SegmentWriterFactory segmentWriterFactory) {
        this.reader = reader;
        this.blobStore = blobStore;
        this.gcIncrement = gcIncrement;
        this.partialWriter = gcIncrement.createPartialWriter(segmentWriterFactory);
        this.targetWriter = gcIncrement.createTargetWriter(segmentWriterFactory);
    }

    @NotNull
    public CompactedNodeState.FullyCompactedNodeState writeFullyCompactedNode(@NotNull NodeState nodeState, @Nullable Buffer stableId) throws IOException {
        RecordId nodeId = this.targetWriter.writeNode(nodeState, stableId);
        return new CompactedNodeState.FullyCompactedNodeState(this.reader, this.targetWriter, this.blobStore, nodeId);
    }

    @Nullable
    public CompactedNodeState.PartiallyCompactedNodeState writePartiallyCompactedNode(@NotNull NodeState nodeState, @Nullable Buffer stableId) throws IOException {
        RecordId nodeId = this.partialWriter.writeNode(nodeState, stableId);
        return new CompactedNodeState.PartiallyCompactedNodeState(this.reader, this.partialWriter, this.blobStore, nodeId);
    }

    public void flush() throws IOException {
        this.partialWriter.flush();
        this.targetWriter.flush();
    }

    @Nullable
    public CompactedNodeState.FullyCompactedNodeState getPreviouslyCompactedState(NodeState nodeState) {
        if (!(nodeState instanceof SegmentNodeState)) {
            return null;
        }
        SegmentNodeState segmentNodeState = (SegmentNodeState)nodeState;
        if (!this.gcIncrement.isFullyCompacted(segmentNodeState.getGcGeneration())) {
            return null;
        }
        RecordId nodeId = segmentNodeState.getRecordId();
        return new CompactedNodeState.FullyCompactedNodeState(this.reader, this.targetWriter, this.blobStore, nodeId);
    }
}

