/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.util.SilverpeasList;

public class ListSlice<T>
extends ArrayList<T>
implements SilverpeasList<T> {
    private static final long serialVersionUID = 679667310008767706L;
    private int start;
    private int end;
    private long maxsize = -1L;

    public static <T> ListSlice<T> emptyList() {
        return new ListSlice(Collections.emptyList());
    }

    public ListSlice(int sliceBeginIndex, int sliceEndIndex) {
        super(sliceEndIndex - sliceBeginIndex + 1);
        this.start = sliceBeginIndex;
        this.end = sliceEndIndex;
    }

    public ListSlice(int sliceBeginIndex, int sliceEndIndex, long originalListSize) {
        this(sliceBeginIndex, sliceEndIndex);
        if (originalListSize < 0L) {
            throw new AssertionError();
        }
        this.maxsize = originalListSize;
    }

    public ListSlice(int sliceBeginIndex, int sliceEndIndex, List<? extends T> originalList) {
        super(originalList.subList(sliceBeginIndex, sliceEndIndex));
        this.start = sliceBeginIndex;
        this.end = sliceEndIndex;
        this.maxsize = originalList.size();
    }

    public ListSlice(Collection<? extends T> collection) {
        super(collection);
        this.start = 0;
        this.end = collection.isEmpty() ? 0 : collection.size() - 1;
        this.maxsize = collection.size();
    }

    @Override
    public <U> SilverpeasList<U> newEmptyListWithSameProperties() {
        ListSlice<T> newEmptyList = new ListSlice<T>(this.start, this.end);
        newEmptyList.setOriginalListSize(this.maxsize);
        return newEmptyList;
    }

    public int getFirstIndex() {
        return this.start;
    }

    public int getLastIndex() {
        if (this.end > this.start && this.end < this.size()) {
            return this.end;
        }
        return this.isEmpty() ? 0 : this.size() - 1;
    }

    @Override
    public long originalListSize() {
        return this.maxsize;
    }

    public void setOriginalListSize(long size) {
        this.maxsize = size;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSlice)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListSlice listSlice = (ListSlice)o;
        if (this.start != listSlice.start) {
            return false;
        }
        if (this.end != listSlice.end) {
            return false;
        }
        if (this.maxsize != listSlice.maxsize) {
            return false;
        }
        return super.equals(listSlice);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.start).append(this.end).append(this.maxsize).append(super.hashCode()).toHashCode();
    }
}

