/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.scheduler;

import java.text.ParseException;
import javax.inject.Inject;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.annotation.Nullable;
import org.silverpeas.kernel.util.StringUtil;

public abstract class SchedulingInitializer
implements Initialization {
    @Inject
    private Scheduler scheduler;

    @Override
    public final void init() throws SchedulerException {
        this.preSchedule();
        if (this.isSchedulingEnabled()) {
            Job job = this.getJob();
            this.scheduler.unscheduleJob(job.getName());
            if (this.getTrigger() != null) {
                this.scheduler.scheduleJob(job, this.getTrigger());
            }
        }
    }

    @Override
    public final void release() throws SchedulerException {
        if (this.isSchedulingEnabled()) {
            Job job = this.getJob();
            this.scheduler.unscheduleJob(job.getName());
        }
        this.postUnschedule();
    }

    protected void preSchedule() {
    }

    protected void postUnschedule() {
    }

    @Nullable
    protected JobTrigger getTrigger() throws SchedulerException {
        try {
            String cron = this.getCron();
            if (StringUtil.isDefined((String)cron)) {
                return JobTrigger.triggerAt(this.getCron());
            }
            return null;
        }
        catch (ParseException e) {
            throw new SchedulerException(e.getMessage(), e);
        }
    }

    @NonNull
    protected abstract String getCron();

    @NonNull
    protected abstract Job getJob();

    protected abstract boolean isSchedulingEnabled();
}

