/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.model.jpa;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.silverpeas.core.persistence.datasource.SQLDateTimeConstants;

@Converter(autoApply=true)
public class InstantAttributeConverter
implements AttributeConverter<Instant, Timestamp> {
    public Timestamp convertToDatabaseColumn(Instant instant) {
        if (instant == null) {
            return null;
        }
        if (instant.equals(Instant.MIN)) {
            return SQLDateTimeConstants.MIN_TIMESTAMP;
        }
        if (instant.equals(Instant.MAX)) {
            return SQLDateTimeConstants.MAX_TIMESTAMP;
        }
        return Timestamp.valueOf(OffsetDateTime.ofInstant(instant, ZoneOffset.UTC).toLocalDateTime());
    }

    public Instant convertToEntityAttribute(Timestamp sqlTimestamp) {
        if (sqlTimestamp == null) {
            return null;
        }
        if (sqlTimestamp.equals(SQLDateTimeConstants.MIN_TIMESTAMP)) {
            return Instant.MIN;
        }
        if (sqlTimestamp.equals(SQLDateTimeConstants.MAX_TIMESTAMP)) {
            return Instant.MAX;
        }
        return sqlTimestamp.toLocalDateTime().atOffset(ZoneOffset.UTC).toInstant();
    }
}

