/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.client.constant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.silverpeas.core.notification.user.client.constant.BuiltInNotifAddress;
import org.silverpeas.kernel.util.StringUtil;

public enum NotifChannel {
    SMTP(1, "BASIC_SMTP_MAIL", BuiltInNotifAddress.BASIC_SMTP),
    SMS(2, "BASIC_SMS", BuiltInNotifAddress.BASIC_SERVER),
    POPUP(3, "BASIC_POPUP", BuiltInNotifAddress.BASIC_POPUP),
    SILVERMAIL(4, "BASIC_SILVERMAIL", BuiltInNotifAddress.BASIC_SILVERMAIL),
    REMOVE(5, "BASIC_REMOVE", BuiltInNotifAddress.BASIC_REMOVE),
    SERVER(6, "BASIC_SERVER", BuiltInNotifAddress.BASIC_SERVER);

    private final int id;
    private final String name;
    private final BuiltInNotifAddress type;

    private NotifChannel(int id, String name, BuiltInNotifAddress mediaType) {
        this.id = id;
        this.name = name;
        this.type = mediaType;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public BuiltInNotifAddress getMediaType() {
        return this.type;
    }

    public static Optional<NotifChannel> decode(Integer id) {
        Optional<NotifChannel> channel = id != null ? Arrays.stream(NotifChannel.values()).filter(n -> n.id == id).findFirst() : Optional.empty();
        return channel;
    }

    public static Optional<NotifChannel> decode(String name) {
        Optional<NotifChannel> channel = StringUtil.isDefined((String)name) ? Arrays.stream(NotifChannel.values()).filter(n -> n.name.equals(name)).findFirst() : Optional.empty();
        return channel;
    }

    public static Collection<Integer> toIds(Collection<NotifChannel> notifChannels) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (notifChannels != null) {
            for (NotifChannel notifChannel : notifChannels) {
                result.add(notifChannel.getId());
            }
        }
        return result;
    }
}

