/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.model;

import java.lang.annotation.Annotation;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionContent;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.contribution.service.WysiwygContentRepository;
import org.silverpeas.core.util.ServiceProvider;

public class WysiwygContent
implements ContributionContent<String> {
    private static final long serialVersionUID = 356629338911833531L;
    private final LocalizedContribution contribution;
    private String text;
    private User author;
    private boolean modified;

    public WysiwygContent(LocalizedContribution contribution, String richText) {
        this.contribution = contribution;
        this.text = richText == null ? "" : richText;
    }

    public WysiwygContent(LocalizedContribution contribution) {
        this(contribution, "");
    }

    public WysiwygContent(WysiwygContent content) {
        this.contribution = content.contribution;
        this.text = content.text;
        this.author = content.author;
        this.modified = content.modified;
    }

    public static WysiwygContent getContent(LocalizedContribution contribution) {
        WysiwygContentRepository repository = ServiceProvider.getService(WysiwygContentRepository.class, new Annotation[0]);
        return repository.getByContribution(contribution);
    }

    public static void deleteAllContents(Contribution contribution) {
        WysiwygContentRepository repository = ServiceProvider.getService(WysiwygContentRepository.class, new Annotation[0]);
        repository.deleteByContribution(contribution);
    }

    public WysiwygContent authoredBy(User author) {
        this.author = author;
        return this;
    }

    @Override
    public LocalizedContribution getContribution() {
        return this.contribution;
    }

    @Override
    public String getData() {
        return this.text;
    }

    public void setData(String richTest) {
        String newText;
        String string = newText = richTest == null ? "" : richTest;
        if (!newText.contentEquals(this.text)) {
            this.text = newText;
            this.modified = true;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    public boolean isModified() {
        return this.modified;
    }

    public User getAuthor() {
        return this.author == null ? User.getCurrentRequester() : this.author;
    }

    public void save() {
        WysiwygContentRepository repository = ServiceProvider.getService(WysiwygContentRepository.class, new Annotation[0]);
        repository.save(this);
    }

    public void delete() {
        WysiwygContentRepository repository = ServiceProvider.getService(WysiwygContentRepository.class, new Annotation[0]);
        repository.delete(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WysiwygContent)) {
            return false;
        }
        WysiwygContent content = (WysiwygContent)o;
        if (!this.contribution.getIdentifier().equals(content.contribution.getIdentifier())) {
            return false;
        }
        return this.text != null ? this.text.equals(content.text) : content.text == null;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.contribution.getIdentifier()).append((Object)this.text).toHashCode();
    }
}

