/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.classification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.silverpeas.core.pdc.classification.ClassifyEngineException;
import org.silverpeas.core.pdc.classification.Value;

@XmlAccessorType(value=XmlAccessType.NONE)
public class Position<T extends Value>
implements Serializable {
    private static final long serialVersionUID = -6444526234909683822L;
    private int nPositionId = -1;
    private List<T> alValues = null;

    public Position() {
    }

    public Position(int nGivenPositionId, List<T> alGivenValues) {
        this.nPositionId = nGivenPositionId;
        this.alValues = alGivenValues;
    }

    public Position(List<T> alGivenValues) {
        this.alValues = alGivenValues;
    }

    public void setPositionId(int nGivenPositionId) {
        this.nPositionId = nGivenPositionId;
    }

    public int getPositionId() {
        return this.nPositionId;
    }

    public void setValues(List<T> alGivenValues) {
        this.alValues = alGivenValues;
    }

    public List<T> getValues() {
        return this.alValues;
    }

    public void addValue(T value) {
        if (this.alValues == null) {
            this.alValues = new ArrayList<T>();
        }
        this.alValues.add(value);
    }

    public Value getValueByAxis(int nUsedAxisId) {
        List<T> values = this.getValues();
        for (Value value : values) {
            if (nUsedAxisId != value.getAxisId()) continue;
            return value;
        }
        return new Value();
    }

    public void checkPosition() throws ClassifyEngineException {
        if (this.getValues() == null) {
            throw new ClassifyEngineException("Null position", new String[0]);
        }
        if (this.getValues().isEmpty()) {
            throw new ClassifyEngineException("Empty position", new String[0]);
        }
        for (int nI = 0; nI < this.getValues().size(); ++nI) {
            ((Value)this.getValues().get(nI)).checkValue();
        }
    }
}

