/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.config.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.social.UserIdSource;
import org.springframework.social.config.xml.ApiHelper;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.facebook.api.Facebook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookApiHelper
implements ApiHelper<Facebook> {
    private final UsersConnectionRepository usersConnectionRepository;
    private final UserIdSource userIdSource;
    private static final Log logger = LogFactory.getLog(FacebookApiHelper.class);

    public FacebookApiHelper(UsersConnectionRepository usersConnectionRepository, UserIdSource userIdSource) {
        this.usersConnectionRepository = usersConnectionRepository;
        this.userIdSource = userIdSource;
    }

    public Facebook getApi() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Getting API binding instance for Facebook");
        }
        Connection connection = this.usersConnectionRepository.createConnectionRepository(this.userIdSource.getUserId()).findPrimaryConnection(Facebook.class);
        if (logger.isDebugEnabled() && connection == null) {
            logger.debug((Object)"No current connection; Returning default FacebookTemplate instance.");
        }
        return connection != null ? (Facebook)connection.getApi() : null;
    }
}

