/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.variables;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.persistence.PersistenceException;
import javax.transaction.Transactional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.variables.Variable;
import org.silverpeas.core.variables.VariableScheduledValue;
import org.silverpeas.core.web.mvc.webcomponent.WebMessager;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;

@Service
public class VariablesWebManager {
    protected VariablesWebManager() {
    }

    public static VariablesWebManager get() {
        return (VariablesWebManager)ServiceProvider.getService(VariablesWebManager.class, (Annotation[])new Annotation[0]);
    }

    public List<Variable> getAllVariables() {
        return Variable.getAll();
    }

    public List<Variable> getCurrentVariables() {
        List currentValues = VariableScheduledValue.getCurrentOnes();
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (VariableScheduledValue currentValue : currentValues) {
            variables.add(currentValue.getVariable());
        }
        return variables;
    }

    public Variable getVariable(String id) {
        Variable variable = Variable.getById((String)id);
        if (variable == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return variable;
    }

    @Transactional
    public Variable createVariable(Variable variable) {
        this.checkAdminAccess();
        Variable createdVariable = this.process(() -> ((Variable)variable).save(), "variables.variable.create.failure");
        this.addSuccess("variables.variable.create.success");
        return createdVariable;
    }

    @Transactional
    public Variable updateVariable(String variableId, Variable variableToUpdate) {
        this.checkAdminAccess();
        Variable updatedVariable = this.process(() -> {
            Variable variable = this.getVariable(variableId);
            variable.merge(variableToUpdate);
            return variable.save();
        }, "variables.variable.update.failure");
        this.addSuccess("variables.variable.update.success");
        return updatedVariable;
    }

    @Transactional
    public void deleteVariable(String id) {
        this.checkAdminAccess();
        this.process(() -> {
            Variable variable = this.getVariable(id);
            if (variable != null) {
                variable.delete();
            }
            return null;
        }, "variables.variable.delete.failure");
        this.addSuccess("variables.variable.delete.success");
    }

    @Transactional
    public void deleteVariables(List<String> ids) {
        this.checkAdminAccess();
        this.process(() -> {
            for (String id : ids) {
                Variable variable = this.getVariable(id);
                if (variable == null) continue;
                variable.delete();
            }
            return null;
        }, "variables.variable.delete.failure.many");
        this.addSuccess("variables.variable.delete.success.many", ids.size());
    }

    @Transactional
    public VariableScheduledValue scheduleValue(VariableScheduledValue value, String variableId) {
        this.checkAdminAccess();
        VariableScheduledValue createdPeriod = this.process(() -> {
            Variable variable = this.getVariable(variableId);
            return variable.getVariableValues().addAndSave(value);
        }, "variables.variable.value.create.failure");
        this.addSuccess("variables.variable.value.create.success");
        return createdPeriod;
    }

    @Transactional
    public VariableScheduledValue updateValue(String valueId, String variableId, VariableScheduledValue newValueState) {
        this.checkAdminAccess();
        VariableScheduledValue updatedValue = this.process(() -> {
            Variable variable = this.getVariable(variableId);
            VariableScheduledValue value = (VariableScheduledValue)variable.getVariableValues().get(valueId).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
            return value.updateFrom(newValueState);
        }, "variables.variable.value.update.failure");
        this.addSuccess("variables.variable.value.update.success");
        return updatedValue;
    }

    @Transactional
    public void deleteValue(String valueId, String variableId) {
        this.checkAdminAccess();
        this.process(() -> {
            Variable variable = this.getVariable(variableId);
            if (!variable.getVariableValues().remove(valueId)) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            return variable.save();
        }, "variables.variable.value.delete.failure");
        this.addSuccess("variables.variable.value.delete.success");
    }

    private void checkAdminAccess() {
        if (!User.getCurrentRequester().isAccessAdmin()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    private void addSuccess(String key) {
        this.getMessager().addSuccess(this.getLocalizationBundle().getString(key), new Object[0]);
    }

    private void addSuccess(String key, Object ... params) {
        this.getMessager().addSuccess(this.getLocalizationBundle().getString(key), params);
    }

    private void addFailure(String key) {
        this.getMessager().addError(this.getLocalizationBundle().getString(key), new Object[0]);
    }

    private LocalizationBundle getLocalizationBundle() {
        return ResourceLocator.getLocalizationBundle((String)"org.silverpeas.variables.multilang.variables", (String)this.getUserLanguage());
    }

    private String getUserLanguage() {
        return User.getCurrentRequester().getUserPreferences().getLanguage();
    }

    private WebMessager getMessager() {
        return WebMessager.getInstance();
    }

    private <T> T process(Supplier<T> processor, String keyIfFailure) {
        try {
            return processor.get();
        }
        catch (PersistenceException e) {
            this.addFailure(keyIfFailure);
            throw e;
        }
    }
}

