/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.util.logging;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.ecs.xhtml.span;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.exception.RelativeFileAccessException;
import org.silverpeas.core.util.logging.LogsAccessor;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.util.logging.AbstractLoggingResource;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.logging.SilverLogger;

@WebService
@Authorized
@Path(value="logging/logs/{logName}")
public class LogResource
extends AbstractLoggingResource {
    static final String LOGS_PATH = "logging/logs";
    @Inject
    private LogsAccessor logsAccessor;
    @PathParam(value="logName")
    private String logName;

    @GET
    @Produces(value={"application/json"})
    public List<String> getLastLogRecordsAsJson(@QueryParam(value="count") int count) {
        return this.getLastLogRecords(count);
    }

    @GET
    @Produces(value={"text/html"})
    public String getLastLogRecordsAsHtml(@QueryParam(value="count") int count) {
        return this.getLastLogRecords(count).stream().collect(Collectors.joining("<br>")).replace("\t", new span("&#160;&#160;&#160;&#160;").toString());
    }

    @GET
    @Produces(value={"text/plain"})
    public String getLastLogRecordsAsText(@QueryParam(value="count") int count) {
        return this.getLastLogRecords(count).stream().collect(Collectors.joining("\n"));
    }

    private List<String> getLastLogRecords(int count) {
        try {
            return this.logsAccessor.getLastLogRecords(this.logName, count);
        }
        catch (SilverpeasException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error(ex.getMessage(), (Throwable)ex);
            if (ex.getCause() instanceof FileNotFoundException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (ex.getCause() instanceof RelativeFileAccessException) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected String getResourceBasePath() {
        return LOGS_PATH;
    }
}

