/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.subscribe;

import java.net.URI;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.comment.CommentRuntimeException;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.SubscriptionServiceProvider;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.subscription.service.UserSubscriptionSubscriber;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.web.mvc.webcomponent.WebMessager;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.web.subscription.bean.SubscriptionBeanProvider;
import org.silverpeas.core.webapi.subscribe.AbstractSubscriptionResource;

@WebService
@Path(value="subscribe/{componentId}")
@Authorized
public class SubscribeResource
extends AbstractSubscriptionResource {
    static final String PATH = "subscribe";

    @POST
    @Produces(value={"application/json"})
    public String subscribeToComponent() {
        return this.subscribeToResource(CommonSubscriptionResourceConstants.COMPONENT, null);
    }

    @POST
    @Path(value="{subscriptionType}/{id}")
    @Produces(value={"application/json"})
    public String subscribeToResource(@PathParam(value="subscriptionType") String subscriptionType, @PathParam(value="id") String id) {
        return this.subscribeToResource(this.decodeSubscriptionResourceType(subscriptionType), id);
    }

    private String subscribeToResource(SubscriptionResourceType subscriptionResourceType, String resourceId) {
        try {
            Subscription subscription = this.getSubscription((SubscriptionSubscriber)UserSubscriptionSubscriber.from((String)this.getUser().getId()), subscriptionResourceType, resourceId);
            SubscriptionServiceProvider.getSubscribeService().subscribe(subscription);
            String userLanguage = this.getUserPreferences().getLanguage();
            SubscriptionBeanProvider.getBySubscription(subscription, userLanguage).ifPresent(b -> WebMessager.getInstance().addSuccess(this.getBundle().getString("GML.subscribe.success"), b.getPath()));
            return JSONCodec.encodeArray(j -> j.add("OK"));
        }
        catch (CommentRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    protected URI identifiedBy(URI uri) {
        return uri;
    }

    protected String getResourceBasePath() {
        return PATH;
    }
}

