/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.security;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.security.encryption.CipherKeyUpdateException;
import org.silverpeas.core.security.encryption.ContentEncryptionService;
import org.silverpeas.core.security.encryption.DefaultContentEncryptionService;
import org.silverpeas.core.security.encryption.cipher.CryptoException;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;

@WebService
@Path(value="security/cipherkey")
@Authorized
public class CipherKeyResource
extends RESTWebService {
    public static final String WEB_PATH = "security/cipherkey";
    protected static final String INVALID_CIPHER_KEY = "crypto.invalidKey";
    protected static final String CIPHER_KEY_UPDATE_FAILURE = "crypto.keyUpdateFailure";
    protected static final String CIPHER_RENEW_FAILURE = "crypto.cipherRenewFailure";
    protected static final String CIPHER_KEY_IMPORT_SUCCESS = "crypto.importOk";
    @Inject
    private DefaultContentEncryptionService contentEncryptionService;

    protected String getResourceBasePath() {
        return WEB_PATH;
    }

    public String getComponentId() {
        return "ADMIN";
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getToto() {
        return Response.ok((Object)"Toto").build();
    }

    @PUT
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response setCipherKey(String cipherKey) {
        Response status;
        LocalizationBundle messages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.crypto.multilang.cryptoBundle", (String)this.getUserPreferences().getLanguage());
        try {
            this.getContentEncryptionService().updateCipherKey(cipherKey);
            status = Response.ok((Object)messages.getString(CIPHER_KEY_IMPORT_SUCCESS)).build();
        }
        catch (AssertionError e) {
            CipherKeyResource.logError((Throwable)((Object)e));
            String message = CipherKeyResource.formatMessage(messages.getString(INVALID_CIPHER_KEY), ((Throwable)((Object)e)).getMessage());
            status = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
        catch (CipherKeyUpdateException e) {
            CipherKeyResource.logError(e);
            String message = CipherKeyResource.formatMessage(messages.getString(CIPHER_KEY_UPDATE_FAILURE), e.getMessage());
            status = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).build();
        }
        catch (CryptoException e) {
            CipherKeyResource.logError(e);
            String message = CipherKeyResource.formatMessage(messages.getString(CIPHER_RENEW_FAILURE), e.getMessage());
            status = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).build();
        }
        return status;
    }

    private ContentEncryptionService getContentEncryptionService() {
        return this.contentEncryptionService;
    }

    public void validateUserAuthorization(UserPrivilegeValidation validation) {
        if (!this.getUser().isAccessAdmin()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    private static String formatMessage(String pattern, String value) {
        Object msg = pattern;
        if (!pattern.endsWith("\n")) {
            msg = (String)msg + " ";
        }
        return (String)msg + value;
    }

    private static void logError(Throwable ex) {
        SilverLogger.getLogger(CipherKeyResource.class).error(ex.getMessage(), ex);
    }
}

