/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.arraypanes;

import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.web.util.viewgenerator.html.SimpleGraphicElement;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCell;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayEmptyCell;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayLine;

public class ArrayCellLink
extends ArrayCell
implements SimpleGraphicElement,
Comparable<SimpleGraphicElement> {
    private String color = null;
    private final String link;
    private String info = null;
    private String target = null;

    public ArrayCellLink(String text, String link2, ArrayLine line) {
        super(text, line);
        this.link = link2;
    }

    public ArrayCellLink(String text, String link2, String info, ArrayLine line) {
        super(text, line);
        this.link = link2;
        this.info = info;
    }

    public String getText() {
        return this.getName();
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getLink() {
        return this.link;
    }

    public String getInfo() {
        return this.info;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @Override
    public int compareTo(@Nonnull SimpleGraphicElement other) {
        if (other instanceof ArrayEmptyCell) {
            return 1;
        }
        if (!(other instanceof ArrayCellLink)) {
            return 0;
        }
        ArrayCellLink tmp = (ArrayCellLink)other;
        return this.getText().compareToIgnoreCase(tmp.getText());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayCellLink)) {
            return false;
        }
        ArrayCellLink that = (ArrayCellLink)o;
        return that.getText().equals(((ArrayCellLink)o).getText());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getText()).hashCode();
    }

    @Override
    public String getSyntax() {
        StringBuilder result = new StringBuilder();
        if (this.getColor() != null) {
            result.append(" <font color=\"").append(this.getColor()).append("\">");
        }
        result.append("<a class=\"").append(this.getStyleSheet()).append("\" ");
        result.append("href=\"").append(this.getLink()).append("\"");
        if (this.getTarget() != null) {
            result.append(" target=\"").append(this.getTarget()).append("\"");
        }
        result.append(">");
        result.append(this.getText());
        result.append("</a>");
        if (this.getColor() != null) {
            result.append("</font>");
        }
        return result.toString();
    }
}

