/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.servlets;

import java.net.URI;
import java.net.URLEncoder;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.mvc.route.ComponentInstanceRoutingMapProvider;
import org.silverpeas.core.web.mvc.route.ComponentInstanceRoutingMapProviderByInstance;
import org.silverpeas.core.web.util.servlet.GoTo;
import org.silverpeas.kernel.util.StringUtil;

public class GoToContribution
extends GoTo {
    private static final long serialVersionUID = -5953875234057830718L;
    @Inject
    private ComponentInstanceRoutingMapProviderByInstance routingMapProvider;

    @Override
    public String getDestination(String objectId, HttpServletRequest req, HttpServletResponse res) throws Exception {
        ContributionIdentifier contributionId = this.getContributionIdentifier(objectId);
        String componentInstanceId = contributionId.getComponentInstanceId();
        this.setGefSpaceId(req, componentInstanceId);
        ComponentInstanceRoutingMapProvider routingMap = this.routingMapProvider.getByInstanceId(componentInstanceId);
        User requester = User.getCurrentRequester();
        UriBuilder permalink = UriBuilder.fromUri((URI)routingMap.relativeToSilverpeas().getPermalink(contributionId));
        Optional.ofNullable(req.getParameter("ComponentId")).filter(StringUtil::isDefined).ifPresent(i -> permalink.queryParam("ComponentId", new Object[]{i}));
        URI page = requester != null ? Optional.ofNullable(permalink.build(new Object[0])).filter(Predicate.not(p -> p.toString().startsWith(URLUtil.getApplicationURL() + "/Contribution"))).orElseGet(() -> routingMap.relative().getViewPage(contributionId)) : permalink.build(new Object[0]);
        return "goto=" + URLEncoder.encode(page.toString(), Charsets.UTF_8);
    }

    protected ContributionIdentifier getContributionIdentifier(String objectId) {
        return ContributionIdentifier.decode((String)new String(StringUtil.fromBase64((String)objectId)));
    }
}

