/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.attachment.tag;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.util.AttachmentSettings;
import org.silverpeas.core.contribution.attachment.webdav.WebdavWbeFile;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.wbe.WbeFile;
import org.silverpeas.core.wbe.WbeHostManager;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.util.viewgenerator.html.TagUtil;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.StringUtil;

public class SimpleDocumentContextualMenu
extends TagSupport {
    private static final int HTML_BUFFER_CAPACITY = 2048;
    private static final String UL_END = "</ul>";
    private SimpleDocument attachment;
    private String afManagerName;
    private boolean useXMLForm;
    private boolean useWebDAV;
    private boolean showMenuNotif;
    private boolean fromAlias;
    private SilverpeasRole userRole;
    private static final String TEMPLATE = "oMenu%s.getItem(%s).cfg.setProperty(\"disabled\", %s);";
    private static final String MENU_ITEM_TEMPLATE = "<li class=\"yuimenuitem\"><a class=\"yuimenuitemlabel\" href=\"javascript:%1$s\">%2$s</a></li>%n";
    private static final long serialVersionUID = 1L;

    public void setAttachment(SimpleDocument attachment) {
        this.attachment = attachment;
        this.afManagerName = "_afManager" + TagUtil.formatForDomId(attachment.getForeignId());
    }

    public void setUseXMLForm(boolean useXMLForm) {
        this.useXMLForm = useXMLForm;
    }

    public void setUseWebDAV(boolean useWebDAV) {
        this.useWebDAV = useWebDAV;
    }

    public void setShowMenuNotif(boolean showMenuNotif) {
        this.showMenuNotif = showMenuNotif;
    }

    public void setFromAlias(boolean fromAlias) {
        this.fromAlias = fromAlias;
    }

    public void setUserRole(SilverpeasRole userRole) {
        this.userRole = userRole;
    }

    public int doStartTag() throws JspException {
        try {
            MainSessionController mainSessionController = (MainSessionController)this.pageContext.getSession().getAttribute("SilverSessionController");
            String favoriteLanguage = mainSessionController.getFavoriteLanguage();
            LocalizationBundle messages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.attachment.multilang.attachment", (String)favoriteLanguage);
            UserDetail user = mainSessionController.getCurrentUserDetail();
            if (!this.fromAlias && this.canBeModified(user)) {
                this.pageContext.getOut().print(this.prepareActions(this.attachment, this.useXMLForm, this.useWebDAV, user, favoriteLanguage, messages, this.showMenuNotif));
            } else {
                this.pageContext.getOut().print(this.prepareReadOnlyActions(this.attachment, user, messages, this.showMenuNotif));
            }
            return 1;
        }
        catch (IOException ioex) {
            throw new JspException((Throwable)ioex);
        }
    }

    boolean canBeModified(UserDetail user) {
        return this.userRole != null && this.userRole.isGreaterThanOrEquals(SilverpeasRole.WRITER) && this.attachment.canBeModifiedBy((User)user);
    }

    boolean isAdmin(User user) {
        return user.isAccessAdmin();
    }

    boolean isNotWorker(String userId, SimpleDocument attachment) {
        return !userId.equals(attachment.getEditedBy());
    }

    boolean isNotEditable(String userId, SimpleDocument attachment, boolean useWebDAV, boolean editableSimultaneously) {
        return !useWebDAV || !attachment.isOpenOfficeCompatible() || this.isNotWorker(userId, attachment) && !editableSimultaneously || !StringUtil.defaultStringIfNotDefined((String)attachment.getWebdavContentEditionLanguage(), (String)attachment.getLanguage()).equals(attachment.getLanguage());
    }

    String prepareActions(SimpleDocument attachment, boolean useXMLForm, boolean useWebDAV, UserDetail user, String userLanguage, LocalizationBundle resources, boolean showMenuNotif) {
        String userId = user.getId();
        String attachmentId = String.valueOf(attachment.getOldSilverpeasId());
        boolean webDavOK = useWebDAV && attachment.isOpenOfficeCompatible();
        boolean webBrowserEdition = useWebDAV && WbeHostManager.get().isHandled((WbeFile)new WebdavWbeFile(attachment));
        boolean editableSimultaneously = webBrowserEdition && attachment.editableSimultaneously().orElse(false) != false;
        StringBuilder builder = new StringBuilder(2048);
        this.buildDocumentLockingActions(attachment, userLanguage, resources, builder, attachmentId, webDavOK, webBrowserEdition);
        this.buildDocumentStateActions(attachment, resources, builder);
        builder.append("<ul>").append(StringUtil.NEWLINE);
        this.prepareMenuItem(builder, "ShareAttachment('" + attachmentId + "');", resources.getString("GML.share.file"));
        builder.append(UL_END).append(StringUtil.NEWLINE);
        builder.append("<ul>").append(StringUtil.NEWLINE);
        this.prepareMenuItem(builder, "notifyAttachment('" + attachmentId + "');", resources.getString("GML.notify"));
        builder.append(UL_END).append(StringUtil.NEWLINE);
        String menuItems = builder.toString();
        builder = new StringBuilder();
        if (attachment.isEdited()) {
            this.configureCheckout(builder, attachmentId);
            builder.append(this.configureCheckoutAndDownload(attachmentId, this.isNotWorker(userId, attachment)));
            builder.append(this.configureCheckoutAndEdit(attachmentId, this.isNotEditable(userId, attachment, useWebDAV, false)));
            if (webBrowserEdition) {
                builder.append(this.configureCheckoutAndEditWebBrowser(attachmentId, this.isNotEditable(userId, attachment, useWebDAV, editableSimultaneously)));
                builder.append(this.configureEditSimultaneously(attachmentId, this.isNotEditable(userId, attachment, useWebDAV, false)));
            }
            builder.append(this.configureCheckin(attachmentId, this.isNotWorker(userId, attachment) && !this.isAdmin((User)user), webBrowserEdition));
            builder.append(this.configureUpdate(attachmentId, this.isNotWorker(userId, attachment)));
            builder.append(this.configureDelete(attachmentId));
            builder.append(this.configureForbidDownloadForReaders(attachmentId));
            if (!userId.equals(attachment.getEditedBy())) {
                builder.append(this.configureXmlForm(attachmentId, true));
            }
        } else {
            builder.append(this.configureXmlForm(attachmentId, !useXMLForm));
            builder.append(this.configureCheckin(attachmentId, true, webBrowserEdition));
            boolean disableEdition = !useWebDAV || !attachment.isOpenOfficeCompatible();
            builder.append(this.configureCheckoutAndEdit(attachmentId, disableEdition));
            if (webBrowserEdition) {
                builder.append(this.configureCheckoutAndEditWebBrowser(attachmentId, disableEdition));
                builder.append(this.configureEditSimultaneously(attachmentId, disableEdition));
            }
        }
        builder.append(this.configureFileSharing(attachmentId, !attachment.isSharingAllowedForRolesFrom((User)user)));
        builder.append(this.configureSwitchState(attachmentId, !attachment.isVersioned() && this.isComponentPublicationAlwaysVisible(attachment.getInstanceId()) || attachment.isEdited()));
        builder.append(this.configureNotify(attachmentId, !showMenuNotif));
        String itemsConfig = builder.toString();
        return this.getMenu(attachmentId, menuItems, itemsConfig);
    }

    private void buildDocumentStateActions(SimpleDocument attachment, LocalizationBundle resources, StringBuilder builder) {
        builder.append("<ul>").append(StringUtil.NEWLINE);
        this.prepareMenuItem(builder, "updateAttachment('" + attachment.getId() + "','" + attachment.getLanguage() + "');", resources.getString("GML.modify"));
        this.prepareMenuItem(builder, "EditXmlForm('" + attachment.getId() + "','" + attachment.getLanguage() + "');", resources.getString("attachment.xmlForm.Edit"));
        String message = resources.getString("attachment.switchState.toVersioned");
        if (attachment.isVersioned()) {
            message = resources.getString("attachment.switchState.toSimple");
        }
        boolean isLastPublicVersion = attachment.getLastPublicVersion() != null;
        this.prepareMenuItem(builder, "switchState('" + attachment.getId() + "', " + attachment.isVersioned() + ", " + isLastPublicVersion + ");", message);
        this.prepareMenuItem(builder, "deleteAttachment('" + attachment.getId() + "','" + Encode.forJavaScriptAttribute((String)attachment.getFilename()) + "');", resources.getString("GML.delete"));
        message = resources.getString("attachment.download.allowReaders");
        boolean isDownloadAllowedForReaders = attachment.isDownloadAllowedForReaders();
        if (isDownloadAllowedForReaders) {
            message = resources.getString("attachment.download.forbidReaders");
        }
        this.prepareMenuItem(builder, "switchDownloadAllowedForReaders('" + attachment.getId() + "', " + !isDownloadAllowedForReaders + ");", message);
        if (AttachmentSettings.isDisplayableAsContentForComponentInstanceId((String)attachment.getInstanceId())) {
            message = resources.getString("attachment.displayAsContent.enable");
            boolean isDisplayAsContentEnabled = attachment.isDisplayableAsContent();
            if (isDisplayAsContentEnabled) {
                message = resources.getString("attachment.displayAsContent.disable");
            }
            this.prepareMenuItem(builder, "switchDisplayAsContentEnabled('" + attachment.getId() + "', " + !isDisplayAsContentEnabled + ");", message);
        }
        builder.append(UL_END).append(StringUtil.NEWLINE);
    }

    private void buildDocumentLockingActions(SimpleDocument attachment, String userLanguage, LocalizationBundle resources, StringBuilder builder, String attachmentId, boolean webDavOK, boolean webBrowserEdition) {
        builder.append("<ul class=\"first-of-type\">").append(StringUtil.NEWLINE);
        this.prepareMenuItem(builder, "checkout('" + attachment.getId() + "'," + attachmentId + "," + webDavOK + ");", resources.getString("checkOut"));
        this.prepareMenuItem(builder, "checkoutAndDownload('" + attachment.getId() + "'," + attachmentId + "," + webDavOK + ");", resources.getString("attachment.checkOutAndDownload"));
        String webdavContentEditionLanguageLabel = this.prepareOnlineEditActions(attachment, userLanguage, resources, attachmentId, builder, webBrowserEdition);
        this.prepareMenuItem(builder, "checkin('" + attachment.getId() + "'," + attachmentId + "," + attachment.isOpenOfficeCompatible() + ", false, " + attachment.isVersioned() + ", '" + webdavContentEditionLanguageLabel + "');", resources.getString("checkIn"));
        builder.append(UL_END).append(StringUtil.NEWLINE);
    }

    private String prepareOnlineEditActions(SimpleDocument attachment, String userLanguage, LocalizationBundle resources, String attachmentId, StringBuilder builder, boolean webBrowserEditionOK) {
        Object checkoutAndEditLabel = resources.getString("attachment.checkOutAndEditOnline");
        Object checkoutAndEditLabelWebBrowser = resources.getString("attachment.checkOutAndEditOnlineWebBrowner");
        String webdavContentEditionLanguageLabel = "";
        if (I18NHelper.isI18nContentEnabled()) {
            webdavContentEditionLanguageLabel = I18NHelper.getLanguageLabel((String)StringUtil.defaultStringIfNotDefined((String)attachment.getWebdavContentEditionLanguage(), (String)attachment.getLanguage()), (String)userLanguage);
            checkoutAndEditLabel = (String)checkoutAndEditLabel + " (" + webdavContentEditionLanguageLabel + ")";
            checkoutAndEditLabelWebBrowser = (String)checkoutAndEditLabelWebBrowser + " (" + webdavContentEditionLanguageLabel + ")";
        }
        this.prepareMenuItem(builder, "checkoutAndEdit('" + attachment.getId() + "'," + attachmentId + ",'" + StringUtil.defaultStringIfNotDefined((String)attachment.getWebdavContentEditionLanguage(), (String)attachment.getLanguage()) + "', false);", (String)checkoutAndEditLabel);
        if (webBrowserEditionOK) {
            this.prepareMenuItem(builder, "checkoutAndEdit('" + attachment.getId() + "'," + attachmentId + ",'" + StringUtil.defaultStringIfNotDefined((String)attachment.getWebdavContentEditionLanguage(), (String)attachment.getLanguage()) + "', true);", (String)checkoutAndEditLabelWebBrowser);
            String editSimultaneouslyLabel = resources.getString("attachment.editSimultaneously.enable");
            boolean isEditSimultaneouslyEnabled = attachment.editableSimultaneously().orElse(false);
            if (isEditSimultaneouslyEnabled) {
                editSimultaneouslyLabel = resources.getString("attachment.editSimultaneously.disable");
            }
            this.prepareMenuItem(builder, "switchEditSimultaneouslyEnabled('" + attachment.getId() + "', " + !isEditSimultaneouslyEnabled + ");", editSimultaneouslyLabel);
        }
        return webdavContentEditionLanguageLabel;
    }

    String prepareReadOnlyActions(SimpleDocument attachment, UserDetail user, LocalizationBundle resources, boolean showMenuNotif) {
        String attachmentId = String.valueOf(attachment.getOldSilverpeasId());
        StringBuilder itemsBuilder = new StringBuilder(2048);
        itemsBuilder.append("<ul>").append(StringUtil.NEWLINE);
        boolean sharingAllowed = attachment.isSharingAllowedForRolesFrom((User)user);
        if (sharingAllowed) {
            this.prepareMenuItem(itemsBuilder, "ShareAttachment('" + attachmentId + "');", resources.getString("GML.share.file"));
        }
        this.prepareMenuItem(itemsBuilder, "notifyAttachment('" + attachmentId + "');", resources.getString("GML.notify"));
        itemsBuilder.append(UL_END).append(StringUtil.NEWLINE);
        StringBuilder configBuilder = new StringBuilder();
        int menuIndex = 0;
        if (sharingAllowed) {
            configBuilder.append(String.format(TEMPLATE, attachmentId, menuIndex++, false));
        }
        configBuilder.append(String.format(TEMPLATE, attachmentId, menuIndex, !showMenuNotif));
        return this.getMenu(attachmentId, itemsBuilder.toString(), configBuilder.toString());
    }

    private String getMenu(String attachmentId, String items, String config) {
        String oMenuId = "oMenu" + attachmentId;
        String basicMenuId = "basicmenu" + attachmentId;
        return "<div id=\"" + basicMenuId + "\" class=\"yuimenu\">" + StringUtil.NEWLINE + "<div class=\"bd\">" + StringUtil.NEWLINE + items + "</div>" + StringUtil.NEWLINE + "</div>" + StringUtil.NEWLINE + "<script type=\"text/javascript\">var " + oMenuId + ";YAHOO.util.Event.onContentReady(\"" + basicMenuId + "\", function () {" + oMenuId + " = new YAHOO.widget.Menu(\"" + basicMenuId + "\", {hidedelay: 100, effect: {effect: YAHOO.widget.ContainerEffect.FADE, duration: 0.30}});" + oMenuId + ".render();" + config + "YAHOO.util.Event.addListener(\"" + basicMenuId + "\", \"mouseover\", " + oMenuId + ".show);YAHOO.util.Event.addListener(\"" + basicMenuId + "\", \"mouseout\", " + oMenuId + ".hide);YAHOO.util.Event.on(\"edit_" + attachmentId + "\", \"click\", function (event) {var xy = YAHOO.util.Event.getXY(event);" + oMenuId + ".cfg.setProperty(\"x\", xy[0]);" + oMenuId + ".cfg.setProperty(\"y\", xy[1]+10);" + oMenuId + ".show();  })});</script>";
    }

    public boolean isComponentPublicationAlwaysVisible(String componentInstanceId) {
        return StringUtil.getBooleanValue((String)AdministrationServiceProvider.getAdminService().getComponentParameterValue(componentInstanceId, "publicationAlwaysVisible"));
    }

    StringBuilder prepareMenuItem(StringBuilder buffer, String javascript, String label) {
        return buffer.append(String.format(MENU_ITEM_TEMPLATE, this.afManagerName + "." + javascript, label));
    }

    StringBuilder configureCheckout(StringBuilder buffer, String attachmentId) {
        return buffer.append(String.format(TEMPLATE, attachmentId, "0", true));
    }

    String configureCheckoutAndDownload(String attachmentId, boolean disable) {
        return String.format(TEMPLATE, attachmentId, "1", disable);
    }

    String configureCheckoutAndEdit(String attachmentId, boolean disable) {
        return String.format(TEMPLATE, attachmentId, "2", disable);
    }

    String configureCheckoutAndEditWebBrowser(String attachmentId, boolean disable) {
        return String.format(TEMPLATE, attachmentId, "3", disable);
    }

    String configureEditSimultaneously(String attachmentId, boolean disable) {
        return String.format(TEMPLATE, attachmentId, "4", disable);
    }

    String configureCheckin(String attachmentId, boolean disable, boolean webBrowserEditionOK) {
        return String.format(TEMPLATE, attachmentId, webBrowserEditionOK ? "5" : "3", disable);
    }

    String configureUpdate(String attachmentId, boolean disable) {
        return String.format(TEMPLATE, attachmentId, "0, 1", disable);
    }

    String configureDelete(String attachmentId) {
        return String.format(TEMPLATE, attachmentId, "3, 1", true);
    }

    String configureForbidDownloadForReaders(String attachmentId) {
        return String.format(TEMPLATE, attachmentId, "4, 1", true);
    }

    String configureXmlForm(String attachmentId, boolean disable) {
        return String.format(TEMPLATE, attachmentId, "1, 1", disable);
    }

    String configureFileSharing(String attachmentId, boolean disable) {
        return String.format(TEMPLATE, attachmentId, "0, 2", disable);
    }

    String configureSwitchState(String attachmentId, boolean disable) {
        return String.format(TEMPLATE, attachmentId, "2, 1", disable);
    }

    String configureNotify(String attachmentId, boolean disable) {
        return String.format(TEMPLATE, attachmentId, "0, 3", disable);
    }
}

