/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.form;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.TypeManager;
import org.silverpeas.core.contribution.content.form.XMLField;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.importexport.form.XMLModelContentType;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.util.StringUtil;

public class FormTemplateImportExport {
    public void importXMLModelContentType(ResourceReference pk, String objectType, XMLModelContentType xmlModel, String userId) throws PublicationTemplateException, FormException, IOException {
        String externalId = pk.getInstanceId() + ":" + xmlModel.getName();
        if (StringUtil.isDefined((String)objectType)) {
            externalId = pk.getInstanceId() + ":" + objectType + ":" + xmlModel.getName();
        }
        PublicationTemplateManager.getInstance().addDynamicPublicationTemplate(externalId, xmlModel.getName());
        PublicationTemplate pub = PublicationTemplateManager.getInstance().getPublicationTemplate(externalId);
        RecordSet set = pub.getRecordSet();
        DataRecord data = set.getRecord(pk.getId());
        if (data == null) {
            data = set.getEmptyRecord();
            data.setId(pk.getId());
        }
        List<XMLField> xmlFields = xmlModel.getFields();
        for (XMLField xmlField : xmlFields) {
            FieldTemplate fieldTemplate;
            String xmlFieldName = xmlField.getName();
            String xmlFieldValue = xmlField.getValue();
            Field field = data.getField(xmlFieldName);
            if (field == null || (fieldTemplate = pub.getRecordTemplate().getFieldTemplate(xmlFieldName)) == null) continue;
            FieldDisplayer fieldDisplayer = TypeManager.getInstance().getDisplayer(field.getTypeName(), fieldTemplate.getDisplayerName());
            String fieldValue = xmlFieldValue;
            if ("file".equals(field.getTypeName())) {
                fieldValue = this.manageFileField(pk, userId, xmlFieldValue);
            }
            fieldDisplayer.update(fieldValue, field, fieldTemplate, new PagesContext());
        }
        set.save(data);
    }

    public String manageFileField(ResourceReference pk, String userId, String xmlFieldValue) throws IOException {
        String fieldValue = null;
        DocumentType type = DocumentType.form;
        File image = new File(xmlFieldValue);
        if (image.length() > 0L) {
            String fileName = FileUtil.getFilename((String)xmlFieldValue);
            SimpleAttachment attachment = SimpleAttachment.builder((String)I18NHelper.DEFAULT_LANGUAGE).setFilename(fileName).setTitle(fileName).setDescription("").setSize(image.length()).setContentType(FileUtil.getMimeType((String)fileName)).setCreationData(userId, new Date()).build();
            SimpleDocument document = new SimpleDocument(new SimpleDocumentPK(null, pk.getInstanceId()), pk.getId(), 0, false, attachment);
            document.setDocumentType(type);
            fieldValue = AttachmentServiceProvider.getAttachmentService().createAttachment(document, image, true).getId();
        }
        return fieldValue;
    }
}

