/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common;

import java.util.ArrayList;
import java.util.List;

public class PortletPreferencesUtility {
    private static String ARRAY_DELIMITER = "|";
    private static String SPACE = " ";
    private static char ARRAY_DELIMITER_CHAR = ARRAY_DELIMITER.charAt(0);
    private static String ESCAPED_ARRAY_DELIMITER = ARRAY_DELIMITER + ARRAY_DELIMITER;
    private static int ARRAY_DELIMITER_LENGTH = ARRAY_DELIMITER.length();
    private static int ESCAPED_ARRAY_DELIMITER_LENGTH = ESCAPED_ARRAY_DELIMITER.length();
    public static final String NULL_STRING = "@@$$NULL_STRING$$@@";
    private static final String EMPTY_STRING = "@@$$EMPTY_STRING$$@@";

    public static String getPreferenceString(List prefs) {
        if (prefs != null) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < prefs.size(); ++i) {
                sb.append(ARRAY_DELIMITER);
                sb.append(PortletPreferencesUtility.getPreferenceString((String)prefs.get(i)));
            }
            return sb.toString();
        }
        return null;
    }

    public static String getPreferenceString(String[] prefs) {
        if (prefs != null) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < prefs.length; ++i) {
                sb.append(ARRAY_DELIMITER);
                sb.append(PortletPreferencesUtility.getPreferenceString(prefs[i]));
            }
            return sb.toString();
        }
        return null;
    }

    private static String getPreferenceString(String pref) {
        int arrayDelimiterIndex;
        if (pref == null) {
            pref = NULL_STRING;
        } else if (pref.length() == 0) {
            pref = EMPTY_STRING;
        }
        StringBuffer prefBuffer = new StringBuffer(pref);
        if (pref.startsWith(ARRAY_DELIMITER)) {
            prefBuffer.insert(0, SPACE);
        }
        if (pref.endsWith(ARRAY_DELIMITER)) {
            prefBuffer.insert(prefBuffer.length(), SPACE);
        }
        if ((arrayDelimiterIndex = prefBuffer.indexOf(ARRAY_DELIMITER)) != -1) {
            while (arrayDelimiterIndex != -1) {
                prefBuffer.replace(arrayDelimiterIndex, arrayDelimiterIndex + ARRAY_DELIMITER_LENGTH, ESCAPED_ARRAY_DELIMITER);
                arrayDelimiterIndex = prefBuffer.indexOf(ARRAY_DELIMITER, arrayDelimiterIndex + ESCAPED_ARRAY_DELIMITER_LENGTH);
            }
        }
        return prefBuffer.toString();
    }

    public static List getPreferenceValues(String pref) {
        ArrayList<String> prefArray = new ArrayList<String>();
        if (pref == null || pref.length() == 0) {
            return prefArray;
        }
        StringBuffer valueBuffer = new StringBuffer();
        StringBuffer prefBuffer = new StringBuffer(pref);
        boolean start = false;
        if (pref.startsWith(ARRAY_DELIMITER)) {
            if (pref.startsWith(ESCAPED_ARRAY_DELIMITER)) {
                prefBuffer.insert(0, SPACE);
                prefBuffer.insert(0, ARRAY_DELIMITER);
            }
        } else {
            prefBuffer.insert(0, ARRAY_DELIMITER);
        }
        if (pref.endsWith(ARRAY_DELIMITER)) {
            prefBuffer.insert(prefBuffer.length(), SPACE);
            prefBuffer.insert(prefBuffer.length(), ARRAY_DELIMITER);
        } else {
            prefBuffer.insert(prefBuffer.length(), ARRAY_DELIMITER);
        }
        String modifiedPref = prefBuffer.toString();
        char[] prefCharArray = modifiedPref.toCharArray();
        int modifiedPrefLength = prefCharArray.length;
        for (int i = 0; i < prefCharArray.length; ++i) {
            if (!start && prefCharArray[i] == '|') {
                start = true;
                valueBuffer = new StringBuffer();
                continue;
            }
            if (start && prefCharArray[i] == ARRAY_DELIMITER_CHAR && i + 1 != modifiedPrefLength && prefCharArray[i + 1] == ARRAY_DELIMITER_CHAR) {
                valueBuffer.append(prefCharArray[i]);
                valueBuffer.append(prefCharArray[i + 1]);
                ++i;
                continue;
            }
            if (start && prefCharArray[i] == ARRAY_DELIMITER_CHAR && (i + 1 == modifiedPrefLength || prefCharArray[i + 1] != ARRAY_DELIMITER_CHAR)) {
                if (valueBuffer.equals(NULL_STRING)) {
                    valueBuffer = null;
                } else if (valueBuffer.indexOf(EMPTY_STRING) != -1) {
                    valueBuffer = new StringBuffer("");
                } else {
                    PortletPreferencesUtility.replaceEscapedArrayDelimiter(valueBuffer);
                }
                prefArray.add(valueBuffer.toString());
                valueBuffer = new StringBuffer();
                continue;
            }
            if (!start) continue;
            valueBuffer.append(prefCharArray[i]);
        }
        return prefArray;
    }

    private static void replaceEscapedArrayDelimiter(StringBuffer valueBuffer) {
        int index = valueBuffer.indexOf(ESCAPED_ARRAY_DELIMITER);
        while (index != -1) {
            valueBuffer.replace(index, index + ESCAPED_ARRAY_DELIMITER_LENGTH, ARRAY_DELIMITER);
            index = valueBuffer.indexOf(ESCAPED_ARRAY_DELIMITER, index + ARRAY_DELIMITER_LENGTH);
        }
    }
}

