/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine.impl;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.appengine.RequestResponseFactory;
import com.sun.portal.portletcontainer.appengine.StringServletOutputStream;
import com.sun.portal.portletcontainer.common.PortletContainerActionRequest;
import com.sun.portal.portletcontainer.common.PortletContainerActionResponse;
import com.sun.portal.portletcontainer.common.PortletContainerEventRequest;
import com.sun.portal.portletcontainer.common.PortletContainerEventResponse;
import com.sun.portal.portletcontainer.common.PortletContainerRenderRequest;
import com.sun.portal.portletcontainer.common.PortletContainerRenderResponse;
import com.sun.portal.portletcontainer.common.PortletContainerResourceRequest;
import com.sun.portal.portletcontainer.common.PortletContainerResourceResponse;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.ActionRequestPool;
import com.sun.portal.portletcontainer.portlet.impl.ActionResponsePool;
import com.sun.portal.portletcontainer.portlet.impl.EventRequestPool;
import com.sun.portal.portletcontainer.portlet.impl.EventResponsePool;
import com.sun.portal.portletcontainer.portlet.impl.RenderRequestPool;
import com.sun.portal.portletcontainer.portlet.impl.RenderResponsePool;
import com.sun.portal.portletcontainer.portlet.impl.ResourceRequestPool;
import com.sun.portal.portletcontainer.portlet.impl.ResourceResponsePool;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestResponseFactoryImpl
implements RequestResponseFactory {
    public static final String MIN_SIZE = "minSizeParam";
    public static final String MAX_SIZE = "maxSizeParam";
    public static final String PARTITION = "partitionParam";
    private ActionRequestPool actionRequestPool;
    private RenderRequestPool renderRequestPool;
    private ActionResponsePool actionResponsePool;
    private RenderResponsePool renderResponsePool;
    private EventRequestPool eventRequestPool;
    private EventResponsePool eventResponsePool;
    private ResourceRequestPool resourceRequestPool;
    private ResourceResponsePool resourceResponsePool;
    private ServletContext servletContext;
    private static Logger logger = ContainerLogger.getLogger(RequestResponseFactoryImpl.class, (String)"PAELogMessages");
    private static final int DEFAULT_MIN_SIZE = 0;
    private static final int DEFAULT_MAX_SIZE = 200;
    private static final int DEFAULT_PARTITION_SIZE = 10;
    private static final int ACTION_REQUEST = 1;
    private static final int RENDER_REQUEST = 2;
    private static final int ACTION_RESPONSE = 3;
    private static final int RENDER_RESPONSE = 4;
    private static final int EVENT_REQUEST = 7;
    private static final int EVENT_RESPONSE = 8;
    private static final int RESOURCE_REQUEST = 9;
    private static final int RESOURCE_RESPONSE = 10;
    private static final String ACTION_REQUEST_POOL = "actionRequestPool";
    private static final String ACTION_RESPONSE_POOL = "actionResponsePool";
    private static final String RENDER_REQUEST_POOL = "renderRequestPool";
    private static final String RENDER_RESPONSE_POOL = "renderResponsePool";
    private static final String RESOURCE_REQUEST_POOL = "resourceRequestPool";
    private static final String RESOURCE_RESPONSE_POOL = "resourceResponsePool";
    private static final String EVENT_REQUEST_POOL = "eventRequestPool";
    private static final String EVENT_RESPONSE_POOL = "eventResponsePool";

    public RequestResponseFactoryImpl(ServletContext context) {
        this.servletContext = context;
        String minParam = context.getInitParameter("request_response_factory.minSizeParam");
        int min = minParam != null ? Integer.parseInt(minParam.trim()) : 0;
        String maxParam = context.getInitParameter("request_response_factory.maxSizeParam");
        int max = maxParam != null ? Integer.parseInt(maxParam.trim()) : 200;
        String partitionParam = context.getInitParameter("request_response_factory.partitionParam");
        int partition = partitionParam != null ? Integer.parseInt(partitionParam.trim()) : 10;
        logger.log(Level.FINEST, "PSPL_PAECSPPAI0001", min);
        logger.log(Level.FINEST, "PSPL_PAECSPPAI0002", max);
        logger.log(Level.FINEST, "PSPL_PAECSPPAI0003", partition);
        this.initRequestResponsePool(context, min, max, partition, 1);
        this.initRequestResponsePool(context, min, max, partition, 3);
        this.initRequestResponsePool(context, min, max, partition, 2);
        this.initRequestResponsePool(context, min, max, partition, 4);
        this.initRequestResponsePool(context, min, max, partition, 9);
        this.initRequestResponsePool(context, min, max, partition, 10);
        this.initRequestResponsePool(context, min, max, partition, 7);
        this.initRequestResponsePool(context, min, max, partition, 8);
        context.setAttribute(ACTION_REQUEST_POOL, (Object)this.actionRequestPool);
        context.setAttribute(ACTION_RESPONSE_POOL, (Object)this.actionResponsePool);
        context.setAttribute(RENDER_REQUEST_POOL, (Object)this.renderRequestPool);
        context.setAttribute(RENDER_RESPONSE_POOL, (Object)this.renderResponsePool);
        context.setAttribute(RESOURCE_REQUEST_POOL, (Object)this.resourceRequestPool);
        context.setAttribute(RESOURCE_RESPONSE_POOL, (Object)this.resourceResponsePool);
        context.setAttribute(EVENT_REQUEST_POOL, (Object)this.eventRequestPool);
        context.setAttribute(EVENT_RESPONSE_POOL, (Object)this.eventResponsePool);
    }

    public ActionRequest getActionRequest(HttpServletRequest request, HttpServletResponse response, PortletContainerActionRequest pcActionRequest, PortletContainerActionResponse pcActionResponse, PortletContext portletContext, PortalContext portalContext, PortletDescriptor portletDescriptor) {
        if (this.actionRequestPool == null) {
            this.actionRequestPool = (ActionRequestPool)this.servletContext.getAttribute(ACTION_REQUEST_POOL);
        }
        return this.actionRequestPool.obtainObject(request, response, pcActionRequest, pcActionResponse, portletContext, portalContext, portletDescriptor);
    }

    public RenderRequest getRenderRequest(HttpServletRequest request, HttpServletResponse response, PortletContainerRenderRequest pcRenderRequest, PortletContainerRenderResponse pcRenderResponse, PortletContext portletContext, PortalContext portalContext, PortletDescriptor portletDescriptor) {
        if (this.renderRequestPool == null) {
            this.renderRequestPool = (RenderRequestPool)this.servletContext.getAttribute(RENDER_REQUEST_POOL);
        }
        return this.renderRequestPool.obtainObject(request, response, pcRenderRequest, pcRenderResponse, portletContext, portalContext, portletDescriptor);
    }

    public ActionResponse getActionResponse(HttpServletRequest request, HttpServletResponse response, PortletContainerActionRequest pcActionRequest, PortletContainerActionResponse pcActionResponse, ActionRequest actionRequest, PortletAppDescriptor portletAppDescriptor, PortletDescriptor portletDescriptor) {
        if (this.actionResponsePool == null) {
            this.actionResponsePool = (ActionResponsePool)this.servletContext.getAttribute(ACTION_RESPONSE_POOL);
        }
        return this.actionResponsePool.obtainObject(request, response, pcActionRequest, pcActionResponse, actionRequest, portletAppDescriptor, portletDescriptor);
    }

    public RenderResponse getRenderResponse(HttpServletRequest request, HttpServletResponse response, PortletContainerRenderRequest pcRenderRequest, PortletContainerRenderResponse pcRenderResponse, RenderRequest renderRequest, PortletAppDescriptor portletAppDescriptor, PortletDescriptor portletDescriptor, StringWriter stringWriter, StringServletOutputStream outputStream) {
        if (this.renderResponsePool == null) {
            this.renderResponsePool = (RenderResponsePool)this.servletContext.getAttribute(RENDER_RESPONSE_POOL);
        }
        return this.renderResponsePool.obtainObject(request, response, pcRenderRequest, pcRenderResponse, renderRequest, portletAppDescriptor, portletDescriptor, stringWriter, outputStream);
    }

    public void releaseActionRequest(ActionRequest actionRequest) {
        this.actionRequestPool.releaseObject(actionRequest);
    }

    public void releaseRenderRequest(RenderRequest renderRequest) {
        this.renderRequestPool.releaseObject(renderRequest);
    }

    public void releaseActionResponse(ActionResponse actionResponse) {
        this.actionResponsePool.releaseObject(actionResponse);
    }

    public void releaseRenderResponse(RenderResponse renderResponse) {
        this.renderResponsePool.releaseObject(renderResponse);
    }

    public EventRequest getEventRequest(HttpServletRequest request, HttpServletResponse response, PortletContainerEventRequest pcEventRequest, PortletContainerEventResponse pcEventResponse, PortletContext portletContext, PortalContext portalContext, PortletDescriptor portletDescriptor) {
        if (this.eventRequestPool == null) {
            this.eventRequestPool = (EventRequestPool)this.servletContext.getAttribute(EVENT_REQUEST_POOL);
        }
        return this.eventRequestPool.obtainObject(request, response, pcEventRequest, pcEventResponse, portletContext, portalContext, portletDescriptor);
    }

    public EventResponse getEventResponse(HttpServletRequest request, HttpServletResponse response, PortletContainerEventRequest pcEventRequest, PortletContainerEventResponse pcEventResponse, EventRequest eventRequest, PortletAppDescriptor portletAppDescriptor, PortletDescriptor portletDescriptor) {
        if (this.eventResponsePool == null) {
            this.eventResponsePool = (EventResponsePool)this.servletContext.getAttribute(EVENT_RESPONSE_POOL);
        }
        return this.eventResponsePool.obtainObject(request, response, pcEventRequest, pcEventResponse, eventRequest, portletAppDescriptor, portletDescriptor);
    }

    public void releaseEventRequest(EventRequest eventRequest) {
        this.eventRequestPool.releaseObject(eventRequest);
    }

    public void releaseEventResponse(EventResponse eventResponse) {
        this.eventResponsePool.releaseObject(eventResponse);
    }

    public ResourceRequest getResourceRequest(HttpServletRequest request, HttpServletResponse response, PortletContainerResourceRequest pcResourceRequest, PortletContainerResourceResponse pcResourceResponse, PortletContext portletContext, PortalContext portalContext, PortletDescriptor portletDescriptor) {
        if (this.resourceRequestPool == null) {
            this.resourceRequestPool = (ResourceRequestPool)this.servletContext.getAttribute(RESOURCE_REQUEST_POOL);
        }
        return this.resourceRequestPool.obtainObject(request, response, pcResourceRequest, pcResourceResponse, portletContext, portalContext, portletDescriptor);
    }

    public ResourceResponse getResourceResponse(HttpServletRequest request, HttpServletResponse response, PortletContainerResourceRequest pcResourceRequest, PortletContainerResourceResponse pcResourceResponse, ResourceRequest resourceRequest, PortletAppDescriptor portletAppDescriptor, PortletDescriptor portletDescriptor, StringWriter stringWriter, StringServletOutputStream outputStream) {
        if (this.resourceResponsePool == null) {
            this.resourceResponsePool = (ResourceResponsePool)this.servletContext.getAttribute(RESOURCE_RESPONSE_POOL);
        }
        return this.resourceResponsePool.obtainObject(request, response, pcResourceRequest, pcResourceResponse, resourceRequest, portletAppDescriptor, portletDescriptor, stringWriter, outputStream);
    }

    public void releaseResourceRequest(ResourceRequest resourceRequest) {
        this.resourceRequestPool.releaseObject(resourceRequest);
    }

    public void releaseResourceResponse(ResourceResponse resourceResponse) {
        this.resourceResponsePool.releaseObject(resourceResponse);
    }

    private void initRequestResponsePool(ServletContext context, int minSize, int maxSize, int partition, int type) {
        if (minSize < 0) {
            logger.log(Level.FINER, "PSPL_PAECSPPAI0004", new Integer(0));
            minSize = 0;
        }
        if (maxSize < 0) {
            logger.log(Level.FINER, "PSPL_PAECSPPAI0005", new Integer(200));
            maxSize = 200;
        }
        if (partition < 0) {
            logger.log(Level.FINER, "PSPL_PAECSPPAI0006", new Integer(10));
            partition = 10;
        }
        if (minSize > maxSize) {
            logger.log(Level.FINER, "PSPL_PAECSPPAI0007", new Integer(200));
            minSize = 200;
        }
        if (partition > maxSize) {
            logger.log(Level.FINER, "PSPL_PAECSPPAI0008", new Integer(200));
            partition = 200;
        }
        switch (type) {
            case 1: {
                this.actionRequestPool = new ActionRequestPool(context, minSize, maxSize, true, partition);
                break;
            }
            case 2: {
                this.renderRequestPool = new RenderRequestPool(context, minSize, maxSize, true, partition);
                break;
            }
            case 3: {
                this.actionResponsePool = new ActionResponsePool(minSize, maxSize, true, partition);
                break;
            }
            case 4: {
                this.renderResponsePool = new RenderResponsePool(minSize, maxSize, true, partition);
                break;
            }
            case 7: {
                this.eventRequestPool = new EventRequestPool(context, minSize, maxSize, true, partition);
                break;
            }
            case 8: {
                this.eventResponsePool = new EventResponsePool(minSize, maxSize, true, partition);
                break;
            }
            case 10: {
                this.resourceResponsePool = new ResourceResponsePool(minSize, maxSize, true, partition);
                break;
            }
            case 9: {
                this.resourceRequestPool = new ResourceRequestPool(context, minSize, maxSize, true, partition);
            }
        }
    }

    public void destroy() {
        this.actionRequestPool = null;
        this.renderRequestPool = null;
        this.actionResponsePool = null;
        this.renderResponsePool = null;
        this.eventRequestPool = null;
        this.eventResponsePool = null;
        this.resourceRequestPool = null;
        this.resourceResponsePool = null;
    }
}

