/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ChangeAddressEventData
implements EventResponseData {
    private final int flags;
    private final int proto;
    private final int addrFamily;
    private final String address;
    private final String pstkName;
    private final String source;

    public ChangeAddressEventData(ASN1Object message) throws IOException {
        byte[] data = ((ASN1OctetString)message).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        LBERDecoder decode = new LBERDecoder();
        int[] length = new int[1];
        this.flags = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.proto = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.addrFamily = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.address = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.pstkName = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.source = ((ASN1OctetString)decode.decode(in, length)).stringValue();
    }

    public String getAddress() {
        return this.address;
    }

    public int getAddrFamily() {
        return this.addrFamily;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getProto() {
        return this.proto;
    }

    public String getPstkName() {
        return this.pstkName;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ChangeAddresssEvent[flags=" + this.getFlags() + "]");
        buf.append("[proto=" + this.getProto() + "]");
        buf.append("[addrFamily=" + this.getAddrFamily() + "]");
        buf.append("[address=" + this.getAddress() + "]");
        buf.append("[pstkName=" + this.getPstkName() + "]");
        buf.append("[source=" + this.getSource() + "]]");
        return buf.toString();
    }
}

