/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionExpirationMetaData;

public class SimpleSessionExpirationMetaDataMarshaller
implements ProtoStreamMarshaller<SimpleSessionExpirationMetaData> {
    private static final byte MAX_INACTIVE_INTERVAL_INDEX = 1;
    private static final byte LAST_ACCESS_END_TIME_INDEX = 2;
    private static final Duration DEFAULT_MAX_INACTIVE_INTERVAL = Duration.ofMinutes(30L);
    private static final Instant DEFAULT_LAST_ACCESS_END_TIME = Instant.EPOCH;

    public Class<? extends SimpleSessionExpirationMetaData> getJavaClass() {
        return SimpleSessionExpirationMetaData.class;
    }

    public SimpleSessionExpirationMetaData readFrom(ProtoStreamReader reader) throws IOException {
        Duration maxInactiveInterval = DEFAULT_MAX_INACTIVE_INTERVAL;
        Instant lastAccessEndTime = DEFAULT_LAST_ACCESS_END_TIME;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    maxInactiveInterval = (Duration)reader.readObject(Duration.class);
                    continue block4;
                }
                case 2: {
                    lastAccessEndTime = (Instant)reader.readObject(Instant.class);
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return new SimpleSessionExpirationMetaData(maxInactiveInterval, lastAccessEndTime);
    }

    public void writeTo(ProtoStreamWriter writer, SimpleSessionExpirationMetaData metaData) throws IOException {
        Instant lastAccessEndTime;
        Duration maxInactiveInterval = metaData.getMaxInactiveInterval();
        if (!maxInactiveInterval.equals(DEFAULT_MAX_INACTIVE_INTERVAL)) {
            writer.writeObject(1, (Object)maxInactiveInterval);
        }
        if (!(lastAccessEndTime = metaData.getLastAccessEndTime()).equals(DEFAULT_LAST_ACCESS_END_TIME)) {
            writer.writeObject(2, (Object)lastAccessEndTime);
        }
    }
}

