/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl.dataformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalInternalRecord;
import org.apache.activemq.artemis.core.persistence.Persister;

public class JournalAddRecord
extends JournalInternalRecord {
    protected final long id;
    protected final Persister persister;
    protected final Object record;
    protected final byte recordType;
    protected final byte journalType;

    public JournalAddRecord(byte journalType, long id, byte recordType, Persister persister, Object record) {
        this.id = id;
        this.record = record;
        this.recordType = recordType;
        this.journalType = journalType;
        this.persister = persister;
    }

    public JournalAddRecord(boolean add, long id, byte recordType, Persister persister, Object record) {
        this(add ? (byte)11 : 12, id, recordType, persister, record);
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        buffer.writeByte(this.journalType);
        buffer.writeInt(this.fileID);
        buffer.writeByte(this.compactCount);
        buffer.writeLong(this.id);
        int recordEncodeSize = this.persister.getEncodeSize(this.record);
        buffer.writeInt(recordEncodeSize);
        buffer.writeByte(this.recordType);
        this.persister.encode(buffer, this.record);
        buffer.writeInt(recordEncodeSize + 22 + 1);
    }

    @Override
    public int getEncodeSize() {
        return 22 + this.persister.getEncodeSize(this.record) + 1;
    }
}

