/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.replication;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.EventLoop;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.util.internal.PlatformDependent;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQReplicationTimeooutException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.impl.journal.AbstractJournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.ChannelImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationAddMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationAddTXMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationCommitMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationDeleteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationDeleteTXMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLargeMessageBeginMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLargeMessageEndMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLargeMessageWriteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPageEventMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPageWriteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPrepareMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationResponseMessageV2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationStartSyncMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.jboss.logging.Logger;

public final class ReplicationManager
implements ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(ReplicationManager.class);
    private final ActiveMQServer server;
    private final ResponseHandler responseHandler = new ResponseHandler();
    private final Channel replicatingChannel;
    private boolean started;
    private volatile boolean enabled;
    private final Queue<OperationContext> pendingTokens = new ConcurrentLinkedQueue<OperationContext>();
    private final ExecutorFactory ioExecutorFactory;
    private SessionFailureListener failureListener;
    private CoreRemotingConnection remotingConnection;
    private final long maxAllowedSlownessNanos;
    private final long initialReplicationSyncTimeout;
    private volatile boolean inSync = true;
    private final ReusableLatch synchronizationIsFinishedAcknowledgement = new ReusableLatch(0);
    private final Queue<ReplicatePacketRequest> replicatePacketRequests;
    private final Executor replicationStream;
    private final ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> slowReplicationChecker;
    private long notWritableFrom;
    private boolean checkSlowReplication;
    private final ReadyListener onResume;
    private boolean isFlushing;
    private boolean awaitingResume;

    public ReplicationManager(ActiveMQServer server, CoreRemotingConnection remotingConnection, long timeout, long initialReplicationSyncTimeout, ExecutorFactory ioExecutorFactory) {
        this.server = server;
        this.ioExecutorFactory = ioExecutorFactory;
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
        this.replicatingChannel = remotingConnection.getChannel(ChannelImpl.CHANNEL_ID.REPLICATION.id, -1);
        this.remotingConnection = remotingConnection;
        Connection transportConnection = this.remotingConnection.getTransportConnection();
        if (transportConnection instanceof NettyConnection) {
            EventLoop eventLoop = ((NettyConnection)transportConnection).getNettyChannel().eventLoop();
            this.replicationStream = eventLoop;
            this.scheduledExecutorService = eventLoop;
        } else {
            this.replicationStream = ioExecutorFactory.getExecutor();
            this.scheduledExecutorService = null;
        }
        this.maxAllowedSlownessNanos = timeout > 0L ? TimeUnit.MILLISECONDS.toNanos(timeout) : -1L;
        this.replicatePacketRequests = PlatformDependent.newMpscQueue();
        this.slowReplicationChecker = null;
        this.notWritableFrom = Long.MAX_VALUE;
        this.awaitingResume = false;
        this.onResume = this::resume;
        this.isFlushing = false;
        this.checkSlowReplication = false;
    }

    public void appendUpdateRecord(byte journalID, ADD_OPERATION_TYPE operation, long id, byte recordType, Persister persister, Object record) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationAddMessage(journalID, operation, id, recordType, persister, record));
        }
    }

    public void appendDeleteRecord(byte journalID, long id) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationDeleteMessage(journalID, id));
        }
    }

    public void appendAddRecordTransactional(byte journalID, ADD_OPERATION_TYPE operation, long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationAddTXMessage(journalID, operation, txID, id, recordType, persister, record));
        }
    }

    public void appendCommitRecord(byte journalID, long txID, boolean sync, boolean lineUp) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationCommitMessage(journalID, false, txID), lineUp);
        }
    }

    public void appendDeleteRecordTransactional(byte journalID, long txID, long id, EncodingSupport record) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationDeleteTXMessage(journalID, txID, id, record));
        }
    }

    public void appendDeleteRecordTransactional(byte journalID, long txID, long id) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationDeleteTXMessage(journalID, txID, id, NullEncoding.instance));
        }
    }

    public void appendPrepareRecord(byte journalID, long txID, EncodingSupport transactionData) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationPrepareMessage(journalID, txID, transactionData));
        }
    }

    public void appendRollbackRecord(byte journalID, long txID) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationCommitMessage(journalID, true, txID));
        }
    }

    public void pageClosed(SimpleString storeName, int pageNumber) {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationPageEventMessage(storeName, pageNumber, false));
        }
    }

    public void pageDeleted(SimpleString storeName, int pageNumber) {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationPageEventMessage(storeName, pageNumber, true));
        }
    }

    public void pageWrite(PagedMessage message, int pageNumber) {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationPageWriteMessage(message, pageNumber));
        }
    }

    public void largeMessageBegin(long messageId) {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationLargeMessageBeginMessage(messageId));
        }
    }

    public void largeMessageDelete(Long messageId, JournalStorageManager storageManager) {
        if (this.enabled) {
            long pendingRecordID = storageManager.generateID();
            this.sendReplicatePacket((Packet)new ReplicationLargeMessageEndMessage(messageId, pendingRecordID, true));
        }
    }

    public void largeMessageClosed(Long messageId, JournalStorageManager storageManager) {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationLargeMessageEndMessage(messageId, -1L, false));
        }
    }

    public void largeMessageWrite(long messageId, byte[] body) {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationLargeMessageWriteMessage(messageId, body));
        }
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized void start() throws ActiveMQException {
        if (this.started) {
            throw new IllegalStateException("ReplicationManager is already started");
        }
        this.replicatingChannel.setHandler((ChannelHandler)this.responseHandler);
        this.failureListener = new ReplicatedSessionFailureListener();
        this.remotingConnection.addFailureListener((FailureListener)this.failureListener);
        if (this.scheduledExecutorService != null && this.maxAllowedSlownessNanos >= 0L) {
            long periodNanos = this.maxAllowedSlownessNanos / 10L;
            if (periodNanos > TimeUnit.SECONDS.toNanos(1L)) {
                periodNanos = TimeUnit.SECONDS.toNanos(1L);
            } else if (periodNanos < TimeUnit.MILLISECONDS.toNanos(100L)) {
                logger.warnf("The cluster call timeout is too low ie %d ms: consider raising it to save CPU", (Object)TimeUnit.NANOSECONDS.toMillis(this.maxAllowedSlownessNanos));
                periodNanos = TimeUnit.MILLISECONDS.toNanos(100L);
            }
            logger.debugf("Slow replication checker is running with a period of %d ms", TimeUnit.NANOSECONDS.toMillis(periodNanos));
            this.slowReplicationChecker = this.scheduledExecutorService.scheduleAtFixedRate(this::checkSlowReplication, periodNanos, periodNanos, TimeUnit.NANOSECONDS);
        }
        this.started = true;
        this.enabled = true;
    }

    public void stop() throws Exception {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean clearTokens) throws Exception {
        CoreRemotingConnection toStop;
        ReplicationManager replicationManager = this;
        synchronized (replicationManager) {
            if (!this.started) {
                logger.trace((Object)"Stopping being ignored as it hasn't been started");
                return;
            }
            this.started = false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("stop(clearTokens=" + clearTokens + ")"), (Throwable)new Exception("Trace"));
        }
        if (this.replicatingChannel != null) {
            this.replicatingChannel.close();
            this.replicatingChannel.getConnection().getTransportConnection().fireReady(true);
        }
        if (this.slowReplicationChecker != null) {
            this.slowReplicationChecker.cancel(false);
            this.slowReplicationChecker = null;
        }
        this.enabled = false;
        if (clearTokens) {
            this.clearReplicationTokens();
        }
        if ((toStop = this.remotingConnection) != null) {
            toStop.removeFailureListener((FailureListener)this.failureListener);
            toStop.destroy();
        }
        this.remotingConnection = null;
    }

    public void clearReplicationTokens() {
        logger.trace((Object)"clearReplicationTokens initiating");
        while (!this.pendingTokens.isEmpty()) {
            OperationContext ctx = this.pendingTokens.poll();
            logger.trace((Object)"Calling ctx.replicationDone()");
            try {
                ctx.replicationDone();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorCompletingCallbackOnReplicationManager(e);
            }
        }
        logger.trace((Object)"clearReplicationTokens finished");
    }

    public Set<OperationContext> getActiveTokens() {
        LinkedHashSet<OperationContext> activeContexts = new LinkedHashSet<OperationContext>();
        for (OperationContext ctx : this.pendingTokens) {
            activeContexts.add(ctx);
        }
        return activeContexts;
    }

    private OperationContext sendReplicatePacket(Packet packet) {
        return this.sendReplicatePacket(packet, true);
    }

    private OperationContext sendReplicatePacket(Packet packet, boolean lineUp) {
        return this.sendReplicatePacket(packet, lineUp, null);
    }

    private OperationContext sendReplicatePacket(Packet packet, boolean lineUp, ReusableLatch done) {
        if (!this.enabled) {
            packet.release();
            return null;
        }
        OperationContext repliToken = OperationContextImpl.getContext(this.ioExecutorFactory);
        if (lineUp) {
            repliToken.replicationLineUp();
        }
        ReplicatePacketRequest request = new ReplicatePacketRequest(packet, repliToken, done);
        this.replicatePacketRequests.add(request);
        this.replicationStream.execute(() -> {
            if (this.enabled) {
                this.sendReplicatedPackets(false);
            } else {
                this.releaseReplicatedPackets(this.replicatePacketRequests);
            }
        });
        return repliToken;
    }

    private void releaseReplicatedPackets(Queue<ReplicatePacketRequest> requests) {
        ReplicatePacketRequest req;
        assert (this.checkEventLoop());
        while ((req = requests.poll()) != null) {
            req.packet.release();
            req.context.replicationDone();
            if (req.done == null) continue;
            req.done.countDown();
        }
    }

    private void checkSlowReplication() {
        if (!this.enabled) {
            return;
        }
        assert (this.checkEventLoop());
        if (!this.checkSlowReplication) {
            return;
        }
        boolean isWritable = this.replicatingChannel.getConnection().blockUntilWritable(0L);
        if (isWritable) {
            this.checkSlowReplication = false;
            return;
        }
        long elapsedNanosNotWritable = System.nanoTime() - this.notWritableFrom;
        if (elapsedNanosNotWritable >= this.maxAllowedSlownessNanos) {
            this.checkSlowReplication = false;
            this.releaseReplicatedPackets(this.replicatePacketRequests);
            try {
                ActiveMQServerLogger.LOGGER.slowReplicationResponse();
                this.stop();
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void resume() {
        this.sendReplicatedPackets(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReplicatedPackets(boolean resume) {
        assert (this.checkEventLoop());
        if (resume) {
            this.awaitingResume = false;
        }
        if (this.awaitingResume || this.isFlushing || !this.enabled) {
            return;
        }
        if (this.replicatePacketRequests.isEmpty()) {
            return;
        }
        this.isFlushing = true;
        CoreRemotingConnection connection = this.replicatingChannel.getConnection();
        try {
            while (connection.blockUntilWritable(0L)) {
                this.checkSlowReplication = false;
                ReplicatePacketRequest request = this.replicatePacketRequests.poll();
                if (request == null) {
                    this.replicatingChannel.flushConnection();
                    return;
                }
                this.pendingTokens.add(request.context);
                Packet pack = request.packet;
                ReusableLatch done = request.done;
                if (done != null) {
                    done.countDown();
                }
                this.replicatingChannel.send(pack, false);
            }
            this.replicatingChannel.flushConnection();
            assert (!this.awaitingResume);
            if (!this.replicatePacketRequests.isEmpty()) {
                if (!connection.isWritable(this.onResume)) {
                    this.checkSlowReplication = true;
                    this.notWritableFrom = System.nanoTime();
                    this.awaitingResume = true;
                } else {
                    this.replicationStream.execute(() -> this.sendReplicatedPackets(false));
                }
            }
        }
        catch (Throwable t) {
            assert (!(t instanceof AssertionError)) : t.getMessage();
            if (!connection.getTransportConnection().isOpen()) {
                logger.trace((Object)"Transport connection closed: cleaning up replicate tokens", t);
                this.releaseReplicatedPackets(this.replicatePacketRequests);
                connection.getTransportConnection().fireReady(true);
            } else {
                logger.warn((Object)"Unexpected error while flushing replicate packets", t);
            }
        }
        finally {
            this.isFlushing = false;
        }
    }

    private boolean checkEventLoop() {
        if (!(this.replicationStream instanceof SingleThreadEventLoop)) {
            return true;
        }
        SingleThreadEventLoop eventLoop = (SingleThreadEventLoop)this.replicationStream;
        return eventLoop.inEventLoop();
    }

    private void replicated() {
        assert (this.checkEventLoop());
        OperationContext ctx = this.pendingTokens.poll();
        if (ctx == null) {
            ActiveMQServerLogger.LOGGER.missingReplicationTokenOnQueue();
            return;
        }
        ctx.replicationDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncJournalFile(JournalFile jf, AbstractJournalStorageManager.JournalContent content) throws Exception {
        if (!this.enabled) {
            return;
        }
        SequentialFile file = jf.getFile().cloneFile();
        try {
            ActiveMQServerLogger.LOGGER.replicaSyncFile(file, file.size());
            this.sendLargeFile(content, null, jf.getFileID(), file, Long.MAX_VALUE);
        }
        finally {
            if (file.isOpen()) {
                file.close();
            }
        }
    }

    public void syncLargeMessageFile(SequentialFile file, long size, long id) throws Exception {
        if (this.enabled) {
            this.sendLargeFile(null, null, id, file, size);
        }
    }

    public void syncPages(SequentialFile file, long id, SimpleString queueName) throws Exception {
        if (this.enabled) {
            this.sendLargeFile(null, queueName, id, file, Long.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLargeFile(AbstractJournalStorageManager.JournalContent content, SimpleString pageStore, long id, SequentialFile file, long maxBytesToSend) throws Exception {
        if (!this.enabled) {
            return;
        }
        if (!file.isOpen()) {
            file.open();
        }
        int size = 32768;
        int flowControlSize = 10;
        int packetsSent = 0;
        ReusableLatch flushed = new ReusableLatch(1);
        try (FileInputStream fis = new FileInputStream(file.getJavaFile());
             FileChannel channel = fis.getChannel();){
            boolean lastPacket;
            do {
                boolean flowControlCheck;
                int bytesRead;
                ByteBuf buffer = PooledByteBufAllocator.DEFAULT.directBuffer(32768, 32768);
                buffer.clear();
                ByteBuffer byteBuffer = buffer.writerIndex(32768).readerIndex(0).nioBuffer();
                int toSend = bytesRead = channel.read(byteBuffer);
                if (bytesRead > 0) {
                    if ((long)bytesRead >= maxBytesToSend) {
                        toSend = (int)maxBytesToSend;
                        maxBytesToSend = 0L;
                    } else {
                        maxBytesToSend -= (long)bytesRead;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debugf("sending %d bytes on file %s", buffer.writerIndex(), (Object)file.getFileName());
                }
                lastPacket = bytesRead == -1 || bytesRead == 0 || maxBytesToSend == 0L;
                boolean bl = flowControlCheck = packetsSent % flowControlSize == 0 || lastPacket;
                if (flowControlCheck) {
                    flushed.setCount(1);
                    this.sendReplicatePacket((Packet)new ReplicationSyncFileMessage(content, pageStore, id, toSend, buffer), true, flushed);
                    this.awaitFlushOfReplicationStream(flushed);
                } else {
                    this.sendReplicatePacket((Packet)new ReplicationSyncFileMessage(content, pageStore, id, toSend, buffer), true);
                }
                ++packetsSent;
            } while (!lastPacket);
        }
        finally {
            if (file.isOpen()) {
                file.close();
            }
        }
    }

    private void awaitFlushOfReplicationStream(ReusableLatch flushed) throws Exception {
        if (!flushed.await(this.initialReplicationSyncTimeout, TimeUnit.MILLISECONDS)) {
            throw ActiveMQMessageBundle.BUNDLE.replicationSynchronizationTimeout(this.initialReplicationSyncTimeout);
        }
    }

    public void sendStartSyncMessage(JournalFile[] datafiles, AbstractJournalStorageManager.JournalContent contentType, String nodeID, boolean allowsAutoFailBack) throws ActiveMQException {
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationStartSyncMessage(datafiles, contentType, nodeID, allowsAutoFailBack));
        }
    }

    public void sendSynchronizationDone(String nodeID, long initialReplicationSyncTimeout, IOCriticalErrorListener criticalErrorListener) throws ActiveMQReplicationTimeooutException {
        if (this.enabled) {
            block9: {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("sendSynchronizationDone ::" + nodeID + ", " + initialReplicationSyncTimeout));
                }
                this.synchronizationIsFinishedAcknowledgement.countUp();
                this.sendReplicatePacket((Packet)new ReplicationStartSyncMessage(nodeID, this.server.getNodeManager().getNodeActivationSequence()));
                try {
                    if (this.synchronizationIsFinishedAcknowledgement.await(initialReplicationSyncTimeout)) break block9;
                    ActiveMQReplicationTimeooutException exception = ActiveMQMessageBundle.BUNDLE.replicationSynchronizationTimeout(initialReplicationSyncTimeout);
                    if (this.server != null) {
                        try {
                            ClusterManager clusterManager = this.server.getClusterManager();
                            if (clusterManager != null) {
                                QuorumManager manager = clusterManager.getQuorumManager();
                                if (criticalErrorListener != null && manager != null && manager.getMaxClusterSize() <= 2) {
                                    criticalErrorListener.onIOException((Throwable)exception, exception.getMessage(), null);
                                }
                            }
                        }
                        catch (Throwable e) {
                            logger.warn((Object)e.getMessage(), e);
                        }
                    }
                    logger.trace((Object)"sendSynchronizationDone wasn't finished in time");
                    throw exception;
                }
                catch (InterruptedException e) {
                    logger.debug((Object)e);
                }
            }
            this.inSync = false;
            logger.trace((Object)"sendSynchronizationDone finished");
        }
    }

    public void sendLargeMessageIdListMessage(Map<Long, Pair<String, Long>> largeMessages) {
        ArrayList<Long> idsToSend = new ArrayList<Long>(largeMessages.keySet());
        if (this.enabled) {
            this.sendReplicatePacket((Packet)new ReplicationStartSyncMessage(idsToSend));
        }
    }

    public OperationContext sendLiveIsStopping(ReplicationLiveIsStoppingMessage.LiveStopping finalMessage) {
        logger.debug((Object)("LIVE IS STOPPING?!? message=" + (Object)((Object)finalMessage) + " enabled=" + this.enabled));
        if (this.enabled) {
            logger.debug((Object)("LIVE IS STOPPING?!? message=" + (Object)((Object)finalMessage) + " " + this.enabled));
            return this.sendReplicatePacket((Packet)new ReplicationLiveIsStoppingMessage(finalMessage));
        }
        return null;
    }

    public CoreRemotingConnection getBackupTransportConnection() {
        return this.remotingConnection;
    }

    public boolean isSynchronizing() {
        return this.inSync;
    }

    private static final class NullEncoding
    implements EncodingSupport {
        static final NullEncoding instance = new NullEncoding();

        private NullEncoding() {
        }

        public void decode(ActiveMQBuffer buffer) {
        }

        public void encode(ActiveMQBuffer buffer) {
        }

        public int getEncodeSize() {
            return 0;
        }
    }

    private final class ResponseHandler
    implements ChannelHandler {
        private ResponseHandler() {
        }

        public void handlePacket(Packet packet) {
            if (packet.getType() == 90 || packet.getType() == -9) {
                ReplicationResponseMessageV2 replicationResponseMessage;
                ReplicationManager.this.replicated();
                if (packet.getType() == -9 && (replicationResponseMessage = (ReplicationResponseMessageV2)packet).isSynchronizationIsFinishedAcknowledgement()) {
                    ReplicationManager.this.synchronizationIsFinishedAcknowledgement.countDown();
                }
            }
        }
    }

    private final class ReplicatedSessionFailureListener
    implements SessionFailureListener {
        private ReplicatedSessionFailureListener() {
        }

        public void connectionFailed(ActiveMQException me, boolean failedOver) {
            if (me.getType() == ActiveMQExceptionType.DISCONNECTED) {
                ActiveMQServerLogger.LOGGER.replicationStopOnBackupShutdown();
            } else {
                ActiveMQServerLogger.LOGGER.replicationStopOnBackupFail((Exception)((Object)me));
            }
            try {
                ReplicationManager.this.stop();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorStoppingReplication(e);
            }
        }

        public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
            this.connectionFailed(me, failedOver);
        }

        public void beforeReconnect(ActiveMQException me) {
        }
    }

    private static final class ReplicatePacketRequest {
        final Packet packet;
        final OperationContext context;
        final ReusableLatch done;

        ReplicatePacketRequest(Packet packet, OperationContext context, ReusableLatch done) {
            this.packet = packet;
            this.context = context;
            this.done = done;
        }
    }

    public static enum ADD_OPERATION_TYPE {
        UPDATE{

            @Override
            public byte toRecord() {
                return 0;
            }
        }
        ,
        ADD{

            @Override
            public byte toRecord() {
                return 1;
            }
        }
        ,
        EVENT{

            @Override
            public byte toRecord() {
                return 2;
            }
        };


        public abstract byte toRecord();

        public static ADD_OPERATION_TYPE toOperation(byte recordType) {
            switch (recordType) {
                case 0: {
                    return UPDATE;
                }
                case 1: {
                    return ADD;
                }
                case 2: {
                    return EVENT;
                }
            }
            return ADD;
        }
    }
}

