/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.internal;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.narayana.compensations.api.Compensatable;
import org.jboss.narayana.compensations.api.CompensatableAction;
import org.jboss.narayana.compensations.api.CompensatableWork;
import org.jboss.narayana.compensations.api.CompensationHandler;
import org.jboss.narayana.compensations.api.CompensationManager;
import org.jboss.narayana.compensations.api.ConfirmationHandler;
import org.jboss.narayana.compensations.api.EnlistException;
import org.jboss.narayana.compensations.internal.BAControllerFactory;
import org.jboss.narayana.compensations.internal.ParticipantManager;

public class CompensatableActionImpl
implements CompensatableAction {
    private static final Logger LOGGER = Logger.getLogger(CompensatableActionImpl.class);
    @Inject
    private CompensationManager compensationManager;
    private List<WorkInfo> workList = new LinkedList<WorkInfo>();

    @Override
    public CompensatableAction addWork(CompensatableWork compensatableWork, CompensationHandler compensationHandler) {
        return this.addWork(compensatableWork, compensationHandler, null);
    }

    @Override
    public CompensatableAction addWork(CompensatableWork compensatableWork, ConfirmationHandler confirmationHandler) {
        return this.addWork(compensatableWork, null, confirmationHandler);
    }

    @Override
    public CompensatableAction addWork(CompensatableWork compensatableWork, CompensationHandler compensationHandler, ConfirmationHandler confirmationHandler) {
        this.workList.add(new WorkInfo(compensatableWork, compensationHandler, confirmationHandler));
        return this;
    }

    @Override
    @Compensatable
    public void execute() throws EnlistException {
        for (WorkInfo workInfo : this.workList) {
            Set<ParticipantManager> managers = this.enlistHandlers(workInfo);
            try {
                workInfo.compensatableWork.execute();
            }
            catch (RuntimeException e) {
                this.exit(managers);
                throw e;
            }
            this.complete(managers);
        }
        this.workList.clear();
    }

    private Set<ParticipantManager> enlistHandlers(WorkInfo workInfo) throws EnlistException {
        HashSet<ParticipantManager> managers = new HashSet<ParticipantManager>();
        if (workInfo.compensationHandler != null) {
            try {
                managers.add(BAControllerFactory.getInstance().enlist(workInfo.compensationHandler, null, null));
            }
            catch (Exception e) {
                this.compensationManager.setCompensateOnly();
                throw new EnlistException("Failed to enlist compensation handler", e);
            }
        }
        if (workInfo.confirmationHandler != null) {
            try {
                managers.add(BAControllerFactory.getInstance().enlist(null, workInfo.confirmationHandler, null));
            }
            catch (Exception e) {
                this.exit(managers);
                this.compensationManager.setCompensateOnly();
                throw new EnlistException("Failed to enlist confirmation handler", e);
            }
        }
        return managers;
    }

    private void complete(Set<ParticipantManager> managers) {
        managers.forEach(pm -> {
            try {
                pm.completed();
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Failed to complete compensatable action", (Throwable)e);
            }
        });
    }

    private void exit(Set<ParticipantManager> managers) {
        managers.forEach(pm -> {
            try {
                pm.exit();
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Failed to exit compensatable action", (Throwable)e);
            }
        });
    }

    private static class WorkInfo {
        private CompensatableWork compensatableWork;
        private CompensationHandler compensationHandler;
        private ConfirmationHandler confirmationHandler;

        WorkInfo(CompensatableWork compensatableWork, CompensationHandler compensationHandler, ConfirmationHandler confirmationHandler) {
            this.compensatableWork = compensatableWork;
            this.compensationHandler = compensationHandler;
            this.confirmationHandler = confirmationHandler;
        }
    }
}

