/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.async;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.async.AsyncLogger;
import io.smallrye.faulttolerance.core.util.CompletionStages;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

public class CompletionStageExecution<V>
implements FaultToleranceStrategy<CompletionStage<V>> {
    private final FaultToleranceStrategy<CompletionStage<V>> delegate;
    private final Executor executor;

    public CompletionStageExecution(FaultToleranceStrategy<CompletionStage<V>> delegate, Executor executor) {
        this.delegate = delegate;
        this.executor = Preconditions.checkNotNull(executor, "Executor must be set");
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) {
        AsyncLogger.LOG.trace("CompletionStageExecution started");
        try {
            CompletionStage<V> completionStage = this.doApply(ctx);
            return completionStage;
        }
        finally {
            AsyncLogger.LOG.trace("CompletionStageExecution finished");
        }
    }

    private CompletionStage<V> doApply(InvocationContext<CompletionStage<V>> ctx) {
        Executor executor = ctx.get(Executor.class, this.executor);
        CompletableFuture result = new CompletableFuture();
        executor.execute(() -> {
            try {
                CompletionStages.propagateCompletion(this.delegate.apply(ctx), result);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }
}

