/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.wildfly.common.iteration.ByteIterator;

@Deprecated
public class UsernamePasswordHashUtil {
    private static final String MD5 = "MD5";
    private static final byte COLON = 58;
    private final MessageDigest digest;

    public UsernamePasswordHashUtil() throws NoSuchAlgorithmException {
        this.digest = MessageDigest.getInstance(MD5);
    }

    public UsernamePasswordHashUtil(MessageDigest digest) {
        this.digest = digest;
    }

    private byte[] stringToByte(String toConvert, boolean allowUTF8) {
        if (allowUTF8) {
            char[] theChars;
            for (char c : theChars = toConvert.toCharArray()) {
                if (c <= '\u00ff') continue;
                return toConvert.getBytes(StandardCharsets.UTF_8);
            }
        }
        return toConvert.getBytes(StandardCharsets.ISO_8859_1);
    }

    private byte[] stringToByte(char[] toConvert, boolean allowUTF8) {
        if (allowUTF8) {
            for (char c : toConvert) {
                if (c <= '\u00ff') continue;
                return String.valueOf(toConvert).getBytes(StandardCharsets.UTF_8);
            }
        }
        return String.valueOf(toConvert).getBytes(StandardCharsets.ISO_8859_1);
    }

    public byte[] generateHashedURP(String userName, String realm, char[] password, boolean utf8StringConversion) {
        byte[] userNameArray = this.stringToByte(userName, utf8StringConversion);
        byte[] realmArray = this.stringToByte(realm, utf8StringConversion);
        byte[] passwordArray = this.stringToByte(password, utf8StringConversion);
        int requiredSize = userNameArray.length + realmArray.length + passwordArray.length + 2;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(requiredSize);
            baos.write(userNameArray);
            baos.write(58);
            baos.write(realmArray);
            baos.write(58);
            baos.write(passwordArray);
            return this.digest.digest(baos.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public byte[] generateHashedURP(String userName, String realm, char[] password) {
        return this.generateHashedURP(userName, realm, password, true);
    }

    public String generateHashedHexURP(String userName, String realm, char[] password, boolean utf8StringConversion) {
        byte[] hashedURP = this.generateHashedURP(userName, realm, password, utf8StringConversion);
        return ByteIterator.ofBytes(hashedURP).hexEncode().drainToString();
    }

    public String generateHashedHexURP(String userName, String realm, char[] password) {
        return this.generateHashedHexURP(userName, realm, password, true);
    }
}

