/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.wildfly.security.http.oidc.AccessToken;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.IDToken;

public class OidcSecurityContext
implements Serializable {
    protected String tokenString;
    protected String idTokenString;
    protected transient AccessToken token;
    protected transient IDToken idToken;

    public OidcSecurityContext() {
    }

    public OidcSecurityContext(String tokenString, AccessToken token, String idTokenString, IDToken idToken) {
        this.tokenString = tokenString;
        this.token = token;
        this.idToken = idToken;
        this.idTokenString = idTokenString;
    }

    public AccessToken getToken() {
        return this.token;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public IDToken getIDToken() {
        return this.idToken;
    }

    public String getIDTokenString() {
        return this.idTokenString;
    }

    public String getRealm() {
        return this.token.getIssuer().substring(this.token.getIssuer().lastIndexOf(47) + 1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.token = new AccessToken(new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build().processToClaims(this.tokenString));
            this.idToken = new IDToken(new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build().processToClaims(this.idTokenString));
        }
        catch (InvalidJwtException e) {
            throw ElytronMessages.log.unableToParseToken();
        }
    }
}

