/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.undertow.ApplicationSecurityDomainDefinition;
import org.wildfly.extension.undertow.ApplicationSecurityDomainSingleSignOnDefinition;
import org.wildfly.extension.undertow.ConsoleAccessLogDefinition;
import org.wildfly.extension.undertow.HostDefinition;
import org.wildfly.extension.undertow.HttpListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpsListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.WebsocketsDefinition;
import org.wildfly.extension.undertow.filters.ModClusterDefinition;
import org.wildfly.extension.undertow.filters.NoAffinityResourceDefinition;
import org.wildfly.extension.undertow.filters.RankedAffinityResourceDefinition;
import org.wildfly.extension.undertow.filters.SingleAffinityResourceDefinition;
import org.wildfly.extension.undertow.handlers.ReverseProxyHandler;

public class UndertowTransformers
implements ExtensionTransformerRegistration {
    private static ModelVersion MODEL_VERSION_EAP7_0_0 = ModelVersion.create((int)3, (int)1, (int)0);
    private static ModelVersion MODEL_VERSION_EAP7_1_0 = ModelVersion.create((int)4, (int)0, (int)0);
    private static ModelVersion MODEL_VERSION_EAP7_2_0 = ModelVersion.create((int)7, (int)0, (int)0);
    private static final ModelVersion MODEL_VERSION_WILDFLY_16 = ModelVersion.create((int)8, (int)0, (int)0);
    private static final ModelVersion MODEL_VERSION_WILDFLY_18 = ModelVersion.create((int)10, (int)0, (int)0);
    private static final ModelVersion MODEL_VERSION_WILDFLY_22 = ModelVersion.create((int)11, (int)0, (int)0);

    public String getSubsystemName() {
        return "undertow";
    }

    public void registerTransformers(SubsystemTransformerRegistration subsystemRegistration) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)subsystemRegistration.getCurrentSubsystemVersion());
        UndertowTransformers.registerTransformersWildFly22(chainedBuilder.createBuilder(subsystemRegistration.getCurrentSubsystemVersion(), MODEL_VERSION_WILDFLY_22));
        UndertowTransformers.registerTransformersWildFly18(chainedBuilder.createBuilder(MODEL_VERSION_WILDFLY_22, MODEL_VERSION_WILDFLY_18));
        UndertowTransformers.registerTransformersWildFly16(chainedBuilder.createBuilder(MODEL_VERSION_WILDFLY_18, MODEL_VERSION_WILDFLY_16));
        UndertowTransformers.registerTransformers_EAP_7_2_0(chainedBuilder.createBuilder(MODEL_VERSION_WILDFLY_16, MODEL_VERSION_EAP7_2_0));
        UndertowTransformers.registerTransformers_EAP_7_1_0(chainedBuilder.createBuilder(MODEL_VERSION_EAP7_2_0, MODEL_VERSION_EAP7_1_0));
        UndertowTransformers.registerTransformers_EAP_7_0_0(chainedBuilder.createBuilder(MODEL_VERSION_EAP7_1_0, MODEL_VERSION_EAP7_0_0));
        chainedBuilder.buildAndRegister(subsystemRegistration, (ModelVersion[][])new ModelVersion[][]{{MODEL_VERSION_WILDFLY_22, MODEL_VERSION_WILDFLY_18, MODEL_VERSION_WILDFLY_16, MODEL_VERSION_EAP7_2_0, MODEL_VERSION_EAP7_1_0, MODEL_VERSION_EAP7_0_0}});
    }

    private static void registerTransformersWildFly22(ResourceTransformationDescriptionBuilder subsystemBuilder) {
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"obfuscate-session-route"})).setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new String[]{"obfuscate-session-route"})).end();
    }

    private static void registerTransformersWildFly18(ResourceTransformationDescriptionBuilder subsystemBuilder) {
        ((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(UndertowExtension.PATH_APPLICATION_SECURITY_DOMAIN).addChildResource(UndertowExtension.PATH_SSO).getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new String[]{ApplicationSecurityDomainSingleSignOnDefinition.Attribute.CREDENTIAL.getName()})).end();
        ((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(UndertowExtension.PATH_HANDLERS).addChildResource(PathElement.pathElement((String)"reverse-proxy")).getAttributeBuilder().setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{ReverseProxyHandler.CONNECTION_IDLE_TIMEOUT})).end();
    }

    private static void registerTransformersWildFly16(ResourceTransformationDescriptionBuilder subsystemBuilder) {
        subsystemBuilder.addChildResource(UndertowExtension.SERVER_PATH).addChildResource(UndertowExtension.HOST_PATH).rejectChildResource(ConsoleAccessLogDefinition.INSTANCE.getPathElement());
    }

    private static void registerTransformers_EAP_7_2_0(ResourceTransformationDescriptionBuilder subsystemBuilder) {
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(UndertowExtension.PATH_APPLICATION_SECURITY_DOMAIN).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ApplicationSecurityDomainDefinition.ENABLE_JASPI, ApplicationSecurityDomainDefinition.INTEGRATED_JASPI})).setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{ApplicationSecurityDomainDefinition.ENABLE_JASPI, ApplicationSecurityDomainDefinition.INTEGRATED_JASPI})).end();
        ResourceTransformationDescriptionBuilder builder = subsystemBuilder.addChildResource(UndertowExtension.PATH_FILTERS).addChildResource(PathElement.pathElement((String)"mod-cluster"));
        builder.rejectChildResource(NoAffinityResourceDefinition.PATH);
        builder.discardChildResource(SingleAffinityResourceDefinition.PATH);
        builder.rejectChildResource(RankedAffinityResourceDefinition.PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(UndertowExtension.PATH_SERVLET_CONTAINER).getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{ServletContainerDefinition.PRESERVE_PATH_ON_FORWARD})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ServletContainerDefinition.PRESERVE_PATH_ON_FORWARD})).end();
    }

    private static void registerTransformers_EAP_7_1_0(ResourceTransformationDescriptionBuilder subsystemBuilder) {
        ResourceTransformationDescriptionBuilder serverBuilder = subsystemBuilder.addChildResource(UndertowExtension.SERVER_PATH);
        ResourceTransformationDescriptionBuilder hostBuilder = serverBuilder.addChildResource(UndertowExtension.HOST_PATH);
        ((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(UndertowExtension.PATH_APPLICATION_SECURITY_DOMAIN).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ApplicationSecurityDomainDefinition.SECURITY_DOMAIN})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(UndertowExtension.PATH_SERVLET_CONTAINER).getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{ServletContainerDefinition.FILE_CACHE_MAX_FILE_SIZE, ServletContainerDefinition.FILE_CACHE_METADATA_SIZE, ServletContainerDefinition.DEFAULT_COOKIE_VERSION})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{ServletContainerDefinition.FILE_CACHE_TIME_TO_LIVE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ServletContainerDefinition.FILE_CACHE_MAX_FILE_SIZE, ServletContainerDefinition.FILE_CACHE_METADATA_SIZE, ServletContainerDefinition.FILE_CACHE_TIME_TO_LIVE, ServletContainerDefinition.DEFAULT_COOKIE_VERSION})).end();
        AttributeTransformationDescriptionBuilder http = (AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)serverBuilder.addChildResource(UndertowExtension.HTTP_LISTENER_PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{HttpListenerResourceDefinition.PROXY_PROTOCOL})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleRejectAttributeChecker(ModelNode.TRUE), new String[]{HttpListenerResourceDefinition.PROXY_PROTOCOL.getName()});
        UndertowTransformers.addCommonListenerRules_EAP_7_1_0(http);
        AttributeTransformationDescriptionBuilder https = (AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)serverBuilder.addChildResource(UndertowExtension.HTTPS_LISTENER_PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{HttpListenerResourceDefinition.PROXY_PROTOCOL})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleRejectAttributeChecker(ModelNode.TRUE), new AttributeDefinition[]{HttpListenerResourceDefinition.PROXY_PROTOCOL});
        UndertowTransformers.addCommonListenerRules_EAP_7_1_0(https);
        AttributeTransformationDescriptionBuilder ajp = serverBuilder.addChildResource(UndertowExtension.AJP_LISTENER_PATH).getAttributeBuilder();
        UndertowTransformers.addCommonListenerRules_EAP_7_1_0(ajp);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)hostBuilder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{HostDefinition.QUEUE_REQUESTS_ON_START})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{HostDefinition.QUEUE_REQUESTS_ON_START})).end();
        subsystemBuilder.rejectChildResource(UndertowExtension.BYTE_BUFFER_POOL_PATH);
    }

    private static void addCommonListenerRules_EAP_7_1_0(AttributeTransformationDescriptionBuilder listener) {
        UndertowTransformers.convertCommonListenerAttributes(listener);
        ((AttributeTransformationDescriptionBuilder)listener.setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{ListenerResourceDefinition.ALLOW_UNESCAPED_CHARACTERS_IN_URL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ListenerResourceDefinition.ALLOW_UNESCAPED_CHARACTERS_IN_URL});
    }

    private static void registerTransformers_EAP_7_0_0(ResourceTransformationDescriptionBuilder subsystemBuilder) {
        ResourceTransformationDescriptionBuilder serverBuilder = subsystemBuilder.addChildResource(UndertowExtension.SERVER_PATH);
        ResourceTransformationDescriptionBuilder hostBuilder = serverBuilder.addChildResource(UndertowExtension.HOST_PATH);
        AttributeTransformationDescriptionBuilder https = (AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)serverBuilder.addChildResource(UndertowExtension.HTTPS_LISTENER_PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{HttpListenerResourceDefinition.CERTIFICATE_FORWARDING, HttpListenerResourceDefinition.PROXY_ADDRESS_FORWARDING})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{HttpsListenerResourceDefinition.SSL_CONTEXT})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{HttpListenerResourceDefinition.CERTIFICATE_FORWARDING, HttpListenerResourceDefinition.PROXY_ADDRESS_FORWARDING, HttpsListenerResourceDefinition.SSL_CONTEXT})).addRejectCheck(RejectAttributeChecker.UNDEFINED, new String[]{"security-realm"});
        UndertowTransformers.addCommonListenerRules_EAP_7_0_0(https).end();
        AttributeTransformationDescriptionBuilder http = serverBuilder.addChildResource(UndertowExtension.HTTP_LISTENER_PATH).getAttributeBuilder();
        UndertowTransformers.addCommonListenerRules_EAP_7_0_0(http);
        http.end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)serverBuilder.addChildResource(UndertowExtension.AJP_LISTENER_PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{ListenerResourceDefinition.RFC6265_COOKIE_VALIDATION})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ListenerResourceDefinition.RFC6265_COOKIE_VALIDATION})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(UndertowExtension.PATH_SERVLET_CONTAINER).getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{ServletContainerDefinition.DISABLE_FILE_WATCH_SERVICE, ServletContainerDefinition.DISABLE_SESSION_ID_REUSE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ServletContainerDefinition.DISABLE_FILE_WATCH_SERVICE, ServletContainerDefinition.DISABLE_SESSION_ID_REUSE})).end().addChildResource(UndertowExtension.PATH_WEBSOCKETS).getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{WebsocketsDefinition.PER_MESSAGE_DEFLATE, WebsocketsDefinition.DEFLATER_LEVEL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebsocketsDefinition.PER_MESSAGE_DEFLATE, WebsocketsDefinition.DEFLATER_LEVEL})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(UndertowExtension.PATH_HANDLERS).addChildResource(PathElement.pathElement((String)"reverse-proxy")).getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{ReverseProxyHandler.MAX_RETRIES})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ReverseProxyHandler.MAX_RETRIES})).setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{ReverseProxyHandler.CONNECTIONS_PER_THREAD})).end().addChildResource(PathElement.pathElement((String)"host")).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{HttpsListenerResourceDefinition.SSL_CONTEXT})).setDiscard(DiscardAttributeChecker.ALWAYS, new String[]{"enable-http2"})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{HttpsListenerResourceDefinition.SSL_CONTEXT})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(UndertowExtension.PATH_FILTERS).addChildResource(PathElement.pathElement((String)"mod-cluster")).getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{ModClusterDefinition.FAILOVER_STRATEGY, ModClusterDefinition.MAX_RETRIES})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{HttpsListenerResourceDefinition.SSL_CONTEXT})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{ModClusterDefinition.MAX_AJP_PACKET_SIZE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ModClusterDefinition.MAX_RETRIES, ModClusterDefinition.FAILOVER_STRATEGY, HttpsListenerResourceDefinition.SSL_CONTEXT})).addRejectCheck(RejectAttributeChecker.UNDEFINED, new String[]{"security-realm"})).setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{ModClusterDefinition.MAX_AJP_PACKET_SIZE})).end();
        hostBuilder.rejectChildResource(UndertowExtension.PATH_HTTP_INVOKER);
        subsystemBuilder.rejectChildResource(UndertowExtension.PATH_APPLICATION_SECURITY_DOMAIN);
    }

    private static AttributeTransformationDescriptionBuilder addCommonListenerRules_EAP_7_0_0(AttributeTransformationDescriptionBuilder builder) {
        return (AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{HttpListenerResourceDefinition.REQUIRE_HOST_HTTP11, ListenerResourceDefinition.RFC6265_COOKIE_VALIDATION})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{HttpListenerResourceDefinition.REQUIRE_HOST_HTTP11, ListenerResourceDefinition.RFC6265_COOKIE_VALIDATION})).setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{HttpListenerResourceDefinition.HTTP2_HEADER_TABLE_SIZE, HttpListenerResourceDefinition.HTTP2_INITIAL_WINDOW_SIZE, HttpListenerResourceDefinition.HTTP2_MAX_FRAME_SIZE});
    }

    private static AttributeTransformationDescriptionBuilder convertCommonListenerAttributes(AttributeTransformationDescriptionBuilder builder) {
        builder.setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

            protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                if (attributeValue.isDefined() && attributeValue.asLong() == 0L) {
                    attributeValue.set(Long.MAX_VALUE);
                }
            }
        }, new AttributeDefinition[]{ListenerResourceDefinition.MAX_ENTITY_SIZE});
        return builder;
    }
}

