/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.schedule.attribute;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.as.ejb3.timerservice.schedule.attribute.IntegerBasedExpression;
import org.jboss.as.ejb3.timerservice.schedule.value.ScheduleExpressionType;

public class DayOfWeek
extends IntegerBasedExpression {
    public static final Integer MAX_DAY_OF_WEEK = 7;
    public static final Integer MIN_DAY_OF_WEEK = 0;
    private static final Map<String, Integer> DAY_OF_WEEK_ALIAS = new HashMap<String, Integer>();
    private static final int OFFSET;
    private SortedSet<Integer> offsetAdjustedDaysOfWeek = new TreeSet<Integer>();

    public DayOfWeek(String value) {
        super(value);
        for (Integer dayOfWeek : this.absoluteValues) {
            if (dayOfWeek != 7) continue;
            this.absoluteValues.remove(dayOfWeek);
            this.absoluteValues.add(0);
        }
        if (OFFSET != 0) {
            for (Integer dayOfWeek : this.absoluteValues) {
                this.offsetAdjustedDaysOfWeek.add(dayOfWeek - OFFSET);
            }
        } else {
            this.offsetAdjustedDaysOfWeek = this.absoluteValues;
        }
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_DAY_OF_WEEK;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_DAY_OF_WEEK;
    }

    public int getFirst() {
        if (this.scheduleExpressionType == ScheduleExpressionType.WILDCARD) {
            return 1;
        }
        return this.offsetAdjustedDaysOfWeek.first();
    }

    public static Set<String> getDaysOfWeek() {
        return DAY_OF_WEEK_ALIAS.keySet();
    }

    @Override
    protected boolean accepts(ScheduleExpressionType scheduleExprType) {
        switch (scheduleExprType) {
            case RANGE: 
            case LIST: 
            case SINGLE_VALUE: 
            case WILDCARD: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isRelativeValue(String value) {
        return false;
    }

    @Override
    protected Integer parseInt(String alias) {
        try {
            return super.parseInt(alias);
        }
        catch (NumberFormatException nfe) {
            if (DAY_OF_WEEK_ALIAS != null) {
                String lowerCaseAlias = alias.toLowerCase(Locale.ENGLISH);
                return DAY_OF_WEEK_ALIAS.get(lowerCaseAlias);
            }
            return null;
        }
    }

    public Integer getNextMatch(Calendar currentCal) {
        if (this.scheduleExpressionType == ScheduleExpressionType.WILDCARD) {
            return currentCal.get(7);
        }
        int currentDayOfWeek = currentCal.get(7);
        for (Integer dayOfWeek : this.offsetAdjustedDaysOfWeek) {
            if (currentDayOfWeek == dayOfWeek) {
                return currentDayOfWeek;
            }
            if (dayOfWeek <= currentDayOfWeek) continue;
            return dayOfWeek;
        }
        return this.offsetAdjustedDaysOfWeek.first();
    }

    static {
        DAY_OF_WEEK_ALIAS.put("sun", 0);
        DAY_OF_WEEK_ALIAS.put("mon", 1);
        DAY_OF_WEEK_ALIAS.put("tue", 2);
        DAY_OF_WEEK_ALIAS.put("wed", 3);
        DAY_OF_WEEK_ALIAS.put("thu", 4);
        DAY_OF_WEEK_ALIAS.put("fri", 5);
        DAY_OF_WEEK_ALIAS.put("sat", 6);
        OFFSET = DAY_OF_WEEK_ALIAS.get("sun") - 1;
    }
}

