/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.test;

import io.smallrye.mutiny.helpers.test.AssertSubscriber;
import io.smallrye.mutiny.helpers.test.AssertionHelper;
import io.smallrye.mutiny.helpers.test.OnCancellationUniSignal;
import io.smallrye.mutiny.helpers.test.OnFailureUniSignal;
import io.smallrye.mutiny.helpers.test.OnItemUniSignal;
import io.smallrye.mutiny.helpers.test.OnSubscribeUniSignal;
import io.smallrye.mutiny.helpers.test.UniSignal;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class UniAssertSubscriber<T>
implements UniSubscriber<T> {
    private volatile boolean cancelImmediatelyOnSubscription;
    private final CompletableFuture<T> completion = new CompletableFuture();
    private final CompletableFuture<UniSubscription> subscribed = new CompletableFuture();
    private final CompletableFuture<T> hasCompleted;
    private final CompletableFuture<UniSubscription> hasSubscription;
    private volatile UniSubscription subscription;
    private volatile T item;
    private volatile Throwable failure;
    private volatile boolean hasCompletedSuccessfully;
    private volatile String onResultThreadName;
    private volatile String onErrorThreadName;
    private volatile String onSubscribeThreadName;
    private final List<UniSignal> signals = new ArrayList<UniSignal>(4);

    public UniAssertSubscriber(boolean cancelled) {
        this.hasCompleted = ((CompletableFuture)this.completion.whenComplete((item, failure) -> {
            if (failure == null) {
                this.onResultThreadName = Thread.currentThread().getName();
                this.hasCompletedSuccessfully = true;
                this.item = item;
            } else {
                this.onErrorThreadName = Thread.currentThread().getName();
                this.failure = failure;
            }
        })).toCompletableFuture();
        this.hasSubscription = ((CompletableFuture)this.subscribed.thenApply(s -> {
            this.onSubscribeThreadName = Thread.currentThread().getName();
            this.subscription = s;
            return s;
        })).toCompletableFuture();
        this.cancelImmediatelyOnSubscription = cancelled;
    }

    public UniAssertSubscriber() {
        this(false);
    }

    public static <T> UniAssertSubscriber<T> create() {
        return new UniAssertSubscriber<T>();
    }

    @Override
    public synchronized void onSubscribe(UniSubscription subscription) {
        this.signals.add(new OnSubscribeUniSignal(subscription));
        this.subscribed.complete(subscription);
        if (this.cancelImmediatelyOnSubscription) {
            subscription.cancel();
            this.completion.cancel(false);
        }
    }

    @Override
    public synchronized void onItem(T item) {
        this.signals.add(new OnItemUniSignal<T>(item));
        this.completion.complete(item);
    }

    @Override
    public synchronized void onFailure(Throwable failure) {
        this.signals.add(new OnFailureUniSignal(failure));
        this.completion.completeExceptionally(failure);
    }

    public UniAssertSubscriber<T> awaitItem() {
        return this.awaitItem(AssertSubscriber.DEFAULT_TIMEOUT);
    }

    public UniAssertSubscriber<T> awaitItem(Duration duration) {
        try {
            this.awaitEvent(this.hasCompleted, duration);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)("No item (or failure) event received in the last " + duration.toMillis() + " ms"));
        }
        if (this.failure == null) {
            return this;
        }
        throw new AssertionError((Object)("Expected an item event but got a failure: " + this.failure));
    }

    public UniAssertSubscriber<T> awaitFailure() {
        return this.awaitFailure((Throwable t) -> {});
    }

    public UniAssertSubscriber<T> awaitFailure(Consumer<Throwable> assertion) {
        return this.awaitFailure(assertion, AssertSubscriber.DEFAULT_TIMEOUT);
    }

    public UniAssertSubscriber<T> awaitFailure(Duration duration) {
        return this.awaitFailure(t -> {}, duration);
    }

    public UniAssertSubscriber<T> awaitFailure(Consumer<Throwable> assertion, Duration duration) {
        try {
            this.awaitEvent(this.hasCompleted, duration);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)("No item (or failure) event received in the last " + duration.toMillis() + " ms"));
        }
        if (this.failure == null) {
            throw new AssertionError((Object)("Expected a failure event but got an item event: " + this.item));
        }
        try {
            assertion.accept(this.failure);
            return this;
        }
        catch (AssertionError e) {
            throw new AssertionError("Received a failure event, but that failure did not pass the validation: " + e, (Throwable)((Object)e));
        }
    }

    public UniAssertSubscriber<T> awaitSubscription() {
        return this.awaitSubscription(AssertSubscriber.DEFAULT_TIMEOUT);
    }

    public UniAssertSubscriber<T> awaitSubscription(Duration duration) {
        try {
            this.awaitEvent(this.hasSubscription, duration);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)("Expecting a subscription event in the last " + duration.toMillis() + " ms, but did not get it"));
        }
        return this;
    }

    private void awaitEvent(CompletableFuture<?> future, Duration duration) throws TimeoutException {
        if (future.isDone()) {
            return;
        }
        try {
            future.get(duration.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Deprecated
    public UniAssertSubscriber<T> await() {
        try {
            this.awaitEvent(this.hasCompleted, AssertSubscriber.DEFAULT_TIMEOUT);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)("Expected item or failure event in the last " + AssertSubscriber.DEFAULT_TIMEOUT.toMillis() + " ms, but didn't get any event."));
        }
        return this;
    }

    public synchronized UniAssertSubscriber<T> assertCompleted() {
        AssertionHelper.shouldHaveCompleted(this.hasCompletedSuccessfully, this.failure, null);
        return this;
    }

    public synchronized UniAssertSubscriber<T> assertFailed() {
        AssertionHelper.shouldHaveFailed(this.hasCompletedSuccessfully, this.failure, null, null);
        return this;
    }

    public synchronized T getItem() {
        return this.item;
    }

    public synchronized Throwable getFailure() {
        if (this.failure instanceof CancellationException) {
            return null;
        }
        return this.failure;
    }

    public UniAssertSubscriber<T> assertItem(T expected) {
        AssertionHelper.shouldHaveCompleted(this.hasCompletedSuccessfully, this.failure, null);
        AssertionHelper.shouldHaveReceived(this.getItem(), expected);
        return this;
    }

    public UniAssertSubscriber<T> assertFailedWith(Class<? extends Throwable> expectedTypeOfFailure, String expectedMessage) {
        AssertionHelper.shouldHaveFailed(this.hasCompletedSuccessfully, this.failure, expectedTypeOfFailure, expectedMessage);
        return this;
    }

    public UniAssertSubscriber<T> assertFailedWith(Class<? extends Throwable> expectedTypeOfFailure) {
        AssertionHelper.shouldHaveFailed(this.hasCompletedSuccessfully, this.failure, expectedTypeOfFailure, null);
        return this;
    }

    public String getOnItemThreadName() {
        return this.onResultThreadName;
    }

    public String getOnFailureThreadName() {
        return this.onErrorThreadName;
    }

    public String getOnSubscribeThreadName() {
        return this.onSubscribeThreadName;
    }

    public void cancel() {
        this.signals.add(new OnCancellationUniSignal());
        if (this.subscription == null) {
            this.cancelImmediatelyOnSubscription = true;
        } else {
            this.subscription.cancel();
        }
    }

    public UniAssertSubscriber<T> assertTerminated() {
        AssertionHelper.shouldBeTerminated(this.hasCompletedSuccessfully, this.failure);
        return this;
    }

    public UniAssertSubscriber<T> assertNotTerminated() {
        AssertionHelper.shouldNotBeTerminatedUni(this.hasCompletedSuccessfully, this.failure);
        return this;
    }

    public UniAssertSubscriber<T> assertSubscribed() {
        AssertionHelper.shouldBeSubscribed(this.subscription == null ? 0 : 1);
        return this;
    }

    public UniAssertSubscriber<T> assertNotSubscribed() {
        AssertionHelper.shouldNotBeSubscribed(this.subscription == null ? 0 : 1);
        return this;
    }

    public List<UniSignal> getSignals() {
        return Collections.unmodifiableList(this.signals);
    }

    public UniAssertSubscriber<T> assertSignalsReceivedInOrder() {
        if (this.signals.isEmpty()) {
            return this;
        }
        UniSignal firstSignal = this.signals.get(0);
        if (!(firstSignal instanceof OnSubscribeUniSignal) && !(firstSignal instanceof OnCancellationUniSignal)) {
            throw new AssertionError((Object)("The first signal is neither onSubscribe nor cancel but " + firstSignal));
        }
        int[] occurrences = new int[3];
        for (UniSignal signal : this.signals) {
            if (signal instanceof OnSubscribeUniSignal) {
                occurrences[0] = occurrences[0] + 1;
                continue;
            }
            if (signal instanceof OnItemUniSignal) {
                occurrences[1] = occurrences[1] + 1;
                continue;
            }
            if (!(signal instanceof OnFailureUniSignal)) continue;
            occurrences[2] = occurrences[2] + 1;
        }
        if (occurrences[0] > 1) {
            throw new AssertionError((Object)("There are more than 1 onSubscribe signals in " + this.signals));
        }
        if (occurrences[1] > 1) {
            throw new AssertionError((Object)("There are more than 1 onItem signals in " + this.signals));
        }
        if (occurrences[2] > 1) {
            throw new AssertionError((Object)("There are more than 1 onFailure signals in " + this.signals));
        }
        if (occurrences[1] == 1 && occurrences[2] == 1) {
            throw new AssertionError((Object)("There are both onItem and onFailure signals in " + this.signals));
        }
        return this;
    }
}

