/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context;

import javax.net.ssl.SSLContext;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context._private.MicroProfileReactiveMessagingKafkaLogger;

public class ElytronSSLContextRegistry {
    private static final ElytronSSLContextRegistry INSTANCE = new ElytronSSLContextRegistry();
    private static final ServiceName BASE_CLIENT_SSL_CONTEXT_NAME = ServiceName.of((String[])new String[]{"org", "wildfly", "security", "ssl-context"});
    private volatile ServiceRegistry serviceRegistry;

    private ElytronSSLContextRegistry() {
    }

    public static void setServiceRegistry(ServiceRegistry serviceRegistry) {
        ElytronSSLContextRegistry.INSTANCE.serviceRegistry = serviceRegistry;
    }

    static boolean isSSLContextInstalled(String name) {
        return INSTANCE.getSSLContextController(name) != null;
    }

    static SSLContext getInstalledSSLContext(String name) {
        ServiceController<SSLContext> controller = INSTANCE.getSSLContextController(name);
        if (controller == null) {
            throw MicroProfileReactiveMessagingKafkaLogger.LOGGER.noElytronClientSSLContext(name);
        }
        return (SSLContext)controller.getValue();
    }

    private ServiceController<SSLContext> getSSLContextController(String name) {
        return ElytronSSLContextRegistry.INSTANCE.serviceRegistry.getService(ElytronSSLContextRegistry.getSSLContextName(name));
    }

    static ServiceName getSSLContextName(String name) {
        return BASE_CLIENT_SSL_CONTEXT_NAME.append(new String[]{name});
    }
}

