/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.web.cache.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaData;

public class CompositeSessionMetaData
implements InvalidatableSessionMetaData {
    private final SessionCreationMetaData creationMetaData;
    private final SessionAccessMetaData accessMetaData;

    public CompositeSessionMetaData(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData) {
        this.creationMetaData = creationMetaData;
        this.accessMetaData = accessMetaData;
    }

    public boolean isNew() {
        return this.creationMetaData.isNew();
    }

    @Override
    public boolean isValid() {
        return this.creationMetaData.isValid();
    }

    @Override
    public boolean invalidate() {
        return this.creationMetaData.invalidate();
    }

    public Instant getCreationTime() {
        return this.creationMetaData.getCreationTime();
    }

    public Instant getLastAccessStartTime() {
        return this.getCreationTime().plus(this.accessMetaData.getSinceCreationDuration());
    }

    public Instant getLastAccessEndTime() {
        return this.getLastAccessStartTime().plus(this.accessMetaData.getLastAccessDuration());
    }

    public Duration getMaxInactiveInterval() {
        return this.creationMetaData.getMaxInactiveInterval();
    }

    public void setLastAccess(Instant startTime, Instant endTime) {
        Instant creationTime = this.creationMetaData.getCreationTime();
        this.accessMetaData.setLastAccessDuration(!startTime.equals(creationTime) ? Duration.between(creationTime, startTime) : Duration.ZERO, Duration.between(startTime, endTime));
    }

    public void setMaxInactiveInterval(Duration duration) {
        this.creationMetaData.setMaxInactiveInterval(duration.isNegative() ? Duration.ZERO : duration);
    }

    @Override
    public void close() {
        this.creationMetaData.close();
    }
}

